/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.ConditionOutcome;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ConditionStepMetadata
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ConditionStepMetadata> {
    private static final SdkField<String> OUTCOME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Outcome").getter(ConditionStepMetadata.getter(ConditionStepMetadata::outcomeAsString)).setter(ConditionStepMetadata.setter(Builder::outcome)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Outcome").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OUTCOME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String outcome;

    private ConditionStepMetadata(BuilderImpl builder) {
        this.outcome = builder.outcome;
    }

    public ConditionOutcome outcome() {
        return ConditionOutcome.fromValue(this.outcome);
    }

    public String outcomeAsString() {
        return this.outcome;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.outcomeAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConditionStepMetadata)) {
            return false;
        }
        ConditionStepMetadata other = (ConditionStepMetadata)obj;
        return Objects.equals(this.outcomeAsString(), other.outcomeAsString());
    }

    public String toString() {
        return ToString.builder((String)"ConditionStepMetadata").add("Outcome", (Object)this.outcomeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Outcome": {
                return Optional.ofNullable(clazz.cast(this.outcomeAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ConditionStepMetadata, T> g) {
        return obj -> g.apply((ConditionStepMetadata)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String outcome;

        private BuilderImpl() {
        }

        private BuilderImpl(ConditionStepMetadata model) {
            this.outcome(model.outcome);
        }

        public final String getOutcome() {
            return this.outcome;
        }

        @Override
        public final Builder outcome(String outcome) {
            this.outcome = outcome;
            return this;
        }

        @Override
        public final Builder outcome(ConditionOutcome outcome) {
            this.outcome(outcome == null ? null : outcome.toString());
            return this;
        }

        public final void setOutcome(String outcome) {
            this.outcome = outcome;
        }

        public ConditionStepMetadata build() {
            return new ConditionStepMetadata(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ConditionStepMetadata> {
        public Builder outcome(String var1);

        public Builder outcome(ConditionOutcome var1);
    }
}

