/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.sagemaker.model.LineageEntityParametersCopier;
import software.amazon.awssdk.services.sagemaker.model.ListLineageEntityParameterKeyCopier;
import software.amazon.awssdk.services.sagemaker.model.SageMakerRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateContextRequest
extends SageMakerRequest
implements ToCopyableBuilder<Builder, UpdateContextRequest> {
    private static final SdkField<String> CONTEXT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ContextName").getter(UpdateContextRequest.getter(UpdateContextRequest::contextName)).setter(UpdateContextRequest.setter(Builder::contextName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContextName").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(UpdateContextRequest.getter(UpdateContextRequest::description)).setter(UpdateContextRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<Map<String, String>> PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Properties").getter(UpdateContextRequest.getter(UpdateContextRequest::properties)).setter(UpdateContextRequest.setter(Builder::properties)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Properties").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<List<String>> PROPERTIES_TO_REMOVE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PropertiesToRemove").getter(UpdateContextRequest.getter(UpdateContextRequest::propertiesToRemove)).setter(UpdateContextRequest.setter(Builder::propertiesToRemove)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PropertiesToRemove").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTEXT_NAME_FIELD, DESCRIPTION_FIELD, PROPERTIES_FIELD, PROPERTIES_TO_REMOVE_FIELD));
    private final String contextName;
    private final String description;
    private final Map<String, String> properties;
    private final List<String> propertiesToRemove;

    private UpdateContextRequest(BuilderImpl builder) {
        super(builder);
        this.contextName = builder.contextName;
        this.description = builder.description;
        this.properties = builder.properties;
        this.propertiesToRemove = builder.propertiesToRemove;
    }

    public String contextName() {
        return this.contextName;
    }

    public String description() {
        return this.description;
    }

    public boolean hasProperties() {
        return this.properties != null && !(this.properties instanceof SdkAutoConstructMap);
    }

    public Map<String, String> properties() {
        return this.properties;
    }

    public boolean hasPropertiesToRemove() {
        return this.propertiesToRemove != null && !(this.propertiesToRemove instanceof SdkAutoConstructList);
    }

    public List<String> propertiesToRemove() {
        return this.propertiesToRemove;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.contextName());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProperties() ? this.properties() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPropertiesToRemove() ? this.propertiesToRemove() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateContextRequest)) {
            return false;
        }
        UpdateContextRequest other = (UpdateContextRequest)((Object)obj);
        return Objects.equals(this.contextName(), other.contextName()) && Objects.equals(this.description(), other.description()) && this.hasProperties() == other.hasProperties() && Objects.equals(this.properties(), other.properties()) && this.hasPropertiesToRemove() == other.hasPropertiesToRemove() && Objects.equals(this.propertiesToRemove(), other.propertiesToRemove());
    }

    public String toString() {
        return ToString.builder((String)"UpdateContextRequest").add("ContextName", (Object)this.contextName()).add("Description", (Object)this.description()).add("Properties", this.hasProperties() ? this.properties() : null).add("PropertiesToRemove", this.hasPropertiesToRemove() ? this.propertiesToRemove() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ContextName": {
                return Optional.ofNullable(clazz.cast(this.contextName()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Properties": {
                return Optional.ofNullable(clazz.cast(this.properties()));
            }
            case "PropertiesToRemove": {
                return Optional.ofNullable(clazz.cast(this.propertiesToRemove()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateContextRequest, T> g) {
        return obj -> g.apply((UpdateContextRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerRequest.BuilderImpl
    implements Builder {
        private String contextName;
        private String description;
        private Map<String, String> properties = DefaultSdkAutoConstructMap.getInstance();
        private List<String> propertiesToRemove = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateContextRequest model) {
            super(model);
            this.contextName(model.contextName);
            this.description(model.description);
            this.properties(model.properties);
            this.propertiesToRemove(model.propertiesToRemove);
        }

        public final String getContextName() {
            return this.contextName;
        }

        @Override
        public final Builder contextName(String contextName) {
            this.contextName = contextName;
            return this;
        }

        public final void setContextName(String contextName) {
            this.contextName = contextName;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Map<String, String> getProperties() {
            if (this.properties instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.properties;
        }

        @Override
        public final Builder properties(Map<String, String> properties) {
            this.properties = LineageEntityParametersCopier.copy(properties);
            return this;
        }

        public final void setProperties(Map<String, String> properties) {
            this.properties = LineageEntityParametersCopier.copy(properties);
        }

        public final Collection<String> getPropertiesToRemove() {
            if (this.propertiesToRemove instanceof SdkAutoConstructList) {
                return null;
            }
            return this.propertiesToRemove;
        }

        @Override
        public final Builder propertiesToRemove(Collection<String> propertiesToRemove) {
            this.propertiesToRemove = ListLineageEntityParameterKeyCopier.copy(propertiesToRemove);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder propertiesToRemove(String ... propertiesToRemove) {
            this.propertiesToRemove(Arrays.asList(propertiesToRemove));
            return this;
        }

        public final void setPropertiesToRemove(Collection<String> propertiesToRemove) {
            this.propertiesToRemove = ListLineageEntityParameterKeyCopier.copy(propertiesToRemove);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateContextRequest build() {
            return new UpdateContextRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SageMakerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateContextRequest> {
        public Builder contextName(String var1);

        public Builder description(String var1);

        public Builder properties(Map<String, String> var1);

        public Builder propertiesToRemove(Collection<String> var1);

        public Builder propertiesToRemove(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

