/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.FileSystemAccessMode;
import software.amazon.awssdk.services.sagemaker.model.FileSystemType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FileSystemDataSource
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FileSystemDataSource> {
    private static final SdkField<String> FILE_SYSTEM_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FileSystemId").getter(FileSystemDataSource.getter(FileSystemDataSource::fileSystemId)).setter(FileSystemDataSource.setter(Builder::fileSystemId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileSystemId").build()}).build();
    private static final SdkField<String> FILE_SYSTEM_ACCESS_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FileSystemAccessMode").getter(FileSystemDataSource.getter(FileSystemDataSource::fileSystemAccessModeAsString)).setter(FileSystemDataSource.setter(Builder::fileSystemAccessMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileSystemAccessMode").build()}).build();
    private static final SdkField<String> FILE_SYSTEM_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FileSystemType").getter(FileSystemDataSource.getter(FileSystemDataSource::fileSystemTypeAsString)).setter(FileSystemDataSource.setter(Builder::fileSystemType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileSystemType").build()}).build();
    private static final SdkField<String> DIRECTORY_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DirectoryPath").getter(FileSystemDataSource.getter(FileSystemDataSource::directoryPath)).setter(FileSystemDataSource.setter(Builder::directoryPath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DirectoryPath").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILE_SYSTEM_ID_FIELD, FILE_SYSTEM_ACCESS_MODE_FIELD, FILE_SYSTEM_TYPE_FIELD, DIRECTORY_PATH_FIELD));
    private static final long serialVersionUID = 1L;
    private final String fileSystemId;
    private final String fileSystemAccessMode;
    private final String fileSystemType;
    private final String directoryPath;

    private FileSystemDataSource(BuilderImpl builder) {
        this.fileSystemId = builder.fileSystemId;
        this.fileSystemAccessMode = builder.fileSystemAccessMode;
        this.fileSystemType = builder.fileSystemType;
        this.directoryPath = builder.directoryPath;
    }

    public String fileSystemId() {
        return this.fileSystemId;
    }

    public FileSystemAccessMode fileSystemAccessMode() {
        return FileSystemAccessMode.fromValue(this.fileSystemAccessMode);
    }

    public String fileSystemAccessModeAsString() {
        return this.fileSystemAccessMode;
    }

    public FileSystemType fileSystemType() {
        return FileSystemType.fromValue(this.fileSystemType);
    }

    public String fileSystemTypeAsString() {
        return this.fileSystemType;
    }

    public String directoryPath() {
        return this.directoryPath;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.fileSystemId());
        hashCode = 31 * hashCode + Objects.hashCode(this.fileSystemAccessModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.fileSystemTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.directoryPath());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FileSystemDataSource)) {
            return false;
        }
        FileSystemDataSource other = (FileSystemDataSource)obj;
        return Objects.equals(this.fileSystemId(), other.fileSystemId()) && Objects.equals(this.fileSystemAccessModeAsString(), other.fileSystemAccessModeAsString()) && Objects.equals(this.fileSystemTypeAsString(), other.fileSystemTypeAsString()) && Objects.equals(this.directoryPath(), other.directoryPath());
    }

    public String toString() {
        return ToString.builder((String)"FileSystemDataSource").add("FileSystemId", (Object)this.fileSystemId()).add("FileSystemAccessMode", (Object)this.fileSystemAccessModeAsString()).add("FileSystemType", (Object)this.fileSystemTypeAsString()).add("DirectoryPath", (Object)this.directoryPath()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FileSystemId": {
                return Optional.ofNullable(clazz.cast(this.fileSystemId()));
            }
            case "FileSystemAccessMode": {
                return Optional.ofNullable(clazz.cast(this.fileSystemAccessModeAsString()));
            }
            case "FileSystemType": {
                return Optional.ofNullable(clazz.cast(this.fileSystemTypeAsString()));
            }
            case "DirectoryPath": {
                return Optional.ofNullable(clazz.cast(this.directoryPath()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FileSystemDataSource, T> g) {
        return obj -> g.apply((FileSystemDataSource)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String fileSystemId;
        private String fileSystemAccessMode;
        private String fileSystemType;
        private String directoryPath;

        private BuilderImpl() {
        }

        private BuilderImpl(FileSystemDataSource model) {
            this.fileSystemId(model.fileSystemId);
            this.fileSystemAccessMode(model.fileSystemAccessMode);
            this.fileSystemType(model.fileSystemType);
            this.directoryPath(model.directoryPath);
        }

        public final String getFileSystemId() {
            return this.fileSystemId;
        }

        @Override
        public final Builder fileSystemId(String fileSystemId) {
            this.fileSystemId = fileSystemId;
            return this;
        }

        public final void setFileSystemId(String fileSystemId) {
            this.fileSystemId = fileSystemId;
        }

        public final String getFileSystemAccessMode() {
            return this.fileSystemAccessMode;
        }

        @Override
        public final Builder fileSystemAccessMode(String fileSystemAccessMode) {
            this.fileSystemAccessMode = fileSystemAccessMode;
            return this;
        }

        @Override
        public final Builder fileSystemAccessMode(FileSystemAccessMode fileSystemAccessMode) {
            this.fileSystemAccessMode(fileSystemAccessMode == null ? null : fileSystemAccessMode.toString());
            return this;
        }

        public final void setFileSystemAccessMode(String fileSystemAccessMode) {
            this.fileSystemAccessMode = fileSystemAccessMode;
        }

        public final String getFileSystemType() {
            return this.fileSystemType;
        }

        @Override
        public final Builder fileSystemType(String fileSystemType) {
            this.fileSystemType = fileSystemType;
            return this;
        }

        @Override
        public final Builder fileSystemType(FileSystemType fileSystemType) {
            this.fileSystemType(fileSystemType == null ? null : fileSystemType.toString());
            return this;
        }

        public final void setFileSystemType(String fileSystemType) {
            this.fileSystemType = fileSystemType;
        }

        public final String getDirectoryPath() {
            return this.directoryPath;
        }

        @Override
        public final Builder directoryPath(String directoryPath) {
            this.directoryPath = directoryPath;
            return this;
        }

        public final void setDirectoryPath(String directoryPath) {
            this.directoryPath = directoryPath;
        }

        public FileSystemDataSource build() {
            return new FileSystemDataSource(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FileSystemDataSource> {
        public Builder fileSystemId(String var1);

        public Builder fileSystemAccessMode(String var1);

        public Builder fileSystemAccessMode(FileSystemAccessMode var1);

        public Builder fileSystemType(String var1);

        public Builder fileSystemType(FileSystemType var1);

        public Builder directoryPath(String var1);
    }
}

