/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.HyperParameterTrainingJobDefinition;
import software.amazon.awssdk.services.sagemaker.model.HyperParameterTrainingJobDefinitionsCopier;
import software.amazon.awssdk.services.sagemaker.model.HyperParameterTuningJobConfig;
import software.amazon.awssdk.services.sagemaker.model.HyperParameterTuningJobWarmStartConfig;
import software.amazon.awssdk.services.sagemaker.model.SageMakerRequest;
import software.amazon.awssdk.services.sagemaker.model.Tag;
import software.amazon.awssdk.services.sagemaker.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateHyperParameterTuningJobRequest
extends SageMakerRequest
implements ToCopyableBuilder<Builder, CreateHyperParameterTuningJobRequest> {
    private static final SdkField<String> HYPER_PARAMETER_TUNING_JOB_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HyperParameterTuningJobName").getter(CreateHyperParameterTuningJobRequest.getter(CreateHyperParameterTuningJobRequest::hyperParameterTuningJobName)).setter(CreateHyperParameterTuningJobRequest.setter(Builder::hyperParameterTuningJobName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HyperParameterTuningJobName").build()}).build();
    private static final SdkField<HyperParameterTuningJobConfig> HYPER_PARAMETER_TUNING_JOB_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("HyperParameterTuningJobConfig").getter(CreateHyperParameterTuningJobRequest.getter(CreateHyperParameterTuningJobRequest::hyperParameterTuningJobConfig)).setter(CreateHyperParameterTuningJobRequest.setter(Builder::hyperParameterTuningJobConfig)).constructor(HyperParameterTuningJobConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HyperParameterTuningJobConfig").build()}).build();
    private static final SdkField<HyperParameterTrainingJobDefinition> TRAINING_JOB_DEFINITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TrainingJobDefinition").getter(CreateHyperParameterTuningJobRequest.getter(CreateHyperParameterTuningJobRequest::trainingJobDefinition)).setter(CreateHyperParameterTuningJobRequest.setter(Builder::trainingJobDefinition)).constructor(HyperParameterTrainingJobDefinition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrainingJobDefinition").build()}).build();
    private static final SdkField<List<HyperParameterTrainingJobDefinition>> TRAINING_JOB_DEFINITIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TrainingJobDefinitions").getter(CreateHyperParameterTuningJobRequest.getter(CreateHyperParameterTuningJobRequest::trainingJobDefinitions)).setter(CreateHyperParameterTuningJobRequest.setter(Builder::trainingJobDefinitions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrainingJobDefinitions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(HyperParameterTrainingJobDefinition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<HyperParameterTuningJobWarmStartConfig> WARM_START_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("WarmStartConfig").getter(CreateHyperParameterTuningJobRequest.getter(CreateHyperParameterTuningJobRequest::warmStartConfig)).setter(CreateHyperParameterTuningJobRequest.setter(Builder::warmStartConfig)).constructor(HyperParameterTuningJobWarmStartConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WarmStartConfig").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateHyperParameterTuningJobRequest.getter(CreateHyperParameterTuningJobRequest::tags)).setter(CreateHyperParameterTuningJobRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HYPER_PARAMETER_TUNING_JOB_NAME_FIELD, HYPER_PARAMETER_TUNING_JOB_CONFIG_FIELD, TRAINING_JOB_DEFINITION_FIELD, TRAINING_JOB_DEFINITIONS_FIELD, WARM_START_CONFIG_FIELD, TAGS_FIELD));
    private final String hyperParameterTuningJobName;
    private final HyperParameterTuningJobConfig hyperParameterTuningJobConfig;
    private final HyperParameterTrainingJobDefinition trainingJobDefinition;
    private final List<HyperParameterTrainingJobDefinition> trainingJobDefinitions;
    private final HyperParameterTuningJobWarmStartConfig warmStartConfig;
    private final List<Tag> tags;

    private CreateHyperParameterTuningJobRequest(BuilderImpl builder) {
        super(builder);
        this.hyperParameterTuningJobName = builder.hyperParameterTuningJobName;
        this.hyperParameterTuningJobConfig = builder.hyperParameterTuningJobConfig;
        this.trainingJobDefinition = builder.trainingJobDefinition;
        this.trainingJobDefinitions = builder.trainingJobDefinitions;
        this.warmStartConfig = builder.warmStartConfig;
        this.tags = builder.tags;
    }

    public String hyperParameterTuningJobName() {
        return this.hyperParameterTuningJobName;
    }

    public HyperParameterTuningJobConfig hyperParameterTuningJobConfig() {
        return this.hyperParameterTuningJobConfig;
    }

    public HyperParameterTrainingJobDefinition trainingJobDefinition() {
        return this.trainingJobDefinition;
    }

    public boolean hasTrainingJobDefinitions() {
        return this.trainingJobDefinitions != null && !(this.trainingJobDefinitions instanceof SdkAutoConstructList);
    }

    public List<HyperParameterTrainingJobDefinition> trainingJobDefinitions() {
        return this.trainingJobDefinitions;
    }

    public HyperParameterTuningJobWarmStartConfig warmStartConfig() {
        return this.warmStartConfig;
    }

    public boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hyperParameterTuningJobName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hyperParameterTuningJobConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.trainingJobDefinition());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTrainingJobDefinitions() ? this.trainingJobDefinitions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.warmStartConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateHyperParameterTuningJobRequest)) {
            return false;
        }
        CreateHyperParameterTuningJobRequest other = (CreateHyperParameterTuningJobRequest)((Object)obj);
        return Objects.equals(this.hyperParameterTuningJobName(), other.hyperParameterTuningJobName()) && Objects.equals(this.hyperParameterTuningJobConfig(), other.hyperParameterTuningJobConfig()) && Objects.equals(this.trainingJobDefinition(), other.trainingJobDefinition()) && this.hasTrainingJobDefinitions() == other.hasTrainingJobDefinitions() && Objects.equals(this.trainingJobDefinitions(), other.trainingJobDefinitions()) && Objects.equals(this.warmStartConfig(), other.warmStartConfig()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public String toString() {
        return ToString.builder((String)"CreateHyperParameterTuningJobRequest").add("HyperParameterTuningJobName", (Object)this.hyperParameterTuningJobName()).add("HyperParameterTuningJobConfig", (Object)this.hyperParameterTuningJobConfig()).add("TrainingJobDefinition", (Object)this.trainingJobDefinition()).add("TrainingJobDefinitions", this.hasTrainingJobDefinitions() ? this.trainingJobDefinitions() : null).add("WarmStartConfig", (Object)this.warmStartConfig()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "HyperParameterTuningJobName": {
                return Optional.ofNullable(clazz.cast(this.hyperParameterTuningJobName()));
            }
            case "HyperParameterTuningJobConfig": {
                return Optional.ofNullable(clazz.cast(this.hyperParameterTuningJobConfig()));
            }
            case "TrainingJobDefinition": {
                return Optional.ofNullable(clazz.cast(this.trainingJobDefinition()));
            }
            case "TrainingJobDefinitions": {
                return Optional.ofNullable(clazz.cast(this.trainingJobDefinitions()));
            }
            case "WarmStartConfig": {
                return Optional.ofNullable(clazz.cast(this.warmStartConfig()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateHyperParameterTuningJobRequest, T> g) {
        return obj -> g.apply((CreateHyperParameterTuningJobRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerRequest.BuilderImpl
    implements Builder {
        private String hyperParameterTuningJobName;
        private HyperParameterTuningJobConfig hyperParameterTuningJobConfig;
        private HyperParameterTrainingJobDefinition trainingJobDefinition;
        private List<HyperParameterTrainingJobDefinition> trainingJobDefinitions = DefaultSdkAutoConstructList.getInstance();
        private HyperParameterTuningJobWarmStartConfig warmStartConfig;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateHyperParameterTuningJobRequest model) {
            super(model);
            this.hyperParameterTuningJobName(model.hyperParameterTuningJobName);
            this.hyperParameterTuningJobConfig(model.hyperParameterTuningJobConfig);
            this.trainingJobDefinition(model.trainingJobDefinition);
            this.trainingJobDefinitions(model.trainingJobDefinitions);
            this.warmStartConfig(model.warmStartConfig);
            this.tags(model.tags);
        }

        public final String getHyperParameterTuningJobName() {
            return this.hyperParameterTuningJobName;
        }

        @Override
        public final Builder hyperParameterTuningJobName(String hyperParameterTuningJobName) {
            this.hyperParameterTuningJobName = hyperParameterTuningJobName;
            return this;
        }

        public final void setHyperParameterTuningJobName(String hyperParameterTuningJobName) {
            this.hyperParameterTuningJobName = hyperParameterTuningJobName;
        }

        public final HyperParameterTuningJobConfig.Builder getHyperParameterTuningJobConfig() {
            return this.hyperParameterTuningJobConfig != null ? this.hyperParameterTuningJobConfig.toBuilder() : null;
        }

        @Override
        public final Builder hyperParameterTuningJobConfig(HyperParameterTuningJobConfig hyperParameterTuningJobConfig) {
            this.hyperParameterTuningJobConfig = hyperParameterTuningJobConfig;
            return this;
        }

        public final void setHyperParameterTuningJobConfig(HyperParameterTuningJobConfig.BuilderImpl hyperParameterTuningJobConfig) {
            this.hyperParameterTuningJobConfig = hyperParameterTuningJobConfig != null ? hyperParameterTuningJobConfig.build() : null;
        }

        public final HyperParameterTrainingJobDefinition.Builder getTrainingJobDefinition() {
            return this.trainingJobDefinition != null ? this.trainingJobDefinition.toBuilder() : null;
        }

        @Override
        public final Builder trainingJobDefinition(HyperParameterTrainingJobDefinition trainingJobDefinition) {
            this.trainingJobDefinition = trainingJobDefinition;
            return this;
        }

        public final void setTrainingJobDefinition(HyperParameterTrainingJobDefinition.BuilderImpl trainingJobDefinition) {
            this.trainingJobDefinition = trainingJobDefinition != null ? trainingJobDefinition.build() : null;
        }

        public final Collection<HyperParameterTrainingJobDefinition.Builder> getTrainingJobDefinitions() {
            if (this.trainingJobDefinitions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.trainingJobDefinitions != null ? (Collection)this.trainingJobDefinitions.stream().map(HyperParameterTrainingJobDefinition::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder trainingJobDefinitions(Collection<HyperParameterTrainingJobDefinition> trainingJobDefinitions) {
            this.trainingJobDefinitions = HyperParameterTrainingJobDefinitionsCopier.copy(trainingJobDefinitions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder trainingJobDefinitions(HyperParameterTrainingJobDefinition ... trainingJobDefinitions) {
            this.trainingJobDefinitions(Arrays.asList(trainingJobDefinitions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder trainingJobDefinitions(Consumer<HyperParameterTrainingJobDefinition.Builder> ... trainingJobDefinitions) {
            this.trainingJobDefinitions(Stream.of(trainingJobDefinitions).map(c -> (HyperParameterTrainingJobDefinition)((HyperParameterTrainingJobDefinition.Builder)HyperParameterTrainingJobDefinition.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTrainingJobDefinitions(Collection<HyperParameterTrainingJobDefinition.BuilderImpl> trainingJobDefinitions) {
            this.trainingJobDefinitions = HyperParameterTrainingJobDefinitionsCopier.copyFromBuilder(trainingJobDefinitions);
        }

        public final HyperParameterTuningJobWarmStartConfig.Builder getWarmStartConfig() {
            return this.warmStartConfig != null ? this.warmStartConfig.toBuilder() : null;
        }

        @Override
        public final Builder warmStartConfig(HyperParameterTuningJobWarmStartConfig warmStartConfig) {
            this.warmStartConfig = warmStartConfig;
            return this;
        }

        public final void setWarmStartConfig(HyperParameterTuningJobWarmStartConfig.BuilderImpl warmStartConfig) {
            this.warmStartConfig = warmStartConfig != null ? warmStartConfig.build() : null;
        }

        public final Collection<Tag.Builder> getTags() {
            if (this.tags instanceof SdkAutoConstructList) {
                return null;
            }
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateHyperParameterTuningJobRequest build() {
            return new CreateHyperParameterTuningJobRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SageMakerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateHyperParameterTuningJobRequest> {
        public Builder hyperParameterTuningJobName(String var1);

        public Builder hyperParameterTuningJobConfig(HyperParameterTuningJobConfig var1);

        default public Builder hyperParameterTuningJobConfig(Consumer<HyperParameterTuningJobConfig.Builder> hyperParameterTuningJobConfig) {
            return this.hyperParameterTuningJobConfig((HyperParameterTuningJobConfig)((HyperParameterTuningJobConfig.Builder)HyperParameterTuningJobConfig.builder().applyMutation(hyperParameterTuningJobConfig)).build());
        }

        public Builder trainingJobDefinition(HyperParameterTrainingJobDefinition var1);

        default public Builder trainingJobDefinition(Consumer<HyperParameterTrainingJobDefinition.Builder> trainingJobDefinition) {
            return this.trainingJobDefinition((HyperParameterTrainingJobDefinition)((HyperParameterTrainingJobDefinition.Builder)HyperParameterTrainingJobDefinition.builder().applyMutation(trainingJobDefinition)).build());
        }

        public Builder trainingJobDefinitions(Collection<HyperParameterTrainingJobDefinition> var1);

        public Builder trainingJobDefinitions(HyperParameterTrainingJobDefinition ... var1);

        public Builder trainingJobDefinitions(Consumer<HyperParameterTrainingJobDefinition.Builder> ... var1);

        public Builder warmStartConfig(HyperParameterTuningJobWarmStartConfig var1);

        default public Builder warmStartConfig(Consumer<HyperParameterTuningJobWarmStartConfig.Builder> warmStartConfig) {
            return this.warmStartConfig((HyperParameterTuningJobWarmStartConfig)((HyperParameterTuningJobWarmStartConfig.Builder)HyperParameterTuningJobWarmStartConfig.builder().applyMutation(warmStartConfig)).build());
        }

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

