/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.GitConfig;
import software.amazon.awssdk.services.sagemaker.model.SageMakerRequest;
import software.amazon.awssdk.services.sagemaker.model.Tag;
import software.amazon.awssdk.services.sagemaker.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateCodeRepositoryRequest
extends SageMakerRequest
implements ToCopyableBuilder<Builder, CreateCodeRepositoryRequest> {
    private static final SdkField<String> CODE_REPOSITORY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CodeRepositoryName").getter(CreateCodeRepositoryRequest.getter(CreateCodeRepositoryRequest::codeRepositoryName)).setter(CreateCodeRepositoryRequest.setter(Builder::codeRepositoryName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CodeRepositoryName").build()}).build();
    private static final SdkField<GitConfig> GIT_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("GitConfig").getter(CreateCodeRepositoryRequest.getter(CreateCodeRepositoryRequest::gitConfig)).setter(CreateCodeRepositoryRequest.setter(Builder::gitConfig)).constructor(GitConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GitConfig").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateCodeRepositoryRequest.getter(CreateCodeRepositoryRequest::tags)).setter(CreateCodeRepositoryRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CODE_REPOSITORY_NAME_FIELD, GIT_CONFIG_FIELD, TAGS_FIELD));
    private final String codeRepositoryName;
    private final GitConfig gitConfig;
    private final List<Tag> tags;

    private CreateCodeRepositoryRequest(BuilderImpl builder) {
        super(builder);
        this.codeRepositoryName = builder.codeRepositoryName;
        this.gitConfig = builder.gitConfig;
        this.tags = builder.tags;
    }

    public String codeRepositoryName() {
        return this.codeRepositoryName;
    }

    public GitConfig gitConfig() {
        return this.gitConfig;
    }

    public boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.codeRepositoryName());
        hashCode = 31 * hashCode + Objects.hashCode(this.gitConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCodeRepositoryRequest)) {
            return false;
        }
        CreateCodeRepositoryRequest other = (CreateCodeRepositoryRequest)((Object)obj);
        return Objects.equals(this.codeRepositoryName(), other.codeRepositoryName()) && Objects.equals(this.gitConfig(), other.gitConfig()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public String toString() {
        return ToString.builder((String)"CreateCodeRepositoryRequest").add("CodeRepositoryName", (Object)this.codeRepositoryName()).add("GitConfig", (Object)this.gitConfig()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CodeRepositoryName": {
                return Optional.ofNullable(clazz.cast(this.codeRepositoryName()));
            }
            case "GitConfig": {
                return Optional.ofNullable(clazz.cast(this.gitConfig()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateCodeRepositoryRequest, T> g) {
        return obj -> g.apply((CreateCodeRepositoryRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerRequest.BuilderImpl
    implements Builder {
        private String codeRepositoryName;
        private GitConfig gitConfig;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateCodeRepositoryRequest model) {
            super(model);
            this.codeRepositoryName(model.codeRepositoryName);
            this.gitConfig(model.gitConfig);
            this.tags(model.tags);
        }

        public final String getCodeRepositoryName() {
            return this.codeRepositoryName;
        }

        @Override
        public final Builder codeRepositoryName(String codeRepositoryName) {
            this.codeRepositoryName = codeRepositoryName;
            return this;
        }

        public final void setCodeRepositoryName(String codeRepositoryName) {
            this.codeRepositoryName = codeRepositoryName;
        }

        public final GitConfig.Builder getGitConfig() {
            return this.gitConfig != null ? this.gitConfig.toBuilder() : null;
        }

        @Override
        public final Builder gitConfig(GitConfig gitConfig) {
            this.gitConfig = gitConfig;
            return this;
        }

        public final void setGitConfig(GitConfig.BuilderImpl gitConfig) {
            this.gitConfig = gitConfig != null ? gitConfig.build() : null;
        }

        public final Collection<Tag.Builder> getTags() {
            if (this.tags instanceof SdkAutoConstructList) {
                return null;
            }
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateCodeRepositoryRequest build() {
            return new CreateCodeRepositoryRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SageMakerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateCodeRepositoryRequest> {
        public Builder codeRepositoryName(String var1);

        public Builder gitConfig(GitConfig var1);

        default public Builder gitConfig(Consumer<GitConfig.Builder> gitConfig) {
            return this.gitConfig((GitConfig)((GitConfig.Builder)GitConfig.builder().applyMutation(gitConfig)).build());
        }

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

