/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.sagemaker.model.FinalHyperParameterTuningJobObjectiveMetric;
import software.amazon.awssdk.services.sagemaker.model.HyperParametersCopier;
import software.amazon.awssdk.services.sagemaker.model.ObjectiveStatus;
import software.amazon.awssdk.services.sagemaker.model.TrainingJobStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class HyperParameterTrainingJobSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, HyperParameterTrainingJobSummary> {
    private static final SdkField<String> TRAINING_JOB_DEFINITION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TrainingJobDefinitionName").getter(HyperParameterTrainingJobSummary.getter(HyperParameterTrainingJobSummary::trainingJobDefinitionName)).setter(HyperParameterTrainingJobSummary.setter(Builder::trainingJobDefinitionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrainingJobDefinitionName").build()}).build();
    private static final SdkField<String> TRAINING_JOB_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TrainingJobName").getter(HyperParameterTrainingJobSummary.getter(HyperParameterTrainingJobSummary::trainingJobName)).setter(HyperParameterTrainingJobSummary.setter(Builder::trainingJobName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrainingJobName").build()}).build();
    private static final SdkField<String> TRAINING_JOB_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TrainingJobArn").getter(HyperParameterTrainingJobSummary.getter(HyperParameterTrainingJobSummary::trainingJobArn)).setter(HyperParameterTrainingJobSummary.setter(Builder::trainingJobArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrainingJobArn").build()}).build();
    private static final SdkField<String> TUNING_JOB_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TuningJobName").getter(HyperParameterTrainingJobSummary.getter(HyperParameterTrainingJobSummary::tuningJobName)).setter(HyperParameterTrainingJobSummary.setter(Builder::tuningJobName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TuningJobName").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(HyperParameterTrainingJobSummary.getter(HyperParameterTrainingJobSummary::creationTime)).setter(HyperParameterTrainingJobSummary.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<Instant> TRAINING_START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("TrainingStartTime").getter(HyperParameterTrainingJobSummary.getter(HyperParameterTrainingJobSummary::trainingStartTime)).setter(HyperParameterTrainingJobSummary.setter(Builder::trainingStartTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrainingStartTime").build()}).build();
    private static final SdkField<Instant> TRAINING_END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("TrainingEndTime").getter(HyperParameterTrainingJobSummary.getter(HyperParameterTrainingJobSummary::trainingEndTime)).setter(HyperParameterTrainingJobSummary.setter(Builder::trainingEndTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrainingEndTime").build()}).build();
    private static final SdkField<String> TRAINING_JOB_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TrainingJobStatus").getter(HyperParameterTrainingJobSummary.getter(HyperParameterTrainingJobSummary::trainingJobStatusAsString)).setter(HyperParameterTrainingJobSummary.setter(Builder::trainingJobStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrainingJobStatus").build()}).build();
    private static final SdkField<Map<String, String>> TUNED_HYPER_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("TunedHyperParameters").getter(HyperParameterTrainingJobSummary.getter(HyperParameterTrainingJobSummary::tunedHyperParameters)).setter(HyperParameterTrainingJobSummary.setter(Builder::tunedHyperParameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TunedHyperParameters").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FailureReason").getter(HyperParameterTrainingJobSummary.getter(HyperParameterTrainingJobSummary::failureReason)).setter(HyperParameterTrainingJobSummary.setter(Builder::failureReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureReason").build()}).build();
    private static final SdkField<FinalHyperParameterTuningJobObjectiveMetric> FINAL_HYPER_PARAMETER_TUNING_JOB_OBJECTIVE_METRIC_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FinalHyperParameterTuningJobObjectiveMetric").getter(HyperParameterTrainingJobSummary.getter(HyperParameterTrainingJobSummary::finalHyperParameterTuningJobObjectiveMetric)).setter(HyperParameterTrainingJobSummary.setter(Builder::finalHyperParameterTuningJobObjectiveMetric)).constructor(FinalHyperParameterTuningJobObjectiveMetric::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FinalHyperParameterTuningJobObjectiveMetric").build()}).build();
    private static final SdkField<String> OBJECTIVE_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ObjectiveStatus").getter(HyperParameterTrainingJobSummary.getter(HyperParameterTrainingJobSummary::objectiveStatusAsString)).setter(HyperParameterTrainingJobSummary.setter(Builder::objectiveStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ObjectiveStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRAINING_JOB_DEFINITION_NAME_FIELD, TRAINING_JOB_NAME_FIELD, TRAINING_JOB_ARN_FIELD, TUNING_JOB_NAME_FIELD, CREATION_TIME_FIELD, TRAINING_START_TIME_FIELD, TRAINING_END_TIME_FIELD, TRAINING_JOB_STATUS_FIELD, TUNED_HYPER_PARAMETERS_FIELD, FAILURE_REASON_FIELD, FINAL_HYPER_PARAMETER_TUNING_JOB_OBJECTIVE_METRIC_FIELD, OBJECTIVE_STATUS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String trainingJobDefinitionName;
    private final String trainingJobName;
    private final String trainingJobArn;
    private final String tuningJobName;
    private final Instant creationTime;
    private final Instant trainingStartTime;
    private final Instant trainingEndTime;
    private final String trainingJobStatus;
    private final Map<String, String> tunedHyperParameters;
    private final String failureReason;
    private final FinalHyperParameterTuningJobObjectiveMetric finalHyperParameterTuningJobObjectiveMetric;
    private final String objectiveStatus;

    private HyperParameterTrainingJobSummary(BuilderImpl builder) {
        this.trainingJobDefinitionName = builder.trainingJobDefinitionName;
        this.trainingJobName = builder.trainingJobName;
        this.trainingJobArn = builder.trainingJobArn;
        this.tuningJobName = builder.tuningJobName;
        this.creationTime = builder.creationTime;
        this.trainingStartTime = builder.trainingStartTime;
        this.trainingEndTime = builder.trainingEndTime;
        this.trainingJobStatus = builder.trainingJobStatus;
        this.tunedHyperParameters = builder.tunedHyperParameters;
        this.failureReason = builder.failureReason;
        this.finalHyperParameterTuningJobObjectiveMetric = builder.finalHyperParameterTuningJobObjectiveMetric;
        this.objectiveStatus = builder.objectiveStatus;
    }

    public String trainingJobDefinitionName() {
        return this.trainingJobDefinitionName;
    }

    public String trainingJobName() {
        return this.trainingJobName;
    }

    public String trainingJobArn() {
        return this.trainingJobArn;
    }

    public String tuningJobName() {
        return this.tuningJobName;
    }

    public Instant creationTime() {
        return this.creationTime;
    }

    public Instant trainingStartTime() {
        return this.trainingStartTime;
    }

    public Instant trainingEndTime() {
        return this.trainingEndTime;
    }

    public TrainingJobStatus trainingJobStatus() {
        return TrainingJobStatus.fromValue(this.trainingJobStatus);
    }

    public String trainingJobStatusAsString() {
        return this.trainingJobStatus;
    }

    public boolean hasTunedHyperParameters() {
        return this.tunedHyperParameters != null && !(this.tunedHyperParameters instanceof SdkAutoConstructMap);
    }

    public Map<String, String> tunedHyperParameters() {
        return this.tunedHyperParameters;
    }

    public String failureReason() {
        return this.failureReason;
    }

    public FinalHyperParameterTuningJobObjectiveMetric finalHyperParameterTuningJobObjectiveMetric() {
        return this.finalHyperParameterTuningJobObjectiveMetric;
    }

    public ObjectiveStatus objectiveStatus() {
        return ObjectiveStatus.fromValue(this.objectiveStatus);
    }

    public String objectiveStatusAsString() {
        return this.objectiveStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.trainingJobDefinitionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.trainingJobName());
        hashCode = 31 * hashCode + Objects.hashCode(this.trainingJobArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.tuningJobName());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.trainingStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.trainingEndTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.trainingJobStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTunedHyperParameters() ? this.tunedHyperParameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.failureReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.finalHyperParameterTuningJobObjectiveMetric());
        hashCode = 31 * hashCode + Objects.hashCode(this.objectiveStatusAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HyperParameterTrainingJobSummary)) {
            return false;
        }
        HyperParameterTrainingJobSummary other = (HyperParameterTrainingJobSummary)obj;
        return Objects.equals(this.trainingJobDefinitionName(), other.trainingJobDefinitionName()) && Objects.equals(this.trainingJobName(), other.trainingJobName()) && Objects.equals(this.trainingJobArn(), other.trainingJobArn()) && Objects.equals(this.tuningJobName(), other.tuningJobName()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.trainingStartTime(), other.trainingStartTime()) && Objects.equals(this.trainingEndTime(), other.trainingEndTime()) && Objects.equals(this.trainingJobStatusAsString(), other.trainingJobStatusAsString()) && this.hasTunedHyperParameters() == other.hasTunedHyperParameters() && Objects.equals(this.tunedHyperParameters(), other.tunedHyperParameters()) && Objects.equals(this.failureReason(), other.failureReason()) && Objects.equals(this.finalHyperParameterTuningJobObjectiveMetric(), other.finalHyperParameterTuningJobObjectiveMetric()) && Objects.equals(this.objectiveStatusAsString(), other.objectiveStatusAsString());
    }

    public String toString() {
        return ToString.builder((String)"HyperParameterTrainingJobSummary").add("TrainingJobDefinitionName", (Object)this.trainingJobDefinitionName()).add("TrainingJobName", (Object)this.trainingJobName()).add("TrainingJobArn", (Object)this.trainingJobArn()).add("TuningJobName", (Object)this.tuningJobName()).add("CreationTime", (Object)this.creationTime()).add("TrainingStartTime", (Object)this.trainingStartTime()).add("TrainingEndTime", (Object)this.trainingEndTime()).add("TrainingJobStatus", (Object)this.trainingJobStatusAsString()).add("TunedHyperParameters", this.hasTunedHyperParameters() ? this.tunedHyperParameters() : null).add("FailureReason", (Object)this.failureReason()).add("FinalHyperParameterTuningJobObjectiveMetric", (Object)this.finalHyperParameterTuningJobObjectiveMetric()).add("ObjectiveStatus", (Object)this.objectiveStatusAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TrainingJobDefinitionName": {
                return Optional.ofNullable(clazz.cast(this.trainingJobDefinitionName()));
            }
            case "TrainingJobName": {
                return Optional.ofNullable(clazz.cast(this.trainingJobName()));
            }
            case "TrainingJobArn": {
                return Optional.ofNullable(clazz.cast(this.trainingJobArn()));
            }
            case "TuningJobName": {
                return Optional.ofNullable(clazz.cast(this.tuningJobName()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "TrainingStartTime": {
                return Optional.ofNullable(clazz.cast(this.trainingStartTime()));
            }
            case "TrainingEndTime": {
                return Optional.ofNullable(clazz.cast(this.trainingEndTime()));
            }
            case "TrainingJobStatus": {
                return Optional.ofNullable(clazz.cast(this.trainingJobStatusAsString()));
            }
            case "TunedHyperParameters": {
                return Optional.ofNullable(clazz.cast(this.tunedHyperParameters()));
            }
            case "FailureReason": {
                return Optional.ofNullable(clazz.cast(this.failureReason()));
            }
            case "FinalHyperParameterTuningJobObjectiveMetric": {
                return Optional.ofNullable(clazz.cast(this.finalHyperParameterTuningJobObjectiveMetric()));
            }
            case "ObjectiveStatus": {
                return Optional.ofNullable(clazz.cast(this.objectiveStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<HyperParameterTrainingJobSummary, T> g) {
        return obj -> g.apply((HyperParameterTrainingJobSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String trainingJobDefinitionName;
        private String trainingJobName;
        private String trainingJobArn;
        private String tuningJobName;
        private Instant creationTime;
        private Instant trainingStartTime;
        private Instant trainingEndTime;
        private String trainingJobStatus;
        private Map<String, String> tunedHyperParameters = DefaultSdkAutoConstructMap.getInstance();
        private String failureReason;
        private FinalHyperParameterTuningJobObjectiveMetric finalHyperParameterTuningJobObjectiveMetric;
        private String objectiveStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(HyperParameterTrainingJobSummary model) {
            this.trainingJobDefinitionName(model.trainingJobDefinitionName);
            this.trainingJobName(model.trainingJobName);
            this.trainingJobArn(model.trainingJobArn);
            this.tuningJobName(model.tuningJobName);
            this.creationTime(model.creationTime);
            this.trainingStartTime(model.trainingStartTime);
            this.trainingEndTime(model.trainingEndTime);
            this.trainingJobStatus(model.trainingJobStatus);
            this.tunedHyperParameters(model.tunedHyperParameters);
            this.failureReason(model.failureReason);
            this.finalHyperParameterTuningJobObjectiveMetric(model.finalHyperParameterTuningJobObjectiveMetric);
            this.objectiveStatus(model.objectiveStatus);
        }

        public final String getTrainingJobDefinitionName() {
            return this.trainingJobDefinitionName;
        }

        @Override
        public final Builder trainingJobDefinitionName(String trainingJobDefinitionName) {
            this.trainingJobDefinitionName = trainingJobDefinitionName;
            return this;
        }

        public final void setTrainingJobDefinitionName(String trainingJobDefinitionName) {
            this.trainingJobDefinitionName = trainingJobDefinitionName;
        }

        public final String getTrainingJobName() {
            return this.trainingJobName;
        }

        @Override
        public final Builder trainingJobName(String trainingJobName) {
            this.trainingJobName = trainingJobName;
            return this;
        }

        public final void setTrainingJobName(String trainingJobName) {
            this.trainingJobName = trainingJobName;
        }

        public final String getTrainingJobArn() {
            return this.trainingJobArn;
        }

        @Override
        public final Builder trainingJobArn(String trainingJobArn) {
            this.trainingJobArn = trainingJobArn;
            return this;
        }

        public final void setTrainingJobArn(String trainingJobArn) {
            this.trainingJobArn = trainingJobArn;
        }

        public final String getTuningJobName() {
            return this.tuningJobName;
        }

        @Override
        public final Builder tuningJobName(String tuningJobName) {
            this.tuningJobName = tuningJobName;
            return this;
        }

        public final void setTuningJobName(String tuningJobName) {
            this.tuningJobName = tuningJobName;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final Instant getTrainingStartTime() {
            return this.trainingStartTime;
        }

        @Override
        public final Builder trainingStartTime(Instant trainingStartTime) {
            this.trainingStartTime = trainingStartTime;
            return this;
        }

        public final void setTrainingStartTime(Instant trainingStartTime) {
            this.trainingStartTime = trainingStartTime;
        }

        public final Instant getTrainingEndTime() {
            return this.trainingEndTime;
        }

        @Override
        public final Builder trainingEndTime(Instant trainingEndTime) {
            this.trainingEndTime = trainingEndTime;
            return this;
        }

        public final void setTrainingEndTime(Instant trainingEndTime) {
            this.trainingEndTime = trainingEndTime;
        }

        public final String getTrainingJobStatus() {
            return this.trainingJobStatus;
        }

        @Override
        public final Builder trainingJobStatus(String trainingJobStatus) {
            this.trainingJobStatus = trainingJobStatus;
            return this;
        }

        @Override
        public final Builder trainingJobStatus(TrainingJobStatus trainingJobStatus) {
            this.trainingJobStatus(trainingJobStatus == null ? null : trainingJobStatus.toString());
            return this;
        }

        public final void setTrainingJobStatus(String trainingJobStatus) {
            this.trainingJobStatus = trainingJobStatus;
        }

        public final Map<String, String> getTunedHyperParameters() {
            if (this.tunedHyperParameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tunedHyperParameters;
        }

        @Override
        public final Builder tunedHyperParameters(Map<String, String> tunedHyperParameters) {
            this.tunedHyperParameters = HyperParametersCopier.copy(tunedHyperParameters);
            return this;
        }

        public final void setTunedHyperParameters(Map<String, String> tunedHyperParameters) {
            this.tunedHyperParameters = HyperParametersCopier.copy(tunedHyperParameters);
        }

        public final String getFailureReason() {
            return this.failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        public final FinalHyperParameterTuningJobObjectiveMetric.Builder getFinalHyperParameterTuningJobObjectiveMetric() {
            return this.finalHyperParameterTuningJobObjectiveMetric != null ? this.finalHyperParameterTuningJobObjectiveMetric.toBuilder() : null;
        }

        @Override
        public final Builder finalHyperParameterTuningJobObjectiveMetric(FinalHyperParameterTuningJobObjectiveMetric finalHyperParameterTuningJobObjectiveMetric) {
            this.finalHyperParameterTuningJobObjectiveMetric = finalHyperParameterTuningJobObjectiveMetric;
            return this;
        }

        public final void setFinalHyperParameterTuningJobObjectiveMetric(FinalHyperParameterTuningJobObjectiveMetric.BuilderImpl finalHyperParameterTuningJobObjectiveMetric) {
            this.finalHyperParameterTuningJobObjectiveMetric = finalHyperParameterTuningJobObjectiveMetric != null ? finalHyperParameterTuningJobObjectiveMetric.build() : null;
        }

        public final String getObjectiveStatus() {
            return this.objectiveStatus;
        }

        @Override
        public final Builder objectiveStatus(String objectiveStatus) {
            this.objectiveStatus = objectiveStatus;
            return this;
        }

        @Override
        public final Builder objectiveStatus(ObjectiveStatus objectiveStatus) {
            this.objectiveStatus(objectiveStatus == null ? null : objectiveStatus.toString());
            return this;
        }

        public final void setObjectiveStatus(String objectiveStatus) {
            this.objectiveStatus = objectiveStatus;
        }

        public HyperParameterTrainingJobSummary build() {
            return new HyperParameterTrainingJobSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, HyperParameterTrainingJobSummary> {
        public Builder trainingJobDefinitionName(String var1);

        public Builder trainingJobName(String var1);

        public Builder trainingJobArn(String var1);

        public Builder tuningJobName(String var1);

        public Builder creationTime(Instant var1);

        public Builder trainingStartTime(Instant var1);

        public Builder trainingEndTime(Instant var1);

        public Builder trainingJobStatus(String var1);

        public Builder trainingJobStatus(TrainingJobStatus var1);

        public Builder tunedHyperParameters(Map<String, String> var1);

        public Builder failureReason(String var1);

        public Builder finalHyperParameterTuningJobObjectiveMetric(FinalHyperParameterTuningJobObjectiveMetric var1);

        default public Builder finalHyperParameterTuningJobObjectiveMetric(Consumer<FinalHyperParameterTuningJobObjectiveMetric.Builder> finalHyperParameterTuningJobObjectiveMetric) {
            return this.finalHyperParameterTuningJobObjectiveMetric((FinalHyperParameterTuningJobObjectiveMetric)((FinalHyperParameterTuningJobObjectiveMetric.Builder)FinalHyperParameterTuningJobObjectiveMetric.builder().applyMutation(finalHyperParameterTuningJobObjectiveMetric)).build());
        }

        public Builder objectiveStatus(String var1);

        public Builder objectiveStatus(ObjectiveStatus var1);
    }
}

