/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.CaptureContentTypeHeader;
import software.amazon.awssdk.services.sagemaker.model.CaptureOption;
import software.amazon.awssdk.services.sagemaker.model.CaptureOptionListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DataCaptureConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DataCaptureConfig> {
    private static final SdkField<Boolean> ENABLE_CAPTURE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("EnableCapture").getter(DataCaptureConfig.getter(DataCaptureConfig::enableCapture)).setter(DataCaptureConfig.setter(Builder::enableCapture)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableCapture").build()}).build();
    private static final SdkField<Integer> INITIAL_SAMPLING_PERCENTAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("InitialSamplingPercentage").getter(DataCaptureConfig.getter(DataCaptureConfig::initialSamplingPercentage)).setter(DataCaptureConfig.setter(Builder::initialSamplingPercentage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InitialSamplingPercentage").build()}).build();
    private static final SdkField<String> DESTINATION_S3_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DestinationS3Uri").getter(DataCaptureConfig.getter(DataCaptureConfig::destinationS3Uri)).setter(DataCaptureConfig.setter(Builder::destinationS3Uri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationS3Uri").build()}).build();
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KmsKeyId").getter(DataCaptureConfig.getter(DataCaptureConfig::kmsKeyId)).setter(DataCaptureConfig.setter(Builder::kmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()}).build();
    private static final SdkField<List<CaptureOption>> CAPTURE_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CaptureOptions").getter(DataCaptureConfig.getter(DataCaptureConfig::captureOptions)).setter(DataCaptureConfig.setter(Builder::captureOptions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CaptureOptions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CaptureOption::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<CaptureContentTypeHeader> CAPTURE_CONTENT_TYPE_HEADER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CaptureContentTypeHeader").getter(DataCaptureConfig.getter(DataCaptureConfig::captureContentTypeHeader)).setter(DataCaptureConfig.setter(Builder::captureContentTypeHeader)).constructor(CaptureContentTypeHeader::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CaptureContentTypeHeader").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENABLE_CAPTURE_FIELD, INITIAL_SAMPLING_PERCENTAGE_FIELD, DESTINATION_S3_URI_FIELD, KMS_KEY_ID_FIELD, CAPTURE_OPTIONS_FIELD, CAPTURE_CONTENT_TYPE_HEADER_FIELD));
    private static final long serialVersionUID = 1L;
    private final Boolean enableCapture;
    private final Integer initialSamplingPercentage;
    private final String destinationS3Uri;
    private final String kmsKeyId;
    private final List<CaptureOption> captureOptions;
    private final CaptureContentTypeHeader captureContentTypeHeader;

    private DataCaptureConfig(BuilderImpl builder) {
        this.enableCapture = builder.enableCapture;
        this.initialSamplingPercentage = builder.initialSamplingPercentage;
        this.destinationS3Uri = builder.destinationS3Uri;
        this.kmsKeyId = builder.kmsKeyId;
        this.captureOptions = builder.captureOptions;
        this.captureContentTypeHeader = builder.captureContentTypeHeader;
    }

    public Boolean enableCapture() {
        return this.enableCapture;
    }

    public Integer initialSamplingPercentage() {
        return this.initialSamplingPercentage;
    }

    public String destinationS3Uri() {
        return this.destinationS3Uri;
    }

    public String kmsKeyId() {
        return this.kmsKeyId;
    }

    public boolean hasCaptureOptions() {
        return this.captureOptions != null && !(this.captureOptions instanceof SdkAutoConstructList);
    }

    public List<CaptureOption> captureOptions() {
        return this.captureOptions;
    }

    public CaptureContentTypeHeader captureContentTypeHeader() {
        return this.captureContentTypeHeader;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.enableCapture());
        hashCode = 31 * hashCode + Objects.hashCode(this.initialSamplingPercentage());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationS3Uri());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCaptureOptions() ? this.captureOptions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.captureContentTypeHeader());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataCaptureConfig)) {
            return false;
        }
        DataCaptureConfig other = (DataCaptureConfig)obj;
        return Objects.equals(this.enableCapture(), other.enableCapture()) && Objects.equals(this.initialSamplingPercentage(), other.initialSamplingPercentage()) && Objects.equals(this.destinationS3Uri(), other.destinationS3Uri()) && Objects.equals(this.kmsKeyId(), other.kmsKeyId()) && this.hasCaptureOptions() == other.hasCaptureOptions() && Objects.equals(this.captureOptions(), other.captureOptions()) && Objects.equals(this.captureContentTypeHeader(), other.captureContentTypeHeader());
    }

    public String toString() {
        return ToString.builder((String)"DataCaptureConfig").add("EnableCapture", (Object)this.enableCapture()).add("InitialSamplingPercentage", (Object)this.initialSamplingPercentage()).add("DestinationS3Uri", (Object)this.destinationS3Uri()).add("KmsKeyId", (Object)this.kmsKeyId()).add("CaptureOptions", this.hasCaptureOptions() ? this.captureOptions() : null).add("CaptureContentTypeHeader", (Object)this.captureContentTypeHeader()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EnableCapture": {
                return Optional.ofNullable(clazz.cast(this.enableCapture()));
            }
            case "InitialSamplingPercentage": {
                return Optional.ofNullable(clazz.cast(this.initialSamplingPercentage()));
            }
            case "DestinationS3Uri": {
                return Optional.ofNullable(clazz.cast(this.destinationS3Uri()));
            }
            case "KmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyId()));
            }
            case "CaptureOptions": {
                return Optional.ofNullable(clazz.cast(this.captureOptions()));
            }
            case "CaptureContentTypeHeader": {
                return Optional.ofNullable(clazz.cast(this.captureContentTypeHeader()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DataCaptureConfig, T> g) {
        return obj -> g.apply((DataCaptureConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean enableCapture;
        private Integer initialSamplingPercentage;
        private String destinationS3Uri;
        private String kmsKeyId;
        private List<CaptureOption> captureOptions = DefaultSdkAutoConstructList.getInstance();
        private CaptureContentTypeHeader captureContentTypeHeader;

        private BuilderImpl() {
        }

        private BuilderImpl(DataCaptureConfig model) {
            this.enableCapture(model.enableCapture);
            this.initialSamplingPercentage(model.initialSamplingPercentage);
            this.destinationS3Uri(model.destinationS3Uri);
            this.kmsKeyId(model.kmsKeyId);
            this.captureOptions(model.captureOptions);
            this.captureContentTypeHeader(model.captureContentTypeHeader);
        }

        public final Boolean getEnableCapture() {
            return this.enableCapture;
        }

        @Override
        public final Builder enableCapture(Boolean enableCapture) {
            this.enableCapture = enableCapture;
            return this;
        }

        public final void setEnableCapture(Boolean enableCapture) {
            this.enableCapture = enableCapture;
        }

        public final Integer getInitialSamplingPercentage() {
            return this.initialSamplingPercentage;
        }

        @Override
        public final Builder initialSamplingPercentage(Integer initialSamplingPercentage) {
            this.initialSamplingPercentage = initialSamplingPercentage;
            return this;
        }

        public final void setInitialSamplingPercentage(Integer initialSamplingPercentage) {
            this.initialSamplingPercentage = initialSamplingPercentage;
        }

        public final String getDestinationS3Uri() {
            return this.destinationS3Uri;
        }

        @Override
        public final Builder destinationS3Uri(String destinationS3Uri) {
            this.destinationS3Uri = destinationS3Uri;
            return this;
        }

        public final void setDestinationS3Uri(String destinationS3Uri) {
            this.destinationS3Uri = destinationS3Uri;
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        public final Collection<CaptureOption.Builder> getCaptureOptions() {
            if (this.captureOptions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.captureOptions != null ? (Collection)this.captureOptions.stream().map(CaptureOption::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder captureOptions(Collection<CaptureOption> captureOptions) {
            this.captureOptions = CaptureOptionListCopier.copy(captureOptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder captureOptions(CaptureOption ... captureOptions) {
            this.captureOptions(Arrays.asList(captureOptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder captureOptions(Consumer<CaptureOption.Builder> ... captureOptions) {
            this.captureOptions(Stream.of(captureOptions).map(c -> (CaptureOption)((CaptureOption.Builder)CaptureOption.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setCaptureOptions(Collection<CaptureOption.BuilderImpl> captureOptions) {
            this.captureOptions = CaptureOptionListCopier.copyFromBuilder(captureOptions);
        }

        public final CaptureContentTypeHeader.Builder getCaptureContentTypeHeader() {
            return this.captureContentTypeHeader != null ? this.captureContentTypeHeader.toBuilder() : null;
        }

        @Override
        public final Builder captureContentTypeHeader(CaptureContentTypeHeader captureContentTypeHeader) {
            this.captureContentTypeHeader = captureContentTypeHeader;
            return this;
        }

        public final void setCaptureContentTypeHeader(CaptureContentTypeHeader.BuilderImpl captureContentTypeHeader) {
            this.captureContentTypeHeader = captureContentTypeHeader != null ? captureContentTypeHeader.build() : null;
        }

        public DataCaptureConfig build() {
            return new DataCaptureConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DataCaptureConfig> {
        public Builder enableCapture(Boolean var1);

        public Builder initialSamplingPercentage(Integer var1);

        public Builder destinationS3Uri(String var1);

        public Builder kmsKeyId(String var1);

        public Builder captureOptions(Collection<CaptureOption> var1);

        public Builder captureOptions(CaptureOption ... var1);

        public Builder captureOptions(Consumer<CaptureOption.Builder> ... var1);

        public Builder captureContentTypeHeader(CaptureContentTypeHeader var1);

        default public Builder captureContentTypeHeader(Consumer<CaptureContentTypeHeader.Builder> captureContentTypeHeader) {
            return this.captureContentTypeHeader((CaptureContentTypeHeader)((CaptureContentTypeHeader.Builder)CaptureContentTypeHeader.builder().applyMutation(captureContentTypeHeader)).build());
        }
    }
}

