/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.SageMakerRequest;
import software.amazon.awssdk.services.sagemaker.model.VariantProperty;
import software.amazon.awssdk.services.sagemaker.model.VariantPropertyListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateEndpointRequest
extends SageMakerRequest
implements ToCopyableBuilder<Builder, UpdateEndpointRequest> {
    private static final SdkField<String> ENDPOINT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EndpointName").getter(UpdateEndpointRequest.getter(UpdateEndpointRequest::endpointName)).setter(UpdateEndpointRequest.setter(Builder::endpointName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointName").build()}).build();
    private static final SdkField<String> ENDPOINT_CONFIG_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EndpointConfigName").getter(UpdateEndpointRequest.getter(UpdateEndpointRequest::endpointConfigName)).setter(UpdateEndpointRequest.setter(Builder::endpointConfigName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointConfigName").build()}).build();
    private static final SdkField<Boolean> RETAIN_ALL_VARIANT_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("RetainAllVariantProperties").getter(UpdateEndpointRequest.getter(UpdateEndpointRequest::retainAllVariantProperties)).setter(UpdateEndpointRequest.setter(Builder::retainAllVariantProperties)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetainAllVariantProperties").build()}).build();
    private static final SdkField<List<VariantProperty>> EXCLUDE_RETAINED_VARIANT_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ExcludeRetainedVariantProperties").getter(UpdateEndpointRequest.getter(UpdateEndpointRequest::excludeRetainedVariantProperties)).setter(UpdateEndpointRequest.setter(Builder::excludeRetainedVariantProperties)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExcludeRetainedVariantProperties").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(VariantProperty::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENDPOINT_NAME_FIELD, ENDPOINT_CONFIG_NAME_FIELD, RETAIN_ALL_VARIANT_PROPERTIES_FIELD, EXCLUDE_RETAINED_VARIANT_PROPERTIES_FIELD));
    private final String endpointName;
    private final String endpointConfigName;
    private final Boolean retainAllVariantProperties;
    private final List<VariantProperty> excludeRetainedVariantProperties;

    private UpdateEndpointRequest(BuilderImpl builder) {
        super(builder);
        this.endpointName = builder.endpointName;
        this.endpointConfigName = builder.endpointConfigName;
        this.retainAllVariantProperties = builder.retainAllVariantProperties;
        this.excludeRetainedVariantProperties = builder.excludeRetainedVariantProperties;
    }

    public String endpointName() {
        return this.endpointName;
    }

    public String endpointConfigName() {
        return this.endpointConfigName;
    }

    public Boolean retainAllVariantProperties() {
        return this.retainAllVariantProperties;
    }

    public boolean hasExcludeRetainedVariantProperties() {
        return this.excludeRetainedVariantProperties != null && !(this.excludeRetainedVariantProperties instanceof SdkAutoConstructList);
    }

    public List<VariantProperty> excludeRetainedVariantProperties() {
        return this.excludeRetainedVariantProperties;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointName());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointConfigName());
        hashCode = 31 * hashCode + Objects.hashCode(this.retainAllVariantProperties());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExcludeRetainedVariantProperties() ? this.excludeRetainedVariantProperties() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateEndpointRequest)) {
            return false;
        }
        UpdateEndpointRequest other = (UpdateEndpointRequest)((Object)obj);
        return Objects.equals(this.endpointName(), other.endpointName()) && Objects.equals(this.endpointConfigName(), other.endpointConfigName()) && Objects.equals(this.retainAllVariantProperties(), other.retainAllVariantProperties()) && this.hasExcludeRetainedVariantProperties() == other.hasExcludeRetainedVariantProperties() && Objects.equals(this.excludeRetainedVariantProperties(), other.excludeRetainedVariantProperties());
    }

    public String toString() {
        return ToString.builder((String)"UpdateEndpointRequest").add("EndpointName", (Object)this.endpointName()).add("EndpointConfigName", (Object)this.endpointConfigName()).add("RetainAllVariantProperties", (Object)this.retainAllVariantProperties()).add("ExcludeRetainedVariantProperties", this.hasExcludeRetainedVariantProperties() ? this.excludeRetainedVariantProperties() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EndpointName": {
                return Optional.ofNullable(clazz.cast(this.endpointName()));
            }
            case "EndpointConfigName": {
                return Optional.ofNullable(clazz.cast(this.endpointConfigName()));
            }
            case "RetainAllVariantProperties": {
                return Optional.ofNullable(clazz.cast(this.retainAllVariantProperties()));
            }
            case "ExcludeRetainedVariantProperties": {
                return Optional.ofNullable(clazz.cast(this.excludeRetainedVariantProperties()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateEndpointRequest, T> g) {
        return obj -> g.apply((UpdateEndpointRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerRequest.BuilderImpl
    implements Builder {
        private String endpointName;
        private String endpointConfigName;
        private Boolean retainAllVariantProperties;
        private List<VariantProperty> excludeRetainedVariantProperties = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateEndpointRequest model) {
            super(model);
            this.endpointName(model.endpointName);
            this.endpointConfigName(model.endpointConfigName);
            this.retainAllVariantProperties(model.retainAllVariantProperties);
            this.excludeRetainedVariantProperties(model.excludeRetainedVariantProperties);
        }

        public final String getEndpointName() {
            return this.endpointName;
        }

        @Override
        public final Builder endpointName(String endpointName) {
            this.endpointName = endpointName;
            return this;
        }

        public final void setEndpointName(String endpointName) {
            this.endpointName = endpointName;
        }

        public final String getEndpointConfigName() {
            return this.endpointConfigName;
        }

        @Override
        public final Builder endpointConfigName(String endpointConfigName) {
            this.endpointConfigName = endpointConfigName;
            return this;
        }

        public final void setEndpointConfigName(String endpointConfigName) {
            this.endpointConfigName = endpointConfigName;
        }

        public final Boolean getRetainAllVariantProperties() {
            return this.retainAllVariantProperties;
        }

        @Override
        public final Builder retainAllVariantProperties(Boolean retainAllVariantProperties) {
            this.retainAllVariantProperties = retainAllVariantProperties;
            return this;
        }

        public final void setRetainAllVariantProperties(Boolean retainAllVariantProperties) {
            this.retainAllVariantProperties = retainAllVariantProperties;
        }

        public final Collection<VariantProperty.Builder> getExcludeRetainedVariantProperties() {
            if (this.excludeRetainedVariantProperties instanceof SdkAutoConstructList) {
                return null;
            }
            return this.excludeRetainedVariantProperties != null ? (Collection)this.excludeRetainedVariantProperties.stream().map(VariantProperty::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder excludeRetainedVariantProperties(Collection<VariantProperty> excludeRetainedVariantProperties) {
            this.excludeRetainedVariantProperties = VariantPropertyListCopier.copy(excludeRetainedVariantProperties);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder excludeRetainedVariantProperties(VariantProperty ... excludeRetainedVariantProperties) {
            this.excludeRetainedVariantProperties(Arrays.asList(excludeRetainedVariantProperties));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder excludeRetainedVariantProperties(Consumer<VariantProperty.Builder> ... excludeRetainedVariantProperties) {
            this.excludeRetainedVariantProperties(Stream.of(excludeRetainedVariantProperties).map(c -> (VariantProperty)((VariantProperty.Builder)VariantProperty.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setExcludeRetainedVariantProperties(Collection<VariantProperty.BuilderImpl> excludeRetainedVariantProperties) {
            this.excludeRetainedVariantProperties = VariantPropertyListCopier.copyFromBuilder(excludeRetainedVariantProperties);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateEndpointRequest build() {
            return new UpdateEndpointRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SageMakerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateEndpointRequest> {
        public Builder endpointName(String var1);

        public Builder endpointConfigName(String var1);

        public Builder retainAllVariantProperties(Boolean var1);

        public Builder excludeRetainedVariantProperties(Collection<VariantProperty> var1);

        public Builder excludeRetainedVariantProperties(VariantProperty ... var1);

        public Builder excludeRetainedVariantProperties(Consumer<VariantProperty.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

