/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.LabelingJobSummary;
import software.amazon.awssdk.services.sagemaker.model.LabelingJobSummaryListCopier;
import software.amazon.awssdk.services.sagemaker.model.SageMakerResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListLabelingJobsResponse
extends SageMakerResponse
implements ToCopyableBuilder<Builder, ListLabelingJobsResponse> {
    private static final SdkField<List<LabelingJobSummary>> LABELING_JOB_SUMMARY_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("LabelingJobSummaryList").getter(ListLabelingJobsResponse.getter(ListLabelingJobsResponse::labelingJobSummaryList)).setter(ListLabelingJobsResponse.setter(Builder::labelingJobSummaryList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LabelingJobSummaryList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LabelingJobSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListLabelingJobsResponse.getter(ListLabelingJobsResponse::nextToken)).setter(ListLabelingJobsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LABELING_JOB_SUMMARY_LIST_FIELD, NEXT_TOKEN_FIELD));
    private final List<LabelingJobSummary> labelingJobSummaryList;
    private final String nextToken;

    private ListLabelingJobsResponse(BuilderImpl builder) {
        super(builder);
        this.labelingJobSummaryList = builder.labelingJobSummaryList;
        this.nextToken = builder.nextToken;
    }

    public boolean hasLabelingJobSummaryList() {
        return this.labelingJobSummaryList != null && !(this.labelingJobSummaryList instanceof SdkAutoConstructList);
    }

    public List<LabelingJobSummary> labelingJobSummaryList() {
        return this.labelingJobSummaryList;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.labelingJobSummaryList());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListLabelingJobsResponse)) {
            return false;
        }
        ListLabelingJobsResponse other = (ListLabelingJobsResponse)((Object)obj);
        return Objects.equals(this.labelingJobSummaryList(), other.labelingJobSummaryList()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListLabelingJobsResponse").add("LabelingJobSummaryList", this.labelingJobSummaryList()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LabelingJobSummaryList": {
                return Optional.ofNullable(clazz.cast(this.labelingJobSummaryList()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListLabelingJobsResponse, T> g) {
        return obj -> g.apply((ListLabelingJobsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerResponse.BuilderImpl
    implements Builder {
        private List<LabelingJobSummary> labelingJobSummaryList = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListLabelingJobsResponse model) {
            super(model);
            this.labelingJobSummaryList(model.labelingJobSummaryList);
            this.nextToken(model.nextToken);
        }

        public final Collection<LabelingJobSummary.Builder> getLabelingJobSummaryList() {
            return this.labelingJobSummaryList != null ? (Collection)this.labelingJobSummaryList.stream().map(LabelingJobSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder labelingJobSummaryList(Collection<LabelingJobSummary> labelingJobSummaryList) {
            this.labelingJobSummaryList = LabelingJobSummaryListCopier.copy(labelingJobSummaryList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder labelingJobSummaryList(LabelingJobSummary ... labelingJobSummaryList) {
            this.labelingJobSummaryList(Arrays.asList(labelingJobSummaryList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder labelingJobSummaryList(Consumer<LabelingJobSummary.Builder> ... labelingJobSummaryList) {
            this.labelingJobSummaryList(Stream.of(labelingJobSummaryList).map(c -> (LabelingJobSummary)((LabelingJobSummary.Builder)LabelingJobSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setLabelingJobSummaryList(Collection<LabelingJobSummary.BuilderImpl> labelingJobSummaryList) {
            this.labelingJobSummaryList = LabelingJobSummaryListCopier.copyFromBuilder(labelingJobSummaryList);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListLabelingJobsResponse build() {
            return new ListLabelingJobsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SageMakerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListLabelingJobsResponse> {
        public Builder labelingJobSummaryList(Collection<LabelingJobSummary> var1);

        public Builder labelingJobSummaryList(LabelingJobSummary ... var1);

        public Builder labelingJobSummaryList(Consumer<LabelingJobSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

