/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.DataCaptureConfig;
import software.amazon.awssdk.services.sagemaker.model.ProductionVariant;
import software.amazon.awssdk.services.sagemaker.model.ProductionVariantListCopier;
import software.amazon.awssdk.services.sagemaker.model.SageMakerResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeEndpointConfigResponse
extends SageMakerResponse
implements ToCopyableBuilder<Builder, DescribeEndpointConfigResponse> {
    private static final SdkField<String> ENDPOINT_CONFIG_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EndpointConfigName").getter(DescribeEndpointConfigResponse.getter(DescribeEndpointConfigResponse::endpointConfigName)).setter(DescribeEndpointConfigResponse.setter(Builder::endpointConfigName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointConfigName").build()}).build();
    private static final SdkField<String> ENDPOINT_CONFIG_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EndpointConfigArn").getter(DescribeEndpointConfigResponse.getter(DescribeEndpointConfigResponse::endpointConfigArn)).setter(DescribeEndpointConfigResponse.setter(Builder::endpointConfigArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointConfigArn").build()}).build();
    private static final SdkField<List<ProductionVariant>> PRODUCTION_VARIANTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ProductionVariants").getter(DescribeEndpointConfigResponse.getter(DescribeEndpointConfigResponse::productionVariants)).setter(DescribeEndpointConfigResponse.setter(Builder::productionVariants)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductionVariants").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ProductionVariant::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<DataCaptureConfig> DATA_CAPTURE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DataCaptureConfig").getter(DescribeEndpointConfigResponse.getter(DescribeEndpointConfigResponse::dataCaptureConfig)).setter(DescribeEndpointConfigResponse.setter(Builder::dataCaptureConfig)).constructor(DataCaptureConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataCaptureConfig").build()}).build();
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KmsKeyId").getter(DescribeEndpointConfigResponse.getter(DescribeEndpointConfigResponse::kmsKeyId)).setter(DescribeEndpointConfigResponse.setter(Builder::kmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(DescribeEndpointConfigResponse.getter(DescribeEndpointConfigResponse::creationTime)).setter(DescribeEndpointConfigResponse.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENDPOINT_CONFIG_NAME_FIELD, ENDPOINT_CONFIG_ARN_FIELD, PRODUCTION_VARIANTS_FIELD, DATA_CAPTURE_CONFIG_FIELD, KMS_KEY_ID_FIELD, CREATION_TIME_FIELD));
    private final String endpointConfigName;
    private final String endpointConfigArn;
    private final List<ProductionVariant> productionVariants;
    private final DataCaptureConfig dataCaptureConfig;
    private final String kmsKeyId;
    private final Instant creationTime;

    private DescribeEndpointConfigResponse(BuilderImpl builder) {
        super(builder);
        this.endpointConfigName = builder.endpointConfigName;
        this.endpointConfigArn = builder.endpointConfigArn;
        this.productionVariants = builder.productionVariants;
        this.dataCaptureConfig = builder.dataCaptureConfig;
        this.kmsKeyId = builder.kmsKeyId;
        this.creationTime = builder.creationTime;
    }

    public String endpointConfigName() {
        return this.endpointConfigName;
    }

    public String endpointConfigArn() {
        return this.endpointConfigArn;
    }

    public boolean hasProductionVariants() {
        return this.productionVariants != null && !(this.productionVariants instanceof SdkAutoConstructList);
    }

    public List<ProductionVariant> productionVariants() {
        return this.productionVariants;
    }

    public DataCaptureConfig dataCaptureConfig() {
        return this.dataCaptureConfig;
    }

    public String kmsKeyId() {
        return this.kmsKeyId;
    }

    public Instant creationTime() {
        return this.creationTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointConfigName());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointConfigArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.productionVariants());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataCaptureConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEndpointConfigResponse)) {
            return false;
        }
        DescribeEndpointConfigResponse other = (DescribeEndpointConfigResponse)((Object)obj);
        return Objects.equals(this.endpointConfigName(), other.endpointConfigName()) && Objects.equals(this.endpointConfigArn(), other.endpointConfigArn()) && Objects.equals(this.productionVariants(), other.productionVariants()) && Objects.equals(this.dataCaptureConfig(), other.dataCaptureConfig()) && Objects.equals(this.kmsKeyId(), other.kmsKeyId()) && Objects.equals(this.creationTime(), other.creationTime());
    }

    public String toString() {
        return ToString.builder((String)"DescribeEndpointConfigResponse").add("EndpointConfigName", (Object)this.endpointConfigName()).add("EndpointConfigArn", (Object)this.endpointConfigArn()).add("ProductionVariants", this.productionVariants()).add("DataCaptureConfig", (Object)this.dataCaptureConfig()).add("KmsKeyId", (Object)this.kmsKeyId()).add("CreationTime", (Object)this.creationTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EndpointConfigName": {
                return Optional.ofNullable(clazz.cast(this.endpointConfigName()));
            }
            case "EndpointConfigArn": {
                return Optional.ofNullable(clazz.cast(this.endpointConfigArn()));
            }
            case "ProductionVariants": {
                return Optional.ofNullable(clazz.cast(this.productionVariants()));
            }
            case "DataCaptureConfig": {
                return Optional.ofNullable(clazz.cast(this.dataCaptureConfig()));
            }
            case "KmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyId()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeEndpointConfigResponse, T> g) {
        return obj -> g.apply((DescribeEndpointConfigResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerResponse.BuilderImpl
    implements Builder {
        private String endpointConfigName;
        private String endpointConfigArn;
        private List<ProductionVariant> productionVariants = DefaultSdkAutoConstructList.getInstance();
        private DataCaptureConfig dataCaptureConfig;
        private String kmsKeyId;
        private Instant creationTime;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeEndpointConfigResponse model) {
            super(model);
            this.endpointConfigName(model.endpointConfigName);
            this.endpointConfigArn(model.endpointConfigArn);
            this.productionVariants(model.productionVariants);
            this.dataCaptureConfig(model.dataCaptureConfig);
            this.kmsKeyId(model.kmsKeyId);
            this.creationTime(model.creationTime);
        }

        public final String getEndpointConfigName() {
            return this.endpointConfigName;
        }

        @Override
        public final Builder endpointConfigName(String endpointConfigName) {
            this.endpointConfigName = endpointConfigName;
            return this;
        }

        public final void setEndpointConfigName(String endpointConfigName) {
            this.endpointConfigName = endpointConfigName;
        }

        public final String getEndpointConfigArn() {
            return this.endpointConfigArn;
        }

        @Override
        public final Builder endpointConfigArn(String endpointConfigArn) {
            this.endpointConfigArn = endpointConfigArn;
            return this;
        }

        public final void setEndpointConfigArn(String endpointConfigArn) {
            this.endpointConfigArn = endpointConfigArn;
        }

        public final Collection<ProductionVariant.Builder> getProductionVariants() {
            return this.productionVariants != null ? (Collection)this.productionVariants.stream().map(ProductionVariant::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder productionVariants(Collection<ProductionVariant> productionVariants) {
            this.productionVariants = ProductionVariantListCopier.copy(productionVariants);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder productionVariants(ProductionVariant ... productionVariants) {
            this.productionVariants(Arrays.asList(productionVariants));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder productionVariants(Consumer<ProductionVariant.Builder> ... productionVariants) {
            this.productionVariants(Stream.of(productionVariants).map(c -> (ProductionVariant)((ProductionVariant.Builder)ProductionVariant.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setProductionVariants(Collection<ProductionVariant.BuilderImpl> productionVariants) {
            this.productionVariants = ProductionVariantListCopier.copyFromBuilder(productionVariants);
        }

        public final DataCaptureConfig.Builder getDataCaptureConfig() {
            return this.dataCaptureConfig != null ? this.dataCaptureConfig.toBuilder() : null;
        }

        @Override
        public final Builder dataCaptureConfig(DataCaptureConfig dataCaptureConfig) {
            this.dataCaptureConfig = dataCaptureConfig;
            return this;
        }

        public final void setDataCaptureConfig(DataCaptureConfig.BuilderImpl dataCaptureConfig) {
            this.dataCaptureConfig = dataCaptureConfig != null ? dataCaptureConfig.build() : null;
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public DescribeEndpointConfigResponse build() {
            return new DescribeEndpointConfigResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SageMakerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeEndpointConfigResponse> {
        public Builder endpointConfigName(String var1);

        public Builder endpointConfigArn(String var1);

        public Builder productionVariants(Collection<ProductionVariant> var1);

        public Builder productionVariants(ProductionVariant ... var1);

        public Builder productionVariants(Consumer<ProductionVariant.Builder> ... var1);

        public Builder dataCaptureConfig(DataCaptureConfig var1);

        default public Builder dataCaptureConfig(Consumer<DataCaptureConfig.Builder> dataCaptureConfig) {
            return this.dataCaptureConfig((DataCaptureConfig)((DataCaptureConfig.Builder)DataCaptureConfig.builder().applyMutation(dataCaptureConfig)).build());
        }

        public Builder kmsKeyId(String var1);

        public Builder creationTime(Instant var1);
    }
}

