/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.SageMakerResponse;
import software.amazon.awssdk.services.sagemaker.model.TrialComponentSummariesCopier;
import software.amazon.awssdk.services.sagemaker.model.TrialComponentSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListTrialComponentsResponse
extends SageMakerResponse
implements ToCopyableBuilder<Builder, ListTrialComponentsResponse> {
    private static final SdkField<List<TrialComponentSummary>> TRIAL_COMPONENT_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TrialComponentSummaries").getter(ListTrialComponentsResponse.getter(ListTrialComponentsResponse::trialComponentSummaries)).setter(ListTrialComponentsResponse.setter(Builder::trialComponentSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrialComponentSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TrialComponentSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListTrialComponentsResponse.getter(ListTrialComponentsResponse::nextToken)).setter(ListTrialComponentsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRIAL_COMPONENT_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));
    private final List<TrialComponentSummary> trialComponentSummaries;
    private final String nextToken;

    private ListTrialComponentsResponse(BuilderImpl builder) {
        super(builder);
        this.trialComponentSummaries = builder.trialComponentSummaries;
        this.nextToken = builder.nextToken;
    }

    public boolean hasTrialComponentSummaries() {
        return this.trialComponentSummaries != null && !(this.trialComponentSummaries instanceof SdkAutoConstructList);
    }

    public List<TrialComponentSummary> trialComponentSummaries() {
        return this.trialComponentSummaries;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.trialComponentSummaries());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTrialComponentsResponse)) {
            return false;
        }
        ListTrialComponentsResponse other = (ListTrialComponentsResponse)((Object)obj);
        return Objects.equals(this.trialComponentSummaries(), other.trialComponentSummaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListTrialComponentsResponse").add("TrialComponentSummaries", this.trialComponentSummaries()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TrialComponentSummaries": {
                return Optional.ofNullable(clazz.cast(this.trialComponentSummaries()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListTrialComponentsResponse, T> g) {
        return obj -> g.apply((ListTrialComponentsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerResponse.BuilderImpl
    implements Builder {
        private List<TrialComponentSummary> trialComponentSummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTrialComponentsResponse model) {
            super(model);
            this.trialComponentSummaries(model.trialComponentSummaries);
            this.nextToken(model.nextToken);
        }

        public final Collection<TrialComponentSummary.Builder> getTrialComponentSummaries() {
            return this.trialComponentSummaries != null ? (Collection)this.trialComponentSummaries.stream().map(TrialComponentSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder trialComponentSummaries(Collection<TrialComponentSummary> trialComponentSummaries) {
            this.trialComponentSummaries = TrialComponentSummariesCopier.copy(trialComponentSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder trialComponentSummaries(TrialComponentSummary ... trialComponentSummaries) {
            this.trialComponentSummaries(Arrays.asList(trialComponentSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder trialComponentSummaries(Consumer<TrialComponentSummary.Builder> ... trialComponentSummaries) {
            this.trialComponentSummaries(Stream.of(trialComponentSummaries).map(c -> (TrialComponentSummary)((TrialComponentSummary.Builder)TrialComponentSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTrialComponentSummaries(Collection<TrialComponentSummary.BuilderImpl> trialComponentSummaries) {
            this.trialComponentSummaries = TrialComponentSummariesCopier.copyFromBuilder(trialComponentSummaries);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListTrialComponentsResponse build() {
            return new ListTrialComponentsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SageMakerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListTrialComponentsResponse> {
        public Builder trialComponentSummaries(Collection<TrialComponentSummary> var1);

        public Builder trialComponentSummaries(TrialComponentSummary ... var1);

        public Builder trialComponentSummaries(Consumer<TrialComponentSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

