/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.NotebookInstanceSortKey;
import software.amazon.awssdk.services.sagemaker.model.NotebookInstanceSortOrder;
import software.amazon.awssdk.services.sagemaker.model.NotebookInstanceStatus;
import software.amazon.awssdk.services.sagemaker.model.SageMakerRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListNotebookInstancesRequest
extends SageMakerRequest
implements ToCopyableBuilder<Builder, ListNotebookInstancesRequest> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListNotebookInstancesRequest.getter(ListNotebookInstancesRequest::nextToken)).setter(ListNotebookInstancesRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(ListNotebookInstancesRequest.getter(ListNotebookInstancesRequest::maxResults)).setter(ListNotebookInstancesRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final SdkField<String> SORT_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListNotebookInstancesRequest.getter(ListNotebookInstancesRequest::sortByAsString)).setter(ListNotebookInstancesRequest.setter(Builder::sortBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortBy").build()}).build();
    private static final SdkField<String> SORT_ORDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListNotebookInstancesRequest.getter(ListNotebookInstancesRequest::sortOrderAsString)).setter(ListNotebookInstancesRequest.setter(Builder::sortOrder)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortOrder").build()}).build();
    private static final SdkField<String> NAME_CONTAINS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListNotebookInstancesRequest.getter(ListNotebookInstancesRequest::nameContains)).setter(ListNotebookInstancesRequest.setter(Builder::nameContains)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NameContains").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_BEFORE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(ListNotebookInstancesRequest.getter(ListNotebookInstancesRequest::creationTimeBefore)).setter(ListNotebookInstancesRequest.setter(Builder::creationTimeBefore)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTimeBefore").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_AFTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(ListNotebookInstancesRequest.getter(ListNotebookInstancesRequest::creationTimeAfter)).setter(ListNotebookInstancesRequest.setter(Builder::creationTimeAfter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTimeAfter").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_TIME_BEFORE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(ListNotebookInstancesRequest.getter(ListNotebookInstancesRequest::lastModifiedTimeBefore)).setter(ListNotebookInstancesRequest.setter(Builder::lastModifiedTimeBefore)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTimeBefore").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_TIME_AFTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(ListNotebookInstancesRequest.getter(ListNotebookInstancesRequest::lastModifiedTimeAfter)).setter(ListNotebookInstancesRequest.setter(Builder::lastModifiedTimeAfter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTimeAfter").build()}).build();
    private static final SdkField<String> STATUS_EQUALS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListNotebookInstancesRequest.getter(ListNotebookInstancesRequest::statusEqualsAsString)).setter(ListNotebookInstancesRequest.setter(Builder::statusEquals)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusEquals").build()}).build();
    private static final SdkField<String> NOTEBOOK_INSTANCE_LIFECYCLE_CONFIG_NAME_CONTAINS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListNotebookInstancesRequest.getter(ListNotebookInstancesRequest::notebookInstanceLifecycleConfigNameContains)).setter(ListNotebookInstancesRequest.setter(Builder::notebookInstanceLifecycleConfigNameContains)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotebookInstanceLifecycleConfigNameContains").build()}).build();
    private static final SdkField<String> DEFAULT_CODE_REPOSITORY_CONTAINS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListNotebookInstancesRequest.getter(ListNotebookInstancesRequest::defaultCodeRepositoryContains)).setter(ListNotebookInstancesRequest.setter(Builder::defaultCodeRepositoryContains)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultCodeRepositoryContains").build()}).build();
    private static final SdkField<String> ADDITIONAL_CODE_REPOSITORY_EQUALS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListNotebookInstancesRequest.getter(ListNotebookInstancesRequest::additionalCodeRepositoryEquals)).setter(ListNotebookInstancesRequest.setter(Builder::additionalCodeRepositoryEquals)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdditionalCodeRepositoryEquals").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, SORT_BY_FIELD, SORT_ORDER_FIELD, NAME_CONTAINS_FIELD, CREATION_TIME_BEFORE_FIELD, CREATION_TIME_AFTER_FIELD, LAST_MODIFIED_TIME_BEFORE_FIELD, LAST_MODIFIED_TIME_AFTER_FIELD, STATUS_EQUALS_FIELD, NOTEBOOK_INSTANCE_LIFECYCLE_CONFIG_NAME_CONTAINS_FIELD, DEFAULT_CODE_REPOSITORY_CONTAINS_FIELD, ADDITIONAL_CODE_REPOSITORY_EQUALS_FIELD));
    private final String nextToken;
    private final Integer maxResults;
    private final String sortBy;
    private final String sortOrder;
    private final String nameContains;
    private final Instant creationTimeBefore;
    private final Instant creationTimeAfter;
    private final Instant lastModifiedTimeBefore;
    private final Instant lastModifiedTimeAfter;
    private final String statusEquals;
    private final String notebookInstanceLifecycleConfigNameContains;
    private final String defaultCodeRepositoryContains;
    private final String additionalCodeRepositoryEquals;

    private ListNotebookInstancesRequest(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.sortBy = builder.sortBy;
        this.sortOrder = builder.sortOrder;
        this.nameContains = builder.nameContains;
        this.creationTimeBefore = builder.creationTimeBefore;
        this.creationTimeAfter = builder.creationTimeAfter;
        this.lastModifiedTimeBefore = builder.lastModifiedTimeBefore;
        this.lastModifiedTimeAfter = builder.lastModifiedTimeAfter;
        this.statusEquals = builder.statusEquals;
        this.notebookInstanceLifecycleConfigNameContains = builder.notebookInstanceLifecycleConfigNameContains;
        this.defaultCodeRepositoryContains = builder.defaultCodeRepositoryContains;
        this.additionalCodeRepositoryEquals = builder.additionalCodeRepositoryEquals;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Integer maxResults() {
        return this.maxResults;
    }

    public NotebookInstanceSortKey sortBy() {
        return NotebookInstanceSortKey.fromValue(this.sortBy);
    }

    public String sortByAsString() {
        return this.sortBy;
    }

    public NotebookInstanceSortOrder sortOrder() {
        return NotebookInstanceSortOrder.fromValue(this.sortOrder);
    }

    public String sortOrderAsString() {
        return this.sortOrder;
    }

    public String nameContains() {
        return this.nameContains;
    }

    public Instant creationTimeBefore() {
        return this.creationTimeBefore;
    }

    public Instant creationTimeAfter() {
        return this.creationTimeAfter;
    }

    public Instant lastModifiedTimeBefore() {
        return this.lastModifiedTimeBefore;
    }

    public Instant lastModifiedTimeAfter() {
        return this.lastModifiedTimeAfter;
    }

    public NotebookInstanceStatus statusEquals() {
        return NotebookInstanceStatus.fromValue(this.statusEquals);
    }

    public String statusEqualsAsString() {
        return this.statusEquals;
    }

    public String notebookInstanceLifecycleConfigNameContains() {
        return this.notebookInstanceLifecycleConfigNameContains;
    }

    public String defaultCodeRepositoryContains() {
        return this.defaultCodeRepositoryContains;
    }

    public String additionalCodeRepositoryEquals() {
        return this.additionalCodeRepositoryEquals;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.sortByAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sortOrderAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.nameContains());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTimeBefore());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTimeAfter());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTimeBefore());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTimeAfter());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusEqualsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.notebookInstanceLifecycleConfigNameContains());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultCodeRepositoryContains());
        hashCode = 31 * hashCode + Objects.hashCode(this.additionalCodeRepositoryEquals());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListNotebookInstancesRequest)) {
            return false;
        }
        ListNotebookInstancesRequest other = (ListNotebookInstancesRequest)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.sortByAsString(), other.sortByAsString()) && Objects.equals(this.sortOrderAsString(), other.sortOrderAsString()) && Objects.equals(this.nameContains(), other.nameContains()) && Objects.equals(this.creationTimeBefore(), other.creationTimeBefore()) && Objects.equals(this.creationTimeAfter(), other.creationTimeAfter()) && Objects.equals(this.lastModifiedTimeBefore(), other.lastModifiedTimeBefore()) && Objects.equals(this.lastModifiedTimeAfter(), other.lastModifiedTimeAfter()) && Objects.equals(this.statusEqualsAsString(), other.statusEqualsAsString()) && Objects.equals(this.notebookInstanceLifecycleConfigNameContains(), other.notebookInstanceLifecycleConfigNameContains()) && Objects.equals(this.defaultCodeRepositoryContains(), other.defaultCodeRepositoryContains()) && Objects.equals(this.additionalCodeRepositoryEquals(), other.additionalCodeRepositoryEquals());
    }

    public String toString() {
        return ToString.builder((String)"ListNotebookInstancesRequest").add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).add("SortBy", (Object)this.sortByAsString()).add("SortOrder", (Object)this.sortOrderAsString()).add("NameContains", (Object)this.nameContains()).add("CreationTimeBefore", (Object)this.creationTimeBefore()).add("CreationTimeAfter", (Object)this.creationTimeAfter()).add("LastModifiedTimeBefore", (Object)this.lastModifiedTimeBefore()).add("LastModifiedTimeAfter", (Object)this.lastModifiedTimeAfter()).add("StatusEquals", (Object)this.statusEqualsAsString()).add("NotebookInstanceLifecycleConfigNameContains", (Object)this.notebookInstanceLifecycleConfigNameContains()).add("DefaultCodeRepositoryContains", (Object)this.defaultCodeRepositoryContains()).add("AdditionalCodeRepositoryEquals", (Object)this.additionalCodeRepositoryEquals()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "SortBy": {
                return Optional.ofNullable(clazz.cast(this.sortByAsString()));
            }
            case "SortOrder": {
                return Optional.ofNullable(clazz.cast(this.sortOrderAsString()));
            }
            case "NameContains": {
                return Optional.ofNullable(clazz.cast(this.nameContains()));
            }
            case "CreationTimeBefore": {
                return Optional.ofNullable(clazz.cast(this.creationTimeBefore()));
            }
            case "CreationTimeAfter": {
                return Optional.ofNullable(clazz.cast(this.creationTimeAfter()));
            }
            case "LastModifiedTimeBefore": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTimeBefore()));
            }
            case "LastModifiedTimeAfter": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTimeAfter()));
            }
            case "StatusEquals": {
                return Optional.ofNullable(clazz.cast(this.statusEqualsAsString()));
            }
            case "NotebookInstanceLifecycleConfigNameContains": {
                return Optional.ofNullable(clazz.cast(this.notebookInstanceLifecycleConfigNameContains()));
            }
            case "DefaultCodeRepositoryContains": {
                return Optional.ofNullable(clazz.cast(this.defaultCodeRepositoryContains()));
            }
            case "AdditionalCodeRepositoryEquals": {
                return Optional.ofNullable(clazz.cast(this.additionalCodeRepositoryEquals()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListNotebookInstancesRequest, T> g) {
        return obj -> g.apply((ListNotebookInstancesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerRequest.BuilderImpl
    implements Builder {
        private String nextToken;
        private Integer maxResults;
        private String sortBy;
        private String sortOrder;
        private String nameContains;
        private Instant creationTimeBefore;
        private Instant creationTimeAfter;
        private Instant lastModifiedTimeBefore;
        private Instant lastModifiedTimeAfter;
        private String statusEquals;
        private String notebookInstanceLifecycleConfigNameContains;
        private String defaultCodeRepositoryContains;
        private String additionalCodeRepositoryEquals;

        private BuilderImpl() {
        }

        private BuilderImpl(ListNotebookInstancesRequest model) {
            super(model);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
            this.sortBy(model.sortBy);
            this.sortOrder(model.sortOrder);
            this.nameContains(model.nameContains);
            this.creationTimeBefore(model.creationTimeBefore);
            this.creationTimeAfter(model.creationTimeAfter);
            this.lastModifiedTimeBefore(model.lastModifiedTimeBefore);
            this.lastModifiedTimeAfter(model.lastModifiedTimeAfter);
            this.statusEquals(model.statusEquals);
            this.notebookInstanceLifecycleConfigNameContains(model.notebookInstanceLifecycleConfigNameContains);
            this.defaultCodeRepositoryContains(model.defaultCodeRepositoryContains);
            this.additionalCodeRepositoryEquals(model.additionalCodeRepositoryEquals);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getSortBy() {
            return this.sortBy;
        }

        @Override
        public final Builder sortBy(String sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        @Override
        public final Builder sortBy(NotebookInstanceSortKey sortBy) {
            this.sortBy(sortBy == null ? null : sortBy.toString());
            return this;
        }

        public final void setSortBy(String sortBy) {
            this.sortBy = sortBy;
        }

        public final String getSortOrder() {
            return this.sortOrder;
        }

        @Override
        public final Builder sortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        @Override
        public final Builder sortOrder(NotebookInstanceSortOrder sortOrder) {
            this.sortOrder(sortOrder == null ? null : sortOrder.toString());
            return this;
        }

        public final void setSortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
        }

        public final String getNameContains() {
            return this.nameContains;
        }

        @Override
        public final Builder nameContains(String nameContains) {
            this.nameContains = nameContains;
            return this;
        }

        public final void setNameContains(String nameContains) {
            this.nameContains = nameContains;
        }

        public final Instant getCreationTimeBefore() {
            return this.creationTimeBefore;
        }

        @Override
        public final Builder creationTimeBefore(Instant creationTimeBefore) {
            this.creationTimeBefore = creationTimeBefore;
            return this;
        }

        public final void setCreationTimeBefore(Instant creationTimeBefore) {
            this.creationTimeBefore = creationTimeBefore;
        }

        public final Instant getCreationTimeAfter() {
            return this.creationTimeAfter;
        }

        @Override
        public final Builder creationTimeAfter(Instant creationTimeAfter) {
            this.creationTimeAfter = creationTimeAfter;
            return this;
        }

        public final void setCreationTimeAfter(Instant creationTimeAfter) {
            this.creationTimeAfter = creationTimeAfter;
        }

        public final Instant getLastModifiedTimeBefore() {
            return this.lastModifiedTimeBefore;
        }

        @Override
        public final Builder lastModifiedTimeBefore(Instant lastModifiedTimeBefore) {
            this.lastModifiedTimeBefore = lastModifiedTimeBefore;
            return this;
        }

        public final void setLastModifiedTimeBefore(Instant lastModifiedTimeBefore) {
            this.lastModifiedTimeBefore = lastModifiedTimeBefore;
        }

        public final Instant getLastModifiedTimeAfter() {
            return this.lastModifiedTimeAfter;
        }

        @Override
        public final Builder lastModifiedTimeAfter(Instant lastModifiedTimeAfter) {
            this.lastModifiedTimeAfter = lastModifiedTimeAfter;
            return this;
        }

        public final void setLastModifiedTimeAfter(Instant lastModifiedTimeAfter) {
            this.lastModifiedTimeAfter = lastModifiedTimeAfter;
        }

        public final String getStatusEquals() {
            return this.statusEquals;
        }

        @Override
        public final Builder statusEquals(String statusEquals) {
            this.statusEquals = statusEquals;
            return this;
        }

        @Override
        public final Builder statusEquals(NotebookInstanceStatus statusEquals) {
            this.statusEquals(statusEquals == null ? null : statusEquals.toString());
            return this;
        }

        public final void setStatusEquals(String statusEquals) {
            this.statusEquals = statusEquals;
        }

        public final String getNotebookInstanceLifecycleConfigNameContains() {
            return this.notebookInstanceLifecycleConfigNameContains;
        }

        @Override
        public final Builder notebookInstanceLifecycleConfigNameContains(String notebookInstanceLifecycleConfigNameContains) {
            this.notebookInstanceLifecycleConfigNameContains = notebookInstanceLifecycleConfigNameContains;
            return this;
        }

        public final void setNotebookInstanceLifecycleConfigNameContains(String notebookInstanceLifecycleConfigNameContains) {
            this.notebookInstanceLifecycleConfigNameContains = notebookInstanceLifecycleConfigNameContains;
        }

        public final String getDefaultCodeRepositoryContains() {
            return this.defaultCodeRepositoryContains;
        }

        @Override
        public final Builder defaultCodeRepositoryContains(String defaultCodeRepositoryContains) {
            this.defaultCodeRepositoryContains = defaultCodeRepositoryContains;
            return this;
        }

        public final void setDefaultCodeRepositoryContains(String defaultCodeRepositoryContains) {
            this.defaultCodeRepositoryContains = defaultCodeRepositoryContains;
        }

        public final String getAdditionalCodeRepositoryEquals() {
            return this.additionalCodeRepositoryEquals;
        }

        @Override
        public final Builder additionalCodeRepositoryEquals(String additionalCodeRepositoryEquals) {
            this.additionalCodeRepositoryEquals = additionalCodeRepositoryEquals;
            return this;
        }

        public final void setAdditionalCodeRepositoryEquals(String additionalCodeRepositoryEquals) {
            this.additionalCodeRepositoryEquals = additionalCodeRepositoryEquals;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListNotebookInstancesRequest build() {
            return new ListNotebookInstancesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SageMakerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListNotebookInstancesRequest> {
        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder sortBy(String var1);

        public Builder sortBy(NotebookInstanceSortKey var1);

        public Builder sortOrder(String var1);

        public Builder sortOrder(NotebookInstanceSortOrder var1);

        public Builder nameContains(String var1);

        public Builder creationTimeBefore(Instant var1);

        public Builder creationTimeAfter(Instant var1);

        public Builder lastModifiedTimeBefore(Instant var1);

        public Builder lastModifiedTimeAfter(Instant var1);

        public Builder statusEquals(String var1);

        public Builder statusEquals(NotebookInstanceStatus var1);

        public Builder notebookInstanceLifecycleConfigNameContains(String var1);

        public Builder defaultCodeRepositoryContains(String var1);

        public Builder additionalCodeRepositoryEquals(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

