/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.DesiredWeightAndCapacity;
import software.amazon.awssdk.services.sagemaker.model.DesiredWeightAndCapacityListCopier;
import software.amazon.awssdk.services.sagemaker.model.SageMakerRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateEndpointWeightsAndCapacitiesRequest
extends SageMakerRequest
implements ToCopyableBuilder<Builder, UpdateEndpointWeightsAndCapacitiesRequest> {
    private static final SdkField<String> ENDPOINT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateEndpointWeightsAndCapacitiesRequest.getter(UpdateEndpointWeightsAndCapacitiesRequest::endpointName)).setter(UpdateEndpointWeightsAndCapacitiesRequest.setter(Builder::endpointName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointName").build()}).build();
    private static final SdkField<List<DesiredWeightAndCapacity>> DESIRED_WEIGHTS_AND_CAPACITIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(UpdateEndpointWeightsAndCapacitiesRequest.getter(UpdateEndpointWeightsAndCapacitiesRequest::desiredWeightsAndCapacities)).setter(UpdateEndpointWeightsAndCapacitiesRequest.setter(Builder::desiredWeightsAndCapacities)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DesiredWeightsAndCapacities").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DesiredWeightAndCapacity::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENDPOINT_NAME_FIELD, DESIRED_WEIGHTS_AND_CAPACITIES_FIELD));
    private final String endpointName;
    private final List<DesiredWeightAndCapacity> desiredWeightsAndCapacities;

    private UpdateEndpointWeightsAndCapacitiesRequest(BuilderImpl builder) {
        super(builder);
        this.endpointName = builder.endpointName;
        this.desiredWeightsAndCapacities = builder.desiredWeightsAndCapacities;
    }

    public String endpointName() {
        return this.endpointName;
    }

    public boolean hasDesiredWeightsAndCapacities() {
        return this.desiredWeightsAndCapacities != null && !(this.desiredWeightsAndCapacities instanceof SdkAutoConstructList);
    }

    public List<DesiredWeightAndCapacity> desiredWeightsAndCapacities() {
        return this.desiredWeightsAndCapacities;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointName());
        hashCode = 31 * hashCode + Objects.hashCode(this.desiredWeightsAndCapacities());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateEndpointWeightsAndCapacitiesRequest)) {
            return false;
        }
        UpdateEndpointWeightsAndCapacitiesRequest other = (UpdateEndpointWeightsAndCapacitiesRequest)((Object)obj);
        return Objects.equals(this.endpointName(), other.endpointName()) && Objects.equals(this.desiredWeightsAndCapacities(), other.desiredWeightsAndCapacities());
    }

    public String toString() {
        return ToString.builder((String)"UpdateEndpointWeightsAndCapacitiesRequest").add("EndpointName", (Object)this.endpointName()).add("DesiredWeightsAndCapacities", this.desiredWeightsAndCapacities()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EndpointName": {
                return Optional.ofNullable(clazz.cast(this.endpointName()));
            }
            case "DesiredWeightsAndCapacities": {
                return Optional.ofNullable(clazz.cast(this.desiredWeightsAndCapacities()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateEndpointWeightsAndCapacitiesRequest, T> g) {
        return obj -> g.apply((UpdateEndpointWeightsAndCapacitiesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerRequest.BuilderImpl
    implements Builder {
        private String endpointName;
        private List<DesiredWeightAndCapacity> desiredWeightsAndCapacities = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateEndpointWeightsAndCapacitiesRequest model) {
            super(model);
            this.endpointName(model.endpointName);
            this.desiredWeightsAndCapacities(model.desiredWeightsAndCapacities);
        }

        public final String getEndpointName() {
            return this.endpointName;
        }

        @Override
        public final Builder endpointName(String endpointName) {
            this.endpointName = endpointName;
            return this;
        }

        public final void setEndpointName(String endpointName) {
            this.endpointName = endpointName;
        }

        public final Collection<DesiredWeightAndCapacity.Builder> getDesiredWeightsAndCapacities() {
            return this.desiredWeightsAndCapacities != null ? (Collection)this.desiredWeightsAndCapacities.stream().map(DesiredWeightAndCapacity::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder desiredWeightsAndCapacities(Collection<DesiredWeightAndCapacity> desiredWeightsAndCapacities) {
            this.desiredWeightsAndCapacities = DesiredWeightAndCapacityListCopier.copy(desiredWeightsAndCapacities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder desiredWeightsAndCapacities(DesiredWeightAndCapacity ... desiredWeightsAndCapacities) {
            this.desiredWeightsAndCapacities(Arrays.asList(desiredWeightsAndCapacities));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder desiredWeightsAndCapacities(Consumer<DesiredWeightAndCapacity.Builder> ... desiredWeightsAndCapacities) {
            this.desiredWeightsAndCapacities(Stream.of(desiredWeightsAndCapacities).map(c -> (DesiredWeightAndCapacity)((DesiredWeightAndCapacity.Builder)DesiredWeightAndCapacity.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDesiredWeightsAndCapacities(Collection<DesiredWeightAndCapacity.BuilderImpl> desiredWeightsAndCapacities) {
            this.desiredWeightsAndCapacities = DesiredWeightAndCapacityListCopier.copyFromBuilder(desiredWeightsAndCapacities);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateEndpointWeightsAndCapacitiesRequest build() {
            return new UpdateEndpointWeightsAndCapacitiesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SageMakerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateEndpointWeightsAndCapacitiesRequest> {
        public Builder endpointName(String var1);

        public Builder desiredWeightsAndCapacities(Collection<DesiredWeightAndCapacity> var1);

        public Builder desiredWeightsAndCapacities(DesiredWeightAndCapacity ... var1);

        public Builder desiredWeightsAndCapacities(Consumer<DesiredWeightAndCapacity.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

