/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.ExecutionStatus;
import software.amazon.awssdk.services.sagemaker.model.MonitoringExecutionSortKey;
import software.amazon.awssdk.services.sagemaker.model.SageMakerRequest;
import software.amazon.awssdk.services.sagemaker.model.SortOrder;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListMonitoringExecutionsRequest
extends SageMakerRequest
implements ToCopyableBuilder<Builder, ListMonitoringExecutionsRequest> {
    private static final SdkField<String> MONITORING_SCHEDULE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListMonitoringExecutionsRequest.getter(ListMonitoringExecutionsRequest::monitoringScheduleName)).setter(ListMonitoringExecutionsRequest.setter(Builder::monitoringScheduleName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonitoringScheduleName").build()}).build();
    private static final SdkField<String> ENDPOINT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListMonitoringExecutionsRequest.getter(ListMonitoringExecutionsRequest::endpointName)).setter(ListMonitoringExecutionsRequest.setter(Builder::endpointName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointName").build()}).build();
    private static final SdkField<String> SORT_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListMonitoringExecutionsRequest.getter(ListMonitoringExecutionsRequest::sortByAsString)).setter(ListMonitoringExecutionsRequest.setter(Builder::sortBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortBy").build()}).build();
    private static final SdkField<String> SORT_ORDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListMonitoringExecutionsRequest.getter(ListMonitoringExecutionsRequest::sortOrderAsString)).setter(ListMonitoringExecutionsRequest.setter(Builder::sortOrder)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortOrder").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListMonitoringExecutionsRequest.getter(ListMonitoringExecutionsRequest::nextToken)).setter(ListMonitoringExecutionsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(ListMonitoringExecutionsRequest.getter(ListMonitoringExecutionsRequest::maxResults)).setter(ListMonitoringExecutionsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final SdkField<Instant> SCHEDULED_TIME_BEFORE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(ListMonitoringExecutionsRequest.getter(ListMonitoringExecutionsRequest::scheduledTimeBefore)).setter(ListMonitoringExecutionsRequest.setter(Builder::scheduledTimeBefore)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduledTimeBefore").build()}).build();
    private static final SdkField<Instant> SCHEDULED_TIME_AFTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(ListMonitoringExecutionsRequest.getter(ListMonitoringExecutionsRequest::scheduledTimeAfter)).setter(ListMonitoringExecutionsRequest.setter(Builder::scheduledTimeAfter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduledTimeAfter").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_BEFORE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(ListMonitoringExecutionsRequest.getter(ListMonitoringExecutionsRequest::creationTimeBefore)).setter(ListMonitoringExecutionsRequest.setter(Builder::creationTimeBefore)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTimeBefore").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_AFTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(ListMonitoringExecutionsRequest.getter(ListMonitoringExecutionsRequest::creationTimeAfter)).setter(ListMonitoringExecutionsRequest.setter(Builder::creationTimeAfter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTimeAfter").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_TIME_BEFORE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(ListMonitoringExecutionsRequest.getter(ListMonitoringExecutionsRequest::lastModifiedTimeBefore)).setter(ListMonitoringExecutionsRequest.setter(Builder::lastModifiedTimeBefore)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTimeBefore").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_TIME_AFTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(ListMonitoringExecutionsRequest.getter(ListMonitoringExecutionsRequest::lastModifiedTimeAfter)).setter(ListMonitoringExecutionsRequest.setter(Builder::lastModifiedTimeAfter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTimeAfter").build()}).build();
    private static final SdkField<String> STATUS_EQUALS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListMonitoringExecutionsRequest.getter(ListMonitoringExecutionsRequest::statusEqualsAsString)).setter(ListMonitoringExecutionsRequest.setter(Builder::statusEquals)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusEquals").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MONITORING_SCHEDULE_NAME_FIELD, ENDPOINT_NAME_FIELD, SORT_BY_FIELD, SORT_ORDER_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, SCHEDULED_TIME_BEFORE_FIELD, SCHEDULED_TIME_AFTER_FIELD, CREATION_TIME_BEFORE_FIELD, CREATION_TIME_AFTER_FIELD, LAST_MODIFIED_TIME_BEFORE_FIELD, LAST_MODIFIED_TIME_AFTER_FIELD, STATUS_EQUALS_FIELD));
    private final String monitoringScheduleName;
    private final String endpointName;
    private final String sortBy;
    private final String sortOrder;
    private final String nextToken;
    private final Integer maxResults;
    private final Instant scheduledTimeBefore;
    private final Instant scheduledTimeAfter;
    private final Instant creationTimeBefore;
    private final Instant creationTimeAfter;
    private final Instant lastModifiedTimeBefore;
    private final Instant lastModifiedTimeAfter;
    private final String statusEquals;

    private ListMonitoringExecutionsRequest(BuilderImpl builder) {
        super(builder);
        this.monitoringScheduleName = builder.monitoringScheduleName;
        this.endpointName = builder.endpointName;
        this.sortBy = builder.sortBy;
        this.sortOrder = builder.sortOrder;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.scheduledTimeBefore = builder.scheduledTimeBefore;
        this.scheduledTimeAfter = builder.scheduledTimeAfter;
        this.creationTimeBefore = builder.creationTimeBefore;
        this.creationTimeAfter = builder.creationTimeAfter;
        this.lastModifiedTimeBefore = builder.lastModifiedTimeBefore;
        this.lastModifiedTimeAfter = builder.lastModifiedTimeAfter;
        this.statusEquals = builder.statusEquals;
    }

    public String monitoringScheduleName() {
        return this.monitoringScheduleName;
    }

    public String endpointName() {
        return this.endpointName;
    }

    public MonitoringExecutionSortKey sortBy() {
        return MonitoringExecutionSortKey.fromValue(this.sortBy);
    }

    public String sortByAsString() {
        return this.sortBy;
    }

    public SortOrder sortOrder() {
        return SortOrder.fromValue(this.sortOrder);
    }

    public String sortOrderAsString() {
        return this.sortOrder;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Integer maxResults() {
        return this.maxResults;
    }

    public Instant scheduledTimeBefore() {
        return this.scheduledTimeBefore;
    }

    public Instant scheduledTimeAfter() {
        return this.scheduledTimeAfter;
    }

    public Instant creationTimeBefore() {
        return this.creationTimeBefore;
    }

    public Instant creationTimeAfter() {
        return this.creationTimeAfter;
    }

    public Instant lastModifiedTimeBefore() {
        return this.lastModifiedTimeBefore;
    }

    public Instant lastModifiedTimeAfter() {
        return this.lastModifiedTimeAfter;
    }

    public ExecutionStatus statusEquals() {
        return ExecutionStatus.fromValue(this.statusEquals);
    }

    public String statusEqualsAsString() {
        return this.statusEquals;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.monitoringScheduleName());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointName());
        hashCode = 31 * hashCode + Objects.hashCode(this.sortByAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sortOrderAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.scheduledTimeBefore());
        hashCode = 31 * hashCode + Objects.hashCode(this.scheduledTimeAfter());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTimeBefore());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTimeAfter());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTimeBefore());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTimeAfter());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusEqualsAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListMonitoringExecutionsRequest)) {
            return false;
        }
        ListMonitoringExecutionsRequest other = (ListMonitoringExecutionsRequest)((Object)obj);
        return Objects.equals(this.monitoringScheduleName(), other.monitoringScheduleName()) && Objects.equals(this.endpointName(), other.endpointName()) && Objects.equals(this.sortByAsString(), other.sortByAsString()) && Objects.equals(this.sortOrderAsString(), other.sortOrderAsString()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.scheduledTimeBefore(), other.scheduledTimeBefore()) && Objects.equals(this.scheduledTimeAfter(), other.scheduledTimeAfter()) && Objects.equals(this.creationTimeBefore(), other.creationTimeBefore()) && Objects.equals(this.creationTimeAfter(), other.creationTimeAfter()) && Objects.equals(this.lastModifiedTimeBefore(), other.lastModifiedTimeBefore()) && Objects.equals(this.lastModifiedTimeAfter(), other.lastModifiedTimeAfter()) && Objects.equals(this.statusEqualsAsString(), other.statusEqualsAsString());
    }

    public String toString() {
        return ToString.builder((String)"ListMonitoringExecutionsRequest").add("MonitoringScheduleName", (Object)this.monitoringScheduleName()).add("EndpointName", (Object)this.endpointName()).add("SortBy", (Object)this.sortByAsString()).add("SortOrder", (Object)this.sortOrderAsString()).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).add("ScheduledTimeBefore", (Object)this.scheduledTimeBefore()).add("ScheduledTimeAfter", (Object)this.scheduledTimeAfter()).add("CreationTimeBefore", (Object)this.creationTimeBefore()).add("CreationTimeAfter", (Object)this.creationTimeAfter()).add("LastModifiedTimeBefore", (Object)this.lastModifiedTimeBefore()).add("LastModifiedTimeAfter", (Object)this.lastModifiedTimeAfter()).add("StatusEquals", (Object)this.statusEqualsAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MonitoringScheduleName": {
                return Optional.ofNullable(clazz.cast(this.monitoringScheduleName()));
            }
            case "EndpointName": {
                return Optional.ofNullable(clazz.cast(this.endpointName()));
            }
            case "SortBy": {
                return Optional.ofNullable(clazz.cast(this.sortByAsString()));
            }
            case "SortOrder": {
                return Optional.ofNullable(clazz.cast(this.sortOrderAsString()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "ScheduledTimeBefore": {
                return Optional.ofNullable(clazz.cast(this.scheduledTimeBefore()));
            }
            case "ScheduledTimeAfter": {
                return Optional.ofNullable(clazz.cast(this.scheduledTimeAfter()));
            }
            case "CreationTimeBefore": {
                return Optional.ofNullable(clazz.cast(this.creationTimeBefore()));
            }
            case "CreationTimeAfter": {
                return Optional.ofNullable(clazz.cast(this.creationTimeAfter()));
            }
            case "LastModifiedTimeBefore": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTimeBefore()));
            }
            case "LastModifiedTimeAfter": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTimeAfter()));
            }
            case "StatusEquals": {
                return Optional.ofNullable(clazz.cast(this.statusEqualsAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListMonitoringExecutionsRequest, T> g) {
        return obj -> g.apply((ListMonitoringExecutionsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerRequest.BuilderImpl
    implements Builder {
        private String monitoringScheduleName;
        private String endpointName;
        private String sortBy;
        private String sortOrder;
        private String nextToken;
        private Integer maxResults;
        private Instant scheduledTimeBefore;
        private Instant scheduledTimeAfter;
        private Instant creationTimeBefore;
        private Instant creationTimeAfter;
        private Instant lastModifiedTimeBefore;
        private Instant lastModifiedTimeAfter;
        private String statusEquals;

        private BuilderImpl() {
        }

        private BuilderImpl(ListMonitoringExecutionsRequest model) {
            super(model);
            this.monitoringScheduleName(model.monitoringScheduleName);
            this.endpointName(model.endpointName);
            this.sortBy(model.sortBy);
            this.sortOrder(model.sortOrder);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
            this.scheduledTimeBefore(model.scheduledTimeBefore);
            this.scheduledTimeAfter(model.scheduledTimeAfter);
            this.creationTimeBefore(model.creationTimeBefore);
            this.creationTimeAfter(model.creationTimeAfter);
            this.lastModifiedTimeBefore(model.lastModifiedTimeBefore);
            this.lastModifiedTimeAfter(model.lastModifiedTimeAfter);
            this.statusEquals(model.statusEquals);
        }

        public final String getMonitoringScheduleName() {
            return this.monitoringScheduleName;
        }

        @Override
        public final Builder monitoringScheduleName(String monitoringScheduleName) {
            this.monitoringScheduleName = monitoringScheduleName;
            return this;
        }

        public final void setMonitoringScheduleName(String monitoringScheduleName) {
            this.monitoringScheduleName = monitoringScheduleName;
        }

        public final String getEndpointName() {
            return this.endpointName;
        }

        @Override
        public final Builder endpointName(String endpointName) {
            this.endpointName = endpointName;
            return this;
        }

        public final void setEndpointName(String endpointName) {
            this.endpointName = endpointName;
        }

        public final String getSortByAsString() {
            return this.sortBy;
        }

        @Override
        public final Builder sortBy(String sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        @Override
        public final Builder sortBy(MonitoringExecutionSortKey sortBy) {
            this.sortBy(sortBy == null ? null : sortBy.toString());
            return this;
        }

        public final void setSortBy(String sortBy) {
            this.sortBy = sortBy;
        }

        public final String getSortOrderAsString() {
            return this.sortOrder;
        }

        @Override
        public final Builder sortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        @Override
        public final Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder(sortOrder == null ? null : sortOrder.toString());
            return this;
        }

        public final void setSortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final Instant getScheduledTimeBefore() {
            return this.scheduledTimeBefore;
        }

        @Override
        public final Builder scheduledTimeBefore(Instant scheduledTimeBefore) {
            this.scheduledTimeBefore = scheduledTimeBefore;
            return this;
        }

        public final void setScheduledTimeBefore(Instant scheduledTimeBefore) {
            this.scheduledTimeBefore = scheduledTimeBefore;
        }

        public final Instant getScheduledTimeAfter() {
            return this.scheduledTimeAfter;
        }

        @Override
        public final Builder scheduledTimeAfter(Instant scheduledTimeAfter) {
            this.scheduledTimeAfter = scheduledTimeAfter;
            return this;
        }

        public final void setScheduledTimeAfter(Instant scheduledTimeAfter) {
            this.scheduledTimeAfter = scheduledTimeAfter;
        }

        public final Instant getCreationTimeBefore() {
            return this.creationTimeBefore;
        }

        @Override
        public final Builder creationTimeBefore(Instant creationTimeBefore) {
            this.creationTimeBefore = creationTimeBefore;
            return this;
        }

        public final void setCreationTimeBefore(Instant creationTimeBefore) {
            this.creationTimeBefore = creationTimeBefore;
        }

        public final Instant getCreationTimeAfter() {
            return this.creationTimeAfter;
        }

        @Override
        public final Builder creationTimeAfter(Instant creationTimeAfter) {
            this.creationTimeAfter = creationTimeAfter;
            return this;
        }

        public final void setCreationTimeAfter(Instant creationTimeAfter) {
            this.creationTimeAfter = creationTimeAfter;
        }

        public final Instant getLastModifiedTimeBefore() {
            return this.lastModifiedTimeBefore;
        }

        @Override
        public final Builder lastModifiedTimeBefore(Instant lastModifiedTimeBefore) {
            this.lastModifiedTimeBefore = lastModifiedTimeBefore;
            return this;
        }

        public final void setLastModifiedTimeBefore(Instant lastModifiedTimeBefore) {
            this.lastModifiedTimeBefore = lastModifiedTimeBefore;
        }

        public final Instant getLastModifiedTimeAfter() {
            return this.lastModifiedTimeAfter;
        }

        @Override
        public final Builder lastModifiedTimeAfter(Instant lastModifiedTimeAfter) {
            this.lastModifiedTimeAfter = lastModifiedTimeAfter;
            return this;
        }

        public final void setLastModifiedTimeAfter(Instant lastModifiedTimeAfter) {
            this.lastModifiedTimeAfter = lastModifiedTimeAfter;
        }

        public final String getStatusEqualsAsString() {
            return this.statusEquals;
        }

        @Override
        public final Builder statusEquals(String statusEquals) {
            this.statusEquals = statusEquals;
            return this;
        }

        @Override
        public final Builder statusEquals(ExecutionStatus statusEquals) {
            this.statusEquals(statusEquals == null ? null : statusEquals.toString());
            return this;
        }

        public final void setStatusEquals(String statusEquals) {
            this.statusEquals = statusEquals;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListMonitoringExecutionsRequest build() {
            return new ListMonitoringExecutionsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SageMakerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListMonitoringExecutionsRequest> {
        public Builder monitoringScheduleName(String var1);

        public Builder endpointName(String var1);

        public Builder sortBy(String var1);

        public Builder sortBy(MonitoringExecutionSortKey var1);

        public Builder sortOrder(String var1);

        public Builder sortOrder(SortOrder var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder scheduledTimeBefore(Instant var1);

        public Builder scheduledTimeAfter(Instant var1);

        public Builder creationTimeBefore(Instant var1);

        public Builder creationTimeAfter(Instant var1);

        public Builder lastModifiedTimeBefore(Instant var1);

        public Builder lastModifiedTimeAfter(Instant var1);

        public Builder statusEquals(String var1);

        public Builder statusEquals(ExecutionStatus var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

