/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.AppType;
import software.amazon.awssdk.services.sagemaker.model.SageMakerRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeAppRequest
extends SageMakerRequest
implements ToCopyableBuilder<Builder, DescribeAppRequest> {
    private static final SdkField<String> DOMAIN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeAppRequest.getter(DescribeAppRequest::domainId)).setter(DescribeAppRequest.setter(Builder::domainId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainId").build()}).build();
    private static final SdkField<String> USER_PROFILE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeAppRequest.getter(DescribeAppRequest::userProfileName)).setter(DescribeAppRequest.setter(Builder::userProfileName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserProfileName").build()}).build();
    private static final SdkField<String> APP_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeAppRequest.getter(DescribeAppRequest::appTypeAsString)).setter(DescribeAppRequest.setter(Builder::appType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppType").build()}).build();
    private static final SdkField<String> APP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeAppRequest.getter(DescribeAppRequest::appName)).setter(DescribeAppRequest.setter(Builder::appName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_ID_FIELD, USER_PROFILE_NAME_FIELD, APP_TYPE_FIELD, APP_NAME_FIELD));
    private final String domainId;
    private final String userProfileName;
    private final String appType;
    private final String appName;

    private DescribeAppRequest(BuilderImpl builder) {
        super(builder);
        this.domainId = builder.domainId;
        this.userProfileName = builder.userProfileName;
        this.appType = builder.appType;
        this.appName = builder.appName;
    }

    public String domainId() {
        return this.domainId;
    }

    public String userProfileName() {
        return this.userProfileName;
    }

    public AppType appType() {
        return AppType.fromValue(this.appType);
    }

    public String appTypeAsString() {
        return this.appType;
    }

    public String appName() {
        return this.appName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.domainId());
        hashCode = 31 * hashCode + Objects.hashCode(this.userProfileName());
        hashCode = 31 * hashCode + Objects.hashCode(this.appTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.appName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAppRequest)) {
            return false;
        }
        DescribeAppRequest other = (DescribeAppRequest)((Object)obj);
        return Objects.equals(this.domainId(), other.domainId()) && Objects.equals(this.userProfileName(), other.userProfileName()) && Objects.equals(this.appTypeAsString(), other.appTypeAsString()) && Objects.equals(this.appName(), other.appName());
    }

    public String toString() {
        return ToString.builder((String)"DescribeAppRequest").add("DomainId", (Object)this.domainId()).add("UserProfileName", (Object)this.userProfileName()).add("AppType", (Object)this.appTypeAsString()).add("AppName", (Object)this.appName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DomainId": {
                return Optional.ofNullable(clazz.cast(this.domainId()));
            }
            case "UserProfileName": {
                return Optional.ofNullable(clazz.cast(this.userProfileName()));
            }
            case "AppType": {
                return Optional.ofNullable(clazz.cast(this.appTypeAsString()));
            }
            case "AppName": {
                return Optional.ofNullable(clazz.cast(this.appName()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeAppRequest, T> g) {
        return obj -> g.apply((DescribeAppRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerRequest.BuilderImpl
    implements Builder {
        private String domainId;
        private String userProfileName;
        private String appType;
        private String appName;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAppRequest model) {
            super(model);
            this.domainId(model.domainId);
            this.userProfileName(model.userProfileName);
            this.appType(model.appType);
            this.appName(model.appName);
        }

        public final String getDomainId() {
            return this.domainId;
        }

        @Override
        public final Builder domainId(String domainId) {
            this.domainId = domainId;
            return this;
        }

        public final void setDomainId(String domainId) {
            this.domainId = domainId;
        }

        public final String getUserProfileName() {
            return this.userProfileName;
        }

        @Override
        public final Builder userProfileName(String userProfileName) {
            this.userProfileName = userProfileName;
            return this;
        }

        public final void setUserProfileName(String userProfileName) {
            this.userProfileName = userProfileName;
        }

        public final String getAppTypeAsString() {
            return this.appType;
        }

        @Override
        public final Builder appType(String appType) {
            this.appType = appType;
            return this;
        }

        @Override
        public final Builder appType(AppType appType) {
            this.appType(appType == null ? null : appType.toString());
            return this;
        }

        public final void setAppType(String appType) {
            this.appType = appType;
        }

        public final String getAppName() {
            return this.appName;
        }

        @Override
        public final Builder appName(String appName) {
            this.appName = appName;
            return this;
        }

        public final void setAppName(String appName) {
            this.appName = appName;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeAppRequest build() {
            return new DescribeAppRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SageMakerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeAppRequest> {
        public Builder domainId(String var1);

        public Builder userProfileName(String var1);

        public Builder appType(String var1);

        public Builder appType(AppType var1);

        public Builder appName(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

