/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.sagemaker.model.ListTrialComponentKey256Copier;
import software.amazon.awssdk.services.sagemaker.model.SageMakerRequest;
import software.amazon.awssdk.services.sagemaker.model.TrialComponentArtifact;
import software.amazon.awssdk.services.sagemaker.model.TrialComponentArtifactsCopier;
import software.amazon.awssdk.services.sagemaker.model.TrialComponentParameterValue;
import software.amazon.awssdk.services.sagemaker.model.TrialComponentParametersCopier;
import software.amazon.awssdk.services.sagemaker.model.TrialComponentStatus;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateTrialComponentRequest
extends SageMakerRequest
implements ToCopyableBuilder<Builder, UpdateTrialComponentRequest> {
    private static final SdkField<String> TRIAL_COMPONENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateTrialComponentRequest.getter(UpdateTrialComponentRequest::trialComponentName)).setter(UpdateTrialComponentRequest.setter(Builder::trialComponentName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrialComponentName").build()}).build();
    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateTrialComponentRequest.getter(UpdateTrialComponentRequest::displayName)).setter(UpdateTrialComponentRequest.setter(Builder::displayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayName").build()}).build();
    private static final SdkField<TrialComponentStatus> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(UpdateTrialComponentRequest.getter(UpdateTrialComponentRequest::status)).setter(UpdateTrialComponentRequest.setter(Builder::status)).constructor(TrialComponentStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(UpdateTrialComponentRequest.getter(UpdateTrialComponentRequest::startTime)).setter(UpdateTrialComponentRequest.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(UpdateTrialComponentRequest.getter(UpdateTrialComponentRequest::endTime)).setter(UpdateTrialComponentRequest.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()}).build();
    private static final SdkField<Map<String, TrialComponentParameterValue>> PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(UpdateTrialComponentRequest.getter(UpdateTrialComponentRequest::parameters)).setter(UpdateTrialComponentRequest.setter(Builder::parameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Parameters").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TrialComponentParameterValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<List<String>> PARAMETERS_TO_REMOVE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(UpdateTrialComponentRequest.getter(UpdateTrialComponentRequest::parametersToRemove)).setter(UpdateTrialComponentRequest.setter(Builder::parametersToRemove)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParametersToRemove").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, TrialComponentArtifact>> INPUT_ARTIFACTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(UpdateTrialComponentRequest.getter(UpdateTrialComponentRequest::inputArtifacts)).setter(UpdateTrialComponentRequest.setter(Builder::inputArtifacts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputArtifacts").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TrialComponentArtifact::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<List<String>> INPUT_ARTIFACTS_TO_REMOVE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(UpdateTrialComponentRequest.getter(UpdateTrialComponentRequest::inputArtifactsToRemove)).setter(UpdateTrialComponentRequest.setter(Builder::inputArtifactsToRemove)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputArtifactsToRemove").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, TrialComponentArtifact>> OUTPUT_ARTIFACTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(UpdateTrialComponentRequest.getter(UpdateTrialComponentRequest::outputArtifacts)).setter(UpdateTrialComponentRequest.setter(Builder::outputArtifacts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputArtifacts").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TrialComponentArtifact::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<List<String>> OUTPUT_ARTIFACTS_TO_REMOVE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(UpdateTrialComponentRequest.getter(UpdateTrialComponentRequest::outputArtifactsToRemove)).setter(UpdateTrialComponentRequest.setter(Builder::outputArtifactsToRemove)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputArtifactsToRemove").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRIAL_COMPONENT_NAME_FIELD, DISPLAY_NAME_FIELD, STATUS_FIELD, START_TIME_FIELD, END_TIME_FIELD, PARAMETERS_FIELD, PARAMETERS_TO_REMOVE_FIELD, INPUT_ARTIFACTS_FIELD, INPUT_ARTIFACTS_TO_REMOVE_FIELD, OUTPUT_ARTIFACTS_FIELD, OUTPUT_ARTIFACTS_TO_REMOVE_FIELD));
    private final String trialComponentName;
    private final String displayName;
    private final TrialComponentStatus status;
    private final Instant startTime;
    private final Instant endTime;
    private final Map<String, TrialComponentParameterValue> parameters;
    private final List<String> parametersToRemove;
    private final Map<String, TrialComponentArtifact> inputArtifacts;
    private final List<String> inputArtifactsToRemove;
    private final Map<String, TrialComponentArtifact> outputArtifacts;
    private final List<String> outputArtifactsToRemove;

    private UpdateTrialComponentRequest(BuilderImpl builder) {
        super(builder);
        this.trialComponentName = builder.trialComponentName;
        this.displayName = builder.displayName;
        this.status = builder.status;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.parameters = builder.parameters;
        this.parametersToRemove = builder.parametersToRemove;
        this.inputArtifacts = builder.inputArtifacts;
        this.inputArtifactsToRemove = builder.inputArtifactsToRemove;
        this.outputArtifacts = builder.outputArtifacts;
        this.outputArtifactsToRemove = builder.outputArtifactsToRemove;
    }

    public String trialComponentName() {
        return this.trialComponentName;
    }

    public String displayName() {
        return this.displayName;
    }

    public TrialComponentStatus status() {
        return this.status;
    }

    public Instant startTime() {
        return this.startTime;
    }

    public Instant endTime() {
        return this.endTime;
    }

    public Map<String, TrialComponentParameterValue> parameters() {
        return this.parameters;
    }

    public List<String> parametersToRemove() {
        return this.parametersToRemove;
    }

    public Map<String, TrialComponentArtifact> inputArtifacts() {
        return this.inputArtifacts;
    }

    public List<String> inputArtifactsToRemove() {
        return this.inputArtifactsToRemove;
    }

    public Map<String, TrialComponentArtifact> outputArtifacts() {
        return this.outputArtifacts;
    }

    public List<String> outputArtifactsToRemove() {
        return this.outputArtifactsToRemove;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.trialComponentName());
        hashCode = 31 * hashCode + Objects.hashCode(this.displayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.parameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.parametersToRemove());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputArtifacts());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputArtifactsToRemove());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputArtifacts());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputArtifactsToRemove());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateTrialComponentRequest)) {
            return false;
        }
        UpdateTrialComponentRequest other = (UpdateTrialComponentRequest)((Object)obj);
        return Objects.equals(this.trialComponentName(), other.trialComponentName()) && Objects.equals(this.displayName(), other.displayName()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.parameters(), other.parameters()) && Objects.equals(this.parametersToRemove(), other.parametersToRemove()) && Objects.equals(this.inputArtifacts(), other.inputArtifacts()) && Objects.equals(this.inputArtifactsToRemove(), other.inputArtifactsToRemove()) && Objects.equals(this.outputArtifacts(), other.outputArtifacts()) && Objects.equals(this.outputArtifactsToRemove(), other.outputArtifactsToRemove());
    }

    public String toString() {
        return ToString.builder((String)"UpdateTrialComponentRequest").add("TrialComponentName", (Object)this.trialComponentName()).add("DisplayName", (Object)this.displayName()).add("Status", (Object)this.status()).add("StartTime", (Object)this.startTime()).add("EndTime", (Object)this.endTime()).add("Parameters", this.parameters()).add("ParametersToRemove", this.parametersToRemove()).add("InputArtifacts", this.inputArtifacts()).add("InputArtifactsToRemove", this.inputArtifactsToRemove()).add("OutputArtifacts", this.outputArtifacts()).add("OutputArtifactsToRemove", this.outputArtifactsToRemove()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TrialComponentName": {
                return Optional.ofNullable(clazz.cast(this.trialComponentName()));
            }
            case "DisplayName": {
                return Optional.ofNullable(clazz.cast(this.displayName()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "StartTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "EndTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "Parameters": {
                return Optional.ofNullable(clazz.cast(this.parameters()));
            }
            case "ParametersToRemove": {
                return Optional.ofNullable(clazz.cast(this.parametersToRemove()));
            }
            case "InputArtifacts": {
                return Optional.ofNullable(clazz.cast(this.inputArtifacts()));
            }
            case "InputArtifactsToRemove": {
                return Optional.ofNullable(clazz.cast(this.inputArtifactsToRemove()));
            }
            case "OutputArtifacts": {
                return Optional.ofNullable(clazz.cast(this.outputArtifacts()));
            }
            case "OutputArtifactsToRemove": {
                return Optional.ofNullable(clazz.cast(this.outputArtifactsToRemove()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateTrialComponentRequest, T> g) {
        return obj -> g.apply((UpdateTrialComponentRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerRequest.BuilderImpl
    implements Builder {
        private String trialComponentName;
        private String displayName;
        private TrialComponentStatus status;
        private Instant startTime;
        private Instant endTime;
        private Map<String, TrialComponentParameterValue> parameters = DefaultSdkAutoConstructMap.getInstance();
        private List<String> parametersToRemove = DefaultSdkAutoConstructList.getInstance();
        private Map<String, TrialComponentArtifact> inputArtifacts = DefaultSdkAutoConstructMap.getInstance();
        private List<String> inputArtifactsToRemove = DefaultSdkAutoConstructList.getInstance();
        private Map<String, TrialComponentArtifact> outputArtifacts = DefaultSdkAutoConstructMap.getInstance();
        private List<String> outputArtifactsToRemove = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateTrialComponentRequest model) {
            super(model);
            this.trialComponentName(model.trialComponentName);
            this.displayName(model.displayName);
            this.status(model.status);
            this.startTime(model.startTime);
            this.endTime(model.endTime);
            this.parameters(model.parameters);
            this.parametersToRemove(model.parametersToRemove);
            this.inputArtifacts(model.inputArtifacts);
            this.inputArtifactsToRemove(model.inputArtifactsToRemove);
            this.outputArtifacts(model.outputArtifacts);
            this.outputArtifactsToRemove(model.outputArtifactsToRemove);
        }

        public final String getTrialComponentName() {
            return this.trialComponentName;
        }

        @Override
        public final Builder trialComponentName(String trialComponentName) {
            this.trialComponentName = trialComponentName;
            return this;
        }

        public final void setTrialComponentName(String trialComponentName) {
            this.trialComponentName = trialComponentName;
        }

        public final String getDisplayName() {
            return this.displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        public final TrialComponentStatus.Builder getStatus() {
            return this.status != null ? this.status.toBuilder() : null;
        }

        @Override
        public final Builder status(TrialComponentStatus status) {
            this.status = status;
            return this;
        }

        public final void setStatus(TrialComponentStatus.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        public final Map<String, TrialComponentParameterValue.Builder> getParameters() {
            return this.parameters != null ? CollectionUtils.mapValues(this.parameters, TrialComponentParameterValue::toBuilder) : null;
        }

        @Override
        public final Builder parameters(Map<String, TrialComponentParameterValue> parameters) {
            this.parameters = TrialComponentParametersCopier.copy(parameters);
            return this;
        }

        public final void setParameters(Map<String, TrialComponentParameterValue.BuilderImpl> parameters) {
            this.parameters = TrialComponentParametersCopier.copyFromBuilder(parameters);
        }

        public final Collection<String> getParametersToRemove() {
            return this.parametersToRemove;
        }

        @Override
        public final Builder parametersToRemove(Collection<String> parametersToRemove) {
            this.parametersToRemove = ListTrialComponentKey256Copier.copy(parametersToRemove);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parametersToRemove(String ... parametersToRemove) {
            this.parametersToRemove(Arrays.asList(parametersToRemove));
            return this;
        }

        public final void setParametersToRemove(Collection<String> parametersToRemove) {
            this.parametersToRemove = ListTrialComponentKey256Copier.copy(parametersToRemove);
        }

        public final Map<String, TrialComponentArtifact.Builder> getInputArtifacts() {
            return this.inputArtifacts != null ? CollectionUtils.mapValues(this.inputArtifacts, TrialComponentArtifact::toBuilder) : null;
        }

        @Override
        public final Builder inputArtifacts(Map<String, TrialComponentArtifact> inputArtifacts) {
            this.inputArtifacts = TrialComponentArtifactsCopier.copy(inputArtifacts);
            return this;
        }

        public final void setInputArtifacts(Map<String, TrialComponentArtifact.BuilderImpl> inputArtifacts) {
            this.inputArtifacts = TrialComponentArtifactsCopier.copyFromBuilder(inputArtifacts);
        }

        public final Collection<String> getInputArtifactsToRemove() {
            return this.inputArtifactsToRemove;
        }

        @Override
        public final Builder inputArtifactsToRemove(Collection<String> inputArtifactsToRemove) {
            this.inputArtifactsToRemove = ListTrialComponentKey256Copier.copy(inputArtifactsToRemove);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputArtifactsToRemove(String ... inputArtifactsToRemove) {
            this.inputArtifactsToRemove(Arrays.asList(inputArtifactsToRemove));
            return this;
        }

        public final void setInputArtifactsToRemove(Collection<String> inputArtifactsToRemove) {
            this.inputArtifactsToRemove = ListTrialComponentKey256Copier.copy(inputArtifactsToRemove);
        }

        public final Map<String, TrialComponentArtifact.Builder> getOutputArtifacts() {
            return this.outputArtifacts != null ? CollectionUtils.mapValues(this.outputArtifacts, TrialComponentArtifact::toBuilder) : null;
        }

        @Override
        public final Builder outputArtifacts(Map<String, TrialComponentArtifact> outputArtifacts) {
            this.outputArtifacts = TrialComponentArtifactsCopier.copy(outputArtifacts);
            return this;
        }

        public final void setOutputArtifacts(Map<String, TrialComponentArtifact.BuilderImpl> outputArtifacts) {
            this.outputArtifacts = TrialComponentArtifactsCopier.copyFromBuilder(outputArtifacts);
        }

        public final Collection<String> getOutputArtifactsToRemove() {
            return this.outputArtifactsToRemove;
        }

        @Override
        public final Builder outputArtifactsToRemove(Collection<String> outputArtifactsToRemove) {
            this.outputArtifactsToRemove = ListTrialComponentKey256Copier.copy(outputArtifactsToRemove);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputArtifactsToRemove(String ... outputArtifactsToRemove) {
            this.outputArtifactsToRemove(Arrays.asList(outputArtifactsToRemove));
            return this;
        }

        public final void setOutputArtifactsToRemove(Collection<String> outputArtifactsToRemove) {
            this.outputArtifactsToRemove = ListTrialComponentKey256Copier.copy(outputArtifactsToRemove);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateTrialComponentRequest build() {
            return new UpdateTrialComponentRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SageMakerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateTrialComponentRequest> {
        public Builder trialComponentName(String var1);

        public Builder displayName(String var1);

        public Builder status(TrialComponentStatus var1);

        default public Builder status(Consumer<TrialComponentStatus.Builder> status) {
            return this.status((TrialComponentStatus)((TrialComponentStatus.Builder)TrialComponentStatus.builder().applyMutation(status)).build());
        }

        public Builder startTime(Instant var1);

        public Builder endTime(Instant var1);

        public Builder parameters(Map<String, TrialComponentParameterValue> var1);

        public Builder parametersToRemove(Collection<String> var1);

        public Builder parametersToRemove(String ... var1);

        public Builder inputArtifacts(Map<String, TrialComponentArtifact> var1);

        public Builder inputArtifactsToRemove(Collection<String> var1);

        public Builder inputArtifactsToRemove(String ... var1);

        public Builder outputArtifacts(Map<String, TrialComponentArtifact> var1);

        public Builder outputArtifactsToRemove(Collection<String> var1);

        public Builder outputArtifactsToRemove(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

