/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.ProcessingJobSummariesCopier;
import software.amazon.awssdk.services.sagemaker.model.ProcessingJobSummary;
import software.amazon.awssdk.services.sagemaker.model.SageMakerResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListProcessingJobsResponse
extends SageMakerResponse
implements ToCopyableBuilder<Builder, ListProcessingJobsResponse> {
    private static final SdkField<List<ProcessingJobSummary>> PROCESSING_JOB_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ListProcessingJobsResponse.getter(ListProcessingJobsResponse::processingJobSummaries)).setter(ListProcessingJobsResponse.setter(Builder::processingJobSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProcessingJobSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ProcessingJobSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListProcessingJobsResponse.getter(ListProcessingJobsResponse::nextToken)).setter(ListProcessingJobsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROCESSING_JOB_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));
    private final List<ProcessingJobSummary> processingJobSummaries;
    private final String nextToken;

    private ListProcessingJobsResponse(BuilderImpl builder) {
        super(builder);
        this.processingJobSummaries = builder.processingJobSummaries;
        this.nextToken = builder.nextToken;
    }

    public List<ProcessingJobSummary> processingJobSummaries() {
        return this.processingJobSummaries;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.processingJobSummaries());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListProcessingJobsResponse)) {
            return false;
        }
        ListProcessingJobsResponse other = (ListProcessingJobsResponse)((Object)obj);
        return Objects.equals(this.processingJobSummaries(), other.processingJobSummaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListProcessingJobsResponse").add("ProcessingJobSummaries", this.processingJobSummaries()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProcessingJobSummaries": {
                return Optional.ofNullable(clazz.cast(this.processingJobSummaries()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListProcessingJobsResponse, T> g) {
        return obj -> g.apply((ListProcessingJobsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerResponse.BuilderImpl
    implements Builder {
        private List<ProcessingJobSummary> processingJobSummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListProcessingJobsResponse model) {
            super(model);
            this.processingJobSummaries(model.processingJobSummaries);
            this.nextToken(model.nextToken);
        }

        public final Collection<ProcessingJobSummary.Builder> getProcessingJobSummaries() {
            return this.processingJobSummaries != null ? (Collection)this.processingJobSummaries.stream().map(ProcessingJobSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder processingJobSummaries(Collection<ProcessingJobSummary> processingJobSummaries) {
            this.processingJobSummaries = ProcessingJobSummariesCopier.copy(processingJobSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder processingJobSummaries(ProcessingJobSummary ... processingJobSummaries) {
            this.processingJobSummaries(Arrays.asList(processingJobSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder processingJobSummaries(Consumer<ProcessingJobSummary.Builder> ... processingJobSummaries) {
            this.processingJobSummaries(Stream.of(processingJobSummaries).map(c -> (ProcessingJobSummary)((ProcessingJobSummary.Builder)ProcessingJobSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setProcessingJobSummaries(Collection<ProcessingJobSummary.BuilderImpl> processingJobSummaries) {
            this.processingJobSummaries = ProcessingJobSummariesCopier.copyFromBuilder(processingJobSummaries);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListProcessingJobsResponse build() {
            return new ListProcessingJobsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SageMakerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListProcessingJobsResponse> {
        public Builder processingJobSummaries(Collection<ProcessingJobSummary> var1);

        public Builder processingJobSummaries(ProcessingJobSummary ... var1);

        public Builder processingJobSummaries(Consumer<ProcessingJobSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

