/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.sagemaker.model.AlgorithmSpecification;
import software.amazon.awssdk.services.sagemaker.model.Channel;
import software.amazon.awssdk.services.sagemaker.model.CheckpointConfig;
import software.amazon.awssdk.services.sagemaker.model.DebugHookConfig;
import software.amazon.awssdk.services.sagemaker.model.DebugRuleConfiguration;
import software.amazon.awssdk.services.sagemaker.model.DebugRuleConfigurationsCopier;
import software.amazon.awssdk.services.sagemaker.model.DebugRuleEvaluationStatus;
import software.amazon.awssdk.services.sagemaker.model.DebugRuleEvaluationStatusesCopier;
import software.amazon.awssdk.services.sagemaker.model.ExperimentConfig;
import software.amazon.awssdk.services.sagemaker.model.FinalMetricDataListCopier;
import software.amazon.awssdk.services.sagemaker.model.HyperParametersCopier;
import software.amazon.awssdk.services.sagemaker.model.InputDataConfigCopier;
import software.amazon.awssdk.services.sagemaker.model.MetricData;
import software.amazon.awssdk.services.sagemaker.model.ModelArtifacts;
import software.amazon.awssdk.services.sagemaker.model.OutputDataConfig;
import software.amazon.awssdk.services.sagemaker.model.ResourceConfig;
import software.amazon.awssdk.services.sagemaker.model.SecondaryStatus;
import software.amazon.awssdk.services.sagemaker.model.SecondaryStatusTransition;
import software.amazon.awssdk.services.sagemaker.model.SecondaryStatusTransitionsCopier;
import software.amazon.awssdk.services.sagemaker.model.StoppingCondition;
import software.amazon.awssdk.services.sagemaker.model.Tag;
import software.amazon.awssdk.services.sagemaker.model.TagListCopier;
import software.amazon.awssdk.services.sagemaker.model.TensorBoardOutputConfig;
import software.amazon.awssdk.services.sagemaker.model.TrainingJobStatus;
import software.amazon.awssdk.services.sagemaker.model.VpcConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TrainingJob
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TrainingJob> {
    private static final SdkField<String> TRAINING_JOB_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(TrainingJob.getter(TrainingJob::trainingJobName)).setter(TrainingJob.setter(Builder::trainingJobName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrainingJobName").build()}).build();
    private static final SdkField<String> TRAINING_JOB_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(TrainingJob.getter(TrainingJob::trainingJobArn)).setter(TrainingJob.setter(Builder::trainingJobArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrainingJobArn").build()}).build();
    private static final SdkField<String> TUNING_JOB_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(TrainingJob.getter(TrainingJob::tuningJobArn)).setter(TrainingJob.setter(Builder::tuningJobArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TuningJobArn").build()}).build();
    private static final SdkField<String> LABELING_JOB_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(TrainingJob.getter(TrainingJob::labelingJobArn)).setter(TrainingJob.setter(Builder::labelingJobArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LabelingJobArn").build()}).build();
    private static final SdkField<String> AUTO_ML_JOB_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(TrainingJob.getter(TrainingJob::autoMLJobArn)).setter(TrainingJob.setter(Builder::autoMLJobArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoMLJobArn").build()}).build();
    private static final SdkField<ModelArtifacts> MODEL_ARTIFACTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(TrainingJob.getter(TrainingJob::modelArtifacts)).setter(TrainingJob.setter(Builder::modelArtifacts)).constructor(ModelArtifacts::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelArtifacts").build()}).build();
    private static final SdkField<String> TRAINING_JOB_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(TrainingJob.getter(TrainingJob::trainingJobStatusAsString)).setter(TrainingJob.setter(Builder::trainingJobStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrainingJobStatus").build()}).build();
    private static final SdkField<String> SECONDARY_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(TrainingJob.getter(TrainingJob::secondaryStatusAsString)).setter(TrainingJob.setter(Builder::secondaryStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecondaryStatus").build()}).build();
    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(TrainingJob.getter(TrainingJob::failureReason)).setter(TrainingJob.setter(Builder::failureReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureReason").build()}).build();
    private static final SdkField<Map<String, String>> HYPER_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(TrainingJob.getter(TrainingJob::hyperParameters)).setter(TrainingJob.setter(Builder::hyperParameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HyperParameters").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<AlgorithmSpecification> ALGORITHM_SPECIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(TrainingJob.getter(TrainingJob::algorithmSpecification)).setter(TrainingJob.setter(Builder::algorithmSpecification)).constructor(AlgorithmSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlgorithmSpecification").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(TrainingJob.getter(TrainingJob::roleArn)).setter(TrainingJob.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()}).build();
    private static final SdkField<List<Channel>> INPUT_DATA_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(TrainingJob.getter(TrainingJob::inputDataConfig)).setter(TrainingJob.setter(Builder::inputDataConfig)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputDataConfig").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Channel::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<OutputDataConfig> OUTPUT_DATA_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(TrainingJob.getter(TrainingJob::outputDataConfig)).setter(TrainingJob.setter(Builder::outputDataConfig)).constructor(OutputDataConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputDataConfig").build()}).build();
    private static final SdkField<ResourceConfig> RESOURCE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(TrainingJob.getter(TrainingJob::resourceConfig)).setter(TrainingJob.setter(Builder::resourceConfig)).constructor(ResourceConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceConfig").build()}).build();
    private static final SdkField<VpcConfig> VPC_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(TrainingJob.getter(TrainingJob::vpcConfig)).setter(TrainingJob.setter(Builder::vpcConfig)).constructor(VpcConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcConfig").build()}).build();
    private static final SdkField<StoppingCondition> STOPPING_CONDITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(TrainingJob.getter(TrainingJob::stoppingCondition)).setter(TrainingJob.setter(Builder::stoppingCondition)).constructor(StoppingCondition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StoppingCondition").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(TrainingJob.getter(TrainingJob::creationTime)).setter(TrainingJob.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<Instant> TRAINING_START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(TrainingJob.getter(TrainingJob::trainingStartTime)).setter(TrainingJob.setter(Builder::trainingStartTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrainingStartTime").build()}).build();
    private static final SdkField<Instant> TRAINING_END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(TrainingJob.getter(TrainingJob::trainingEndTime)).setter(TrainingJob.setter(Builder::trainingEndTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrainingEndTime").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(TrainingJob.getter(TrainingJob::lastModifiedTime)).setter(TrainingJob.setter(Builder::lastModifiedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()}).build();
    private static final SdkField<List<SecondaryStatusTransition>> SECONDARY_STATUS_TRANSITIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(TrainingJob.getter(TrainingJob::secondaryStatusTransitions)).setter(TrainingJob.setter(Builder::secondaryStatusTransitions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecondaryStatusTransitions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SecondaryStatusTransition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<MetricData>> FINAL_METRIC_DATA_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(TrainingJob.getter(TrainingJob::finalMetricDataList)).setter(TrainingJob.setter(Builder::finalMetricDataList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FinalMetricDataList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MetricData::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> ENABLE_NETWORK_ISOLATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(TrainingJob.getter(TrainingJob::enableNetworkIsolation)).setter(TrainingJob.setter(Builder::enableNetworkIsolation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableNetworkIsolation").build()}).build();
    private static final SdkField<Boolean> ENABLE_INTER_CONTAINER_TRAFFIC_ENCRYPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(TrainingJob.getter(TrainingJob::enableInterContainerTrafficEncryption)).setter(TrainingJob.setter(Builder::enableInterContainerTrafficEncryption)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableInterContainerTrafficEncryption").build()}).build();
    private static final SdkField<Boolean> ENABLE_MANAGED_SPOT_TRAINING_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(TrainingJob.getter(TrainingJob::enableManagedSpotTraining)).setter(TrainingJob.setter(Builder::enableManagedSpotTraining)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableManagedSpotTraining").build()}).build();
    private static final SdkField<CheckpointConfig> CHECKPOINT_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(TrainingJob.getter(TrainingJob::checkpointConfig)).setter(TrainingJob.setter(Builder::checkpointConfig)).constructor(CheckpointConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CheckpointConfig").build()}).build();
    private static final SdkField<Integer> TRAINING_TIME_IN_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(TrainingJob.getter(TrainingJob::trainingTimeInSeconds)).setter(TrainingJob.setter(Builder::trainingTimeInSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrainingTimeInSeconds").build()}).build();
    private static final SdkField<Integer> BILLABLE_TIME_IN_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(TrainingJob.getter(TrainingJob::billableTimeInSeconds)).setter(TrainingJob.setter(Builder::billableTimeInSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BillableTimeInSeconds").build()}).build();
    private static final SdkField<DebugHookConfig> DEBUG_HOOK_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(TrainingJob.getter(TrainingJob::debugHookConfig)).setter(TrainingJob.setter(Builder::debugHookConfig)).constructor(DebugHookConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DebugHookConfig").build()}).build();
    private static final SdkField<ExperimentConfig> EXPERIMENT_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(TrainingJob.getter(TrainingJob::experimentConfig)).setter(TrainingJob.setter(Builder::experimentConfig)).constructor(ExperimentConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExperimentConfig").build()}).build();
    private static final SdkField<List<DebugRuleConfiguration>> DEBUG_RULE_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(TrainingJob.getter(TrainingJob::debugRuleConfigurations)).setter(TrainingJob.setter(Builder::debugRuleConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DebugRuleConfigurations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DebugRuleConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<TensorBoardOutputConfig> TENSOR_BOARD_OUTPUT_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(TrainingJob.getter(TrainingJob::tensorBoardOutputConfig)).setter(TrainingJob.setter(Builder::tensorBoardOutputConfig)).constructor(TensorBoardOutputConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TensorBoardOutputConfig").build()}).build();
    private static final SdkField<List<DebugRuleEvaluationStatus>> DEBUG_RULE_EVALUATION_STATUSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(TrainingJob.getter(TrainingJob::debugRuleEvaluationStatuses)).setter(TrainingJob.setter(Builder::debugRuleEvaluationStatuses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DebugRuleEvaluationStatuses").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DebugRuleEvaluationStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(TrainingJob.getter(TrainingJob::tags)).setter(TrainingJob.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRAINING_JOB_NAME_FIELD, TRAINING_JOB_ARN_FIELD, TUNING_JOB_ARN_FIELD, LABELING_JOB_ARN_FIELD, AUTO_ML_JOB_ARN_FIELD, MODEL_ARTIFACTS_FIELD, TRAINING_JOB_STATUS_FIELD, SECONDARY_STATUS_FIELD, FAILURE_REASON_FIELD, HYPER_PARAMETERS_FIELD, ALGORITHM_SPECIFICATION_FIELD, ROLE_ARN_FIELD, INPUT_DATA_CONFIG_FIELD, OUTPUT_DATA_CONFIG_FIELD, RESOURCE_CONFIG_FIELD, VPC_CONFIG_FIELD, STOPPING_CONDITION_FIELD, CREATION_TIME_FIELD, TRAINING_START_TIME_FIELD, TRAINING_END_TIME_FIELD, LAST_MODIFIED_TIME_FIELD, SECONDARY_STATUS_TRANSITIONS_FIELD, FINAL_METRIC_DATA_LIST_FIELD, ENABLE_NETWORK_ISOLATION_FIELD, ENABLE_INTER_CONTAINER_TRAFFIC_ENCRYPTION_FIELD, ENABLE_MANAGED_SPOT_TRAINING_FIELD, CHECKPOINT_CONFIG_FIELD, TRAINING_TIME_IN_SECONDS_FIELD, BILLABLE_TIME_IN_SECONDS_FIELD, DEBUG_HOOK_CONFIG_FIELD, EXPERIMENT_CONFIG_FIELD, DEBUG_RULE_CONFIGURATIONS_FIELD, TENSOR_BOARD_OUTPUT_CONFIG_FIELD, DEBUG_RULE_EVALUATION_STATUSES_FIELD, TAGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String trainingJobName;
    private final String trainingJobArn;
    private final String tuningJobArn;
    private final String labelingJobArn;
    private final String autoMLJobArn;
    private final ModelArtifacts modelArtifacts;
    private final String trainingJobStatus;
    private final String secondaryStatus;
    private final String failureReason;
    private final Map<String, String> hyperParameters;
    private final AlgorithmSpecification algorithmSpecification;
    private final String roleArn;
    private final List<Channel> inputDataConfig;
    private final OutputDataConfig outputDataConfig;
    private final ResourceConfig resourceConfig;
    private final VpcConfig vpcConfig;
    private final StoppingCondition stoppingCondition;
    private final Instant creationTime;
    private final Instant trainingStartTime;
    private final Instant trainingEndTime;
    private final Instant lastModifiedTime;
    private final List<SecondaryStatusTransition> secondaryStatusTransitions;
    private final List<MetricData> finalMetricDataList;
    private final Boolean enableNetworkIsolation;
    private final Boolean enableInterContainerTrafficEncryption;
    private final Boolean enableManagedSpotTraining;
    private final CheckpointConfig checkpointConfig;
    private final Integer trainingTimeInSeconds;
    private final Integer billableTimeInSeconds;
    private final DebugHookConfig debugHookConfig;
    private final ExperimentConfig experimentConfig;
    private final List<DebugRuleConfiguration> debugRuleConfigurations;
    private final TensorBoardOutputConfig tensorBoardOutputConfig;
    private final List<DebugRuleEvaluationStatus> debugRuleEvaluationStatuses;
    private final List<Tag> tags;

    private TrainingJob(BuilderImpl builder) {
        this.trainingJobName = builder.trainingJobName;
        this.trainingJobArn = builder.trainingJobArn;
        this.tuningJobArn = builder.tuningJobArn;
        this.labelingJobArn = builder.labelingJobArn;
        this.autoMLJobArn = builder.autoMLJobArn;
        this.modelArtifacts = builder.modelArtifacts;
        this.trainingJobStatus = builder.trainingJobStatus;
        this.secondaryStatus = builder.secondaryStatus;
        this.failureReason = builder.failureReason;
        this.hyperParameters = builder.hyperParameters;
        this.algorithmSpecification = builder.algorithmSpecification;
        this.roleArn = builder.roleArn;
        this.inputDataConfig = builder.inputDataConfig;
        this.outputDataConfig = builder.outputDataConfig;
        this.resourceConfig = builder.resourceConfig;
        this.vpcConfig = builder.vpcConfig;
        this.stoppingCondition = builder.stoppingCondition;
        this.creationTime = builder.creationTime;
        this.trainingStartTime = builder.trainingStartTime;
        this.trainingEndTime = builder.trainingEndTime;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.secondaryStatusTransitions = builder.secondaryStatusTransitions;
        this.finalMetricDataList = builder.finalMetricDataList;
        this.enableNetworkIsolation = builder.enableNetworkIsolation;
        this.enableInterContainerTrafficEncryption = builder.enableInterContainerTrafficEncryption;
        this.enableManagedSpotTraining = builder.enableManagedSpotTraining;
        this.checkpointConfig = builder.checkpointConfig;
        this.trainingTimeInSeconds = builder.trainingTimeInSeconds;
        this.billableTimeInSeconds = builder.billableTimeInSeconds;
        this.debugHookConfig = builder.debugHookConfig;
        this.experimentConfig = builder.experimentConfig;
        this.debugRuleConfigurations = builder.debugRuleConfigurations;
        this.tensorBoardOutputConfig = builder.tensorBoardOutputConfig;
        this.debugRuleEvaluationStatuses = builder.debugRuleEvaluationStatuses;
        this.tags = builder.tags;
    }

    public String trainingJobName() {
        return this.trainingJobName;
    }

    public String trainingJobArn() {
        return this.trainingJobArn;
    }

    public String tuningJobArn() {
        return this.tuningJobArn;
    }

    public String labelingJobArn() {
        return this.labelingJobArn;
    }

    public String autoMLJobArn() {
        return this.autoMLJobArn;
    }

    public ModelArtifacts modelArtifacts() {
        return this.modelArtifacts;
    }

    public TrainingJobStatus trainingJobStatus() {
        return TrainingJobStatus.fromValue(this.trainingJobStatus);
    }

    public String trainingJobStatusAsString() {
        return this.trainingJobStatus;
    }

    public SecondaryStatus secondaryStatus() {
        return SecondaryStatus.fromValue(this.secondaryStatus);
    }

    public String secondaryStatusAsString() {
        return this.secondaryStatus;
    }

    public String failureReason() {
        return this.failureReason;
    }

    public Map<String, String> hyperParameters() {
        return this.hyperParameters;
    }

    public AlgorithmSpecification algorithmSpecification() {
        return this.algorithmSpecification;
    }

    public String roleArn() {
        return this.roleArn;
    }

    public List<Channel> inputDataConfig() {
        return this.inputDataConfig;
    }

    public OutputDataConfig outputDataConfig() {
        return this.outputDataConfig;
    }

    public ResourceConfig resourceConfig() {
        return this.resourceConfig;
    }

    public VpcConfig vpcConfig() {
        return this.vpcConfig;
    }

    public StoppingCondition stoppingCondition() {
        return this.stoppingCondition;
    }

    public Instant creationTime() {
        return this.creationTime;
    }

    public Instant trainingStartTime() {
        return this.trainingStartTime;
    }

    public Instant trainingEndTime() {
        return this.trainingEndTime;
    }

    public Instant lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public List<SecondaryStatusTransition> secondaryStatusTransitions() {
        return this.secondaryStatusTransitions;
    }

    public List<MetricData> finalMetricDataList() {
        return this.finalMetricDataList;
    }

    public Boolean enableNetworkIsolation() {
        return this.enableNetworkIsolation;
    }

    public Boolean enableInterContainerTrafficEncryption() {
        return this.enableInterContainerTrafficEncryption;
    }

    public Boolean enableManagedSpotTraining() {
        return this.enableManagedSpotTraining;
    }

    public CheckpointConfig checkpointConfig() {
        return this.checkpointConfig;
    }

    public Integer trainingTimeInSeconds() {
        return this.trainingTimeInSeconds;
    }

    public Integer billableTimeInSeconds() {
        return this.billableTimeInSeconds;
    }

    public DebugHookConfig debugHookConfig() {
        return this.debugHookConfig;
    }

    public ExperimentConfig experimentConfig() {
        return this.experimentConfig;
    }

    public List<DebugRuleConfiguration> debugRuleConfigurations() {
        return this.debugRuleConfigurations;
    }

    public TensorBoardOutputConfig tensorBoardOutputConfig() {
        return this.tensorBoardOutputConfig;
    }

    public List<DebugRuleEvaluationStatus> debugRuleEvaluationStatuses() {
        return this.debugRuleEvaluationStatuses;
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.trainingJobName());
        hashCode = 31 * hashCode + Objects.hashCode(this.trainingJobArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.tuningJobArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.labelingJobArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoMLJobArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelArtifacts());
        hashCode = 31 * hashCode + Objects.hashCode(this.trainingJobStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.secondaryStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.hyperParameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.algorithmSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputDataConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputDataConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.stoppingCondition());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.trainingStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.trainingEndTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.secondaryStatusTransitions());
        hashCode = 31 * hashCode + Objects.hashCode(this.finalMetricDataList());
        hashCode = 31 * hashCode + Objects.hashCode(this.enableNetworkIsolation());
        hashCode = 31 * hashCode + Objects.hashCode(this.enableInterContainerTrafficEncryption());
        hashCode = 31 * hashCode + Objects.hashCode(this.enableManagedSpotTraining());
        hashCode = 31 * hashCode + Objects.hashCode(this.checkpointConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.trainingTimeInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.billableTimeInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.debugHookConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.experimentConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.debugRuleConfigurations());
        hashCode = 31 * hashCode + Objects.hashCode(this.tensorBoardOutputConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.debugRuleEvaluationStatuses());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TrainingJob)) {
            return false;
        }
        TrainingJob other = (TrainingJob)obj;
        return Objects.equals(this.trainingJobName(), other.trainingJobName()) && Objects.equals(this.trainingJobArn(), other.trainingJobArn()) && Objects.equals(this.tuningJobArn(), other.tuningJobArn()) && Objects.equals(this.labelingJobArn(), other.labelingJobArn()) && Objects.equals(this.autoMLJobArn(), other.autoMLJobArn()) && Objects.equals(this.modelArtifacts(), other.modelArtifacts()) && Objects.equals(this.trainingJobStatusAsString(), other.trainingJobStatusAsString()) && Objects.equals(this.secondaryStatusAsString(), other.secondaryStatusAsString()) && Objects.equals(this.failureReason(), other.failureReason()) && Objects.equals(this.hyperParameters(), other.hyperParameters()) && Objects.equals(this.algorithmSpecification(), other.algorithmSpecification()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.inputDataConfig(), other.inputDataConfig()) && Objects.equals(this.outputDataConfig(), other.outputDataConfig()) && Objects.equals(this.resourceConfig(), other.resourceConfig()) && Objects.equals(this.vpcConfig(), other.vpcConfig()) && Objects.equals(this.stoppingCondition(), other.stoppingCondition()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.trainingStartTime(), other.trainingStartTime()) && Objects.equals(this.trainingEndTime(), other.trainingEndTime()) && Objects.equals(this.lastModifiedTime(), other.lastModifiedTime()) && Objects.equals(this.secondaryStatusTransitions(), other.secondaryStatusTransitions()) && Objects.equals(this.finalMetricDataList(), other.finalMetricDataList()) && Objects.equals(this.enableNetworkIsolation(), other.enableNetworkIsolation()) && Objects.equals(this.enableInterContainerTrafficEncryption(), other.enableInterContainerTrafficEncryption()) && Objects.equals(this.enableManagedSpotTraining(), other.enableManagedSpotTraining()) && Objects.equals(this.checkpointConfig(), other.checkpointConfig()) && Objects.equals(this.trainingTimeInSeconds(), other.trainingTimeInSeconds()) && Objects.equals(this.billableTimeInSeconds(), other.billableTimeInSeconds()) && Objects.equals(this.debugHookConfig(), other.debugHookConfig()) && Objects.equals(this.experimentConfig(), other.experimentConfig()) && Objects.equals(this.debugRuleConfigurations(), other.debugRuleConfigurations()) && Objects.equals(this.tensorBoardOutputConfig(), other.tensorBoardOutputConfig()) && Objects.equals(this.debugRuleEvaluationStatuses(), other.debugRuleEvaluationStatuses()) && Objects.equals(this.tags(), other.tags());
    }

    public String toString() {
        return ToString.builder((String)"TrainingJob").add("TrainingJobName", (Object)this.trainingJobName()).add("TrainingJobArn", (Object)this.trainingJobArn()).add("TuningJobArn", (Object)this.tuningJobArn()).add("LabelingJobArn", (Object)this.labelingJobArn()).add("AutoMLJobArn", (Object)this.autoMLJobArn()).add("ModelArtifacts", (Object)this.modelArtifacts()).add("TrainingJobStatus", (Object)this.trainingJobStatusAsString()).add("SecondaryStatus", (Object)this.secondaryStatusAsString()).add("FailureReason", (Object)this.failureReason()).add("HyperParameters", this.hyperParameters()).add("AlgorithmSpecification", (Object)this.algorithmSpecification()).add("RoleArn", (Object)this.roleArn()).add("InputDataConfig", this.inputDataConfig()).add("OutputDataConfig", (Object)this.outputDataConfig()).add("ResourceConfig", (Object)this.resourceConfig()).add("VpcConfig", (Object)this.vpcConfig()).add("StoppingCondition", (Object)this.stoppingCondition()).add("CreationTime", (Object)this.creationTime()).add("TrainingStartTime", (Object)this.trainingStartTime()).add("TrainingEndTime", (Object)this.trainingEndTime()).add("LastModifiedTime", (Object)this.lastModifiedTime()).add("SecondaryStatusTransitions", this.secondaryStatusTransitions()).add("FinalMetricDataList", this.finalMetricDataList()).add("EnableNetworkIsolation", (Object)this.enableNetworkIsolation()).add("EnableInterContainerTrafficEncryption", (Object)this.enableInterContainerTrafficEncryption()).add("EnableManagedSpotTraining", (Object)this.enableManagedSpotTraining()).add("CheckpointConfig", (Object)this.checkpointConfig()).add("TrainingTimeInSeconds", (Object)this.trainingTimeInSeconds()).add("BillableTimeInSeconds", (Object)this.billableTimeInSeconds()).add("DebugHookConfig", (Object)this.debugHookConfig()).add("ExperimentConfig", (Object)this.experimentConfig()).add("DebugRuleConfigurations", this.debugRuleConfigurations()).add("TensorBoardOutputConfig", (Object)this.tensorBoardOutputConfig()).add("DebugRuleEvaluationStatuses", this.debugRuleEvaluationStatuses()).add("Tags", this.tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TrainingJobName": {
                return Optional.ofNullable(clazz.cast(this.trainingJobName()));
            }
            case "TrainingJobArn": {
                return Optional.ofNullable(clazz.cast(this.trainingJobArn()));
            }
            case "TuningJobArn": {
                return Optional.ofNullable(clazz.cast(this.tuningJobArn()));
            }
            case "LabelingJobArn": {
                return Optional.ofNullable(clazz.cast(this.labelingJobArn()));
            }
            case "AutoMLJobArn": {
                return Optional.ofNullable(clazz.cast(this.autoMLJobArn()));
            }
            case "ModelArtifacts": {
                return Optional.ofNullable(clazz.cast(this.modelArtifacts()));
            }
            case "TrainingJobStatus": {
                return Optional.ofNullable(clazz.cast(this.trainingJobStatusAsString()));
            }
            case "SecondaryStatus": {
                return Optional.ofNullable(clazz.cast(this.secondaryStatusAsString()));
            }
            case "FailureReason": {
                return Optional.ofNullable(clazz.cast(this.failureReason()));
            }
            case "HyperParameters": {
                return Optional.ofNullable(clazz.cast(this.hyperParameters()));
            }
            case "AlgorithmSpecification": {
                return Optional.ofNullable(clazz.cast(this.algorithmSpecification()));
            }
            case "RoleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "InputDataConfig": {
                return Optional.ofNullable(clazz.cast(this.inputDataConfig()));
            }
            case "OutputDataConfig": {
                return Optional.ofNullable(clazz.cast(this.outputDataConfig()));
            }
            case "ResourceConfig": {
                return Optional.ofNullable(clazz.cast(this.resourceConfig()));
            }
            case "VpcConfig": {
                return Optional.ofNullable(clazz.cast(this.vpcConfig()));
            }
            case "StoppingCondition": {
                return Optional.ofNullable(clazz.cast(this.stoppingCondition()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "TrainingStartTime": {
                return Optional.ofNullable(clazz.cast(this.trainingStartTime()));
            }
            case "TrainingEndTime": {
                return Optional.ofNullable(clazz.cast(this.trainingEndTime()));
            }
            case "LastModifiedTime": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTime()));
            }
            case "SecondaryStatusTransitions": {
                return Optional.ofNullable(clazz.cast(this.secondaryStatusTransitions()));
            }
            case "FinalMetricDataList": {
                return Optional.ofNullable(clazz.cast(this.finalMetricDataList()));
            }
            case "EnableNetworkIsolation": {
                return Optional.ofNullable(clazz.cast(this.enableNetworkIsolation()));
            }
            case "EnableInterContainerTrafficEncryption": {
                return Optional.ofNullable(clazz.cast(this.enableInterContainerTrafficEncryption()));
            }
            case "EnableManagedSpotTraining": {
                return Optional.ofNullable(clazz.cast(this.enableManagedSpotTraining()));
            }
            case "CheckpointConfig": {
                return Optional.ofNullable(clazz.cast(this.checkpointConfig()));
            }
            case "TrainingTimeInSeconds": {
                return Optional.ofNullable(clazz.cast(this.trainingTimeInSeconds()));
            }
            case "BillableTimeInSeconds": {
                return Optional.ofNullable(clazz.cast(this.billableTimeInSeconds()));
            }
            case "DebugHookConfig": {
                return Optional.ofNullable(clazz.cast(this.debugHookConfig()));
            }
            case "ExperimentConfig": {
                return Optional.ofNullable(clazz.cast(this.experimentConfig()));
            }
            case "DebugRuleConfigurations": {
                return Optional.ofNullable(clazz.cast(this.debugRuleConfigurations()));
            }
            case "TensorBoardOutputConfig": {
                return Optional.ofNullable(clazz.cast(this.tensorBoardOutputConfig()));
            }
            case "DebugRuleEvaluationStatuses": {
                return Optional.ofNullable(clazz.cast(this.debugRuleEvaluationStatuses()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TrainingJob, T> g) {
        return obj -> g.apply((TrainingJob)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String trainingJobName;
        private String trainingJobArn;
        private String tuningJobArn;
        private String labelingJobArn;
        private String autoMLJobArn;
        private ModelArtifacts modelArtifacts;
        private String trainingJobStatus;
        private String secondaryStatus;
        private String failureReason;
        private Map<String, String> hyperParameters = DefaultSdkAutoConstructMap.getInstance();
        private AlgorithmSpecification algorithmSpecification;
        private String roleArn;
        private List<Channel> inputDataConfig = DefaultSdkAutoConstructList.getInstance();
        private OutputDataConfig outputDataConfig;
        private ResourceConfig resourceConfig;
        private VpcConfig vpcConfig;
        private StoppingCondition stoppingCondition;
        private Instant creationTime;
        private Instant trainingStartTime;
        private Instant trainingEndTime;
        private Instant lastModifiedTime;
        private List<SecondaryStatusTransition> secondaryStatusTransitions = DefaultSdkAutoConstructList.getInstance();
        private List<MetricData> finalMetricDataList = DefaultSdkAutoConstructList.getInstance();
        private Boolean enableNetworkIsolation;
        private Boolean enableInterContainerTrafficEncryption;
        private Boolean enableManagedSpotTraining;
        private CheckpointConfig checkpointConfig;
        private Integer trainingTimeInSeconds;
        private Integer billableTimeInSeconds;
        private DebugHookConfig debugHookConfig;
        private ExperimentConfig experimentConfig;
        private List<DebugRuleConfiguration> debugRuleConfigurations = DefaultSdkAutoConstructList.getInstance();
        private TensorBoardOutputConfig tensorBoardOutputConfig;
        private List<DebugRuleEvaluationStatus> debugRuleEvaluationStatuses = DefaultSdkAutoConstructList.getInstance();
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TrainingJob model) {
            this.trainingJobName(model.trainingJobName);
            this.trainingJobArn(model.trainingJobArn);
            this.tuningJobArn(model.tuningJobArn);
            this.labelingJobArn(model.labelingJobArn);
            this.autoMLJobArn(model.autoMLJobArn);
            this.modelArtifacts(model.modelArtifacts);
            this.trainingJobStatus(model.trainingJobStatus);
            this.secondaryStatus(model.secondaryStatus);
            this.failureReason(model.failureReason);
            this.hyperParameters(model.hyperParameters);
            this.algorithmSpecification(model.algorithmSpecification);
            this.roleArn(model.roleArn);
            this.inputDataConfig(model.inputDataConfig);
            this.outputDataConfig(model.outputDataConfig);
            this.resourceConfig(model.resourceConfig);
            this.vpcConfig(model.vpcConfig);
            this.stoppingCondition(model.stoppingCondition);
            this.creationTime(model.creationTime);
            this.trainingStartTime(model.trainingStartTime);
            this.trainingEndTime(model.trainingEndTime);
            this.lastModifiedTime(model.lastModifiedTime);
            this.secondaryStatusTransitions(model.secondaryStatusTransitions);
            this.finalMetricDataList(model.finalMetricDataList);
            this.enableNetworkIsolation(model.enableNetworkIsolation);
            this.enableInterContainerTrafficEncryption(model.enableInterContainerTrafficEncryption);
            this.enableManagedSpotTraining(model.enableManagedSpotTraining);
            this.checkpointConfig(model.checkpointConfig);
            this.trainingTimeInSeconds(model.trainingTimeInSeconds);
            this.billableTimeInSeconds(model.billableTimeInSeconds);
            this.debugHookConfig(model.debugHookConfig);
            this.experimentConfig(model.experimentConfig);
            this.debugRuleConfigurations(model.debugRuleConfigurations);
            this.tensorBoardOutputConfig(model.tensorBoardOutputConfig);
            this.debugRuleEvaluationStatuses(model.debugRuleEvaluationStatuses);
            this.tags(model.tags);
        }

        public final String getTrainingJobName() {
            return this.trainingJobName;
        }

        @Override
        public final Builder trainingJobName(String trainingJobName) {
            this.trainingJobName = trainingJobName;
            return this;
        }

        public final void setTrainingJobName(String trainingJobName) {
            this.trainingJobName = trainingJobName;
        }

        public final String getTrainingJobArn() {
            return this.trainingJobArn;
        }

        @Override
        public final Builder trainingJobArn(String trainingJobArn) {
            this.trainingJobArn = trainingJobArn;
            return this;
        }

        public final void setTrainingJobArn(String trainingJobArn) {
            this.trainingJobArn = trainingJobArn;
        }

        public final String getTuningJobArn() {
            return this.tuningJobArn;
        }

        @Override
        public final Builder tuningJobArn(String tuningJobArn) {
            this.tuningJobArn = tuningJobArn;
            return this;
        }

        public final void setTuningJobArn(String tuningJobArn) {
            this.tuningJobArn = tuningJobArn;
        }

        public final String getLabelingJobArn() {
            return this.labelingJobArn;
        }

        @Override
        public final Builder labelingJobArn(String labelingJobArn) {
            this.labelingJobArn = labelingJobArn;
            return this;
        }

        public final void setLabelingJobArn(String labelingJobArn) {
            this.labelingJobArn = labelingJobArn;
        }

        public final String getAutoMLJobArn() {
            return this.autoMLJobArn;
        }

        @Override
        public final Builder autoMLJobArn(String autoMLJobArn) {
            this.autoMLJobArn = autoMLJobArn;
            return this;
        }

        public final void setAutoMLJobArn(String autoMLJobArn) {
            this.autoMLJobArn = autoMLJobArn;
        }

        public final ModelArtifacts.Builder getModelArtifacts() {
            return this.modelArtifacts != null ? this.modelArtifacts.toBuilder() : null;
        }

        @Override
        public final Builder modelArtifacts(ModelArtifacts modelArtifacts) {
            this.modelArtifacts = modelArtifacts;
            return this;
        }

        public final void setModelArtifacts(ModelArtifacts.BuilderImpl modelArtifacts) {
            this.modelArtifacts = modelArtifacts != null ? modelArtifacts.build() : null;
        }

        public final String getTrainingJobStatusAsString() {
            return this.trainingJobStatus;
        }

        @Override
        public final Builder trainingJobStatus(String trainingJobStatus) {
            this.trainingJobStatus = trainingJobStatus;
            return this;
        }

        @Override
        public final Builder trainingJobStatus(TrainingJobStatus trainingJobStatus) {
            this.trainingJobStatus(trainingJobStatus == null ? null : trainingJobStatus.toString());
            return this;
        }

        public final void setTrainingJobStatus(String trainingJobStatus) {
            this.trainingJobStatus = trainingJobStatus;
        }

        public final String getSecondaryStatusAsString() {
            return this.secondaryStatus;
        }

        @Override
        public final Builder secondaryStatus(String secondaryStatus) {
            this.secondaryStatus = secondaryStatus;
            return this;
        }

        @Override
        public final Builder secondaryStatus(SecondaryStatus secondaryStatus) {
            this.secondaryStatus(secondaryStatus == null ? null : secondaryStatus.toString());
            return this;
        }

        public final void setSecondaryStatus(String secondaryStatus) {
            this.secondaryStatus = secondaryStatus;
        }

        public final String getFailureReason() {
            return this.failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        public final Map<String, String> getHyperParameters() {
            return this.hyperParameters;
        }

        @Override
        public final Builder hyperParameters(Map<String, String> hyperParameters) {
            this.hyperParameters = HyperParametersCopier.copy(hyperParameters);
            return this;
        }

        public final void setHyperParameters(Map<String, String> hyperParameters) {
            this.hyperParameters = HyperParametersCopier.copy(hyperParameters);
        }

        public final AlgorithmSpecification.Builder getAlgorithmSpecification() {
            return this.algorithmSpecification != null ? this.algorithmSpecification.toBuilder() : null;
        }

        @Override
        public final Builder algorithmSpecification(AlgorithmSpecification algorithmSpecification) {
            this.algorithmSpecification = algorithmSpecification;
            return this;
        }

        public final void setAlgorithmSpecification(AlgorithmSpecification.BuilderImpl algorithmSpecification) {
            this.algorithmSpecification = algorithmSpecification != null ? algorithmSpecification.build() : null;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final Collection<Channel.Builder> getInputDataConfig() {
            return this.inputDataConfig != null ? (Collection)this.inputDataConfig.stream().map(Channel::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder inputDataConfig(Collection<Channel> inputDataConfig) {
            this.inputDataConfig = InputDataConfigCopier.copy(inputDataConfig);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputDataConfig(Channel ... inputDataConfig) {
            this.inputDataConfig(Arrays.asList(inputDataConfig));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputDataConfig(Consumer<Channel.Builder> ... inputDataConfig) {
            this.inputDataConfig(Stream.of(inputDataConfig).map(c -> (Channel)((Channel.Builder)Channel.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setInputDataConfig(Collection<Channel.BuilderImpl> inputDataConfig) {
            this.inputDataConfig = InputDataConfigCopier.copyFromBuilder(inputDataConfig);
        }

        public final OutputDataConfig.Builder getOutputDataConfig() {
            return this.outputDataConfig != null ? this.outputDataConfig.toBuilder() : null;
        }

        @Override
        public final Builder outputDataConfig(OutputDataConfig outputDataConfig) {
            this.outputDataConfig = outputDataConfig;
            return this;
        }

        public final void setOutputDataConfig(OutputDataConfig.BuilderImpl outputDataConfig) {
            this.outputDataConfig = outputDataConfig != null ? outputDataConfig.build() : null;
        }

        public final ResourceConfig.Builder getResourceConfig() {
            return this.resourceConfig != null ? this.resourceConfig.toBuilder() : null;
        }

        @Override
        public final Builder resourceConfig(ResourceConfig resourceConfig) {
            this.resourceConfig = resourceConfig;
            return this;
        }

        public final void setResourceConfig(ResourceConfig.BuilderImpl resourceConfig) {
            this.resourceConfig = resourceConfig != null ? resourceConfig.build() : null;
        }

        public final VpcConfig.Builder getVpcConfig() {
            return this.vpcConfig != null ? this.vpcConfig.toBuilder() : null;
        }

        @Override
        public final Builder vpcConfig(VpcConfig vpcConfig) {
            this.vpcConfig = vpcConfig;
            return this;
        }

        public final void setVpcConfig(VpcConfig.BuilderImpl vpcConfig) {
            this.vpcConfig = vpcConfig != null ? vpcConfig.build() : null;
        }

        public final StoppingCondition.Builder getStoppingCondition() {
            return this.stoppingCondition != null ? this.stoppingCondition.toBuilder() : null;
        }

        @Override
        public final Builder stoppingCondition(StoppingCondition stoppingCondition) {
            this.stoppingCondition = stoppingCondition;
            return this;
        }

        public final void setStoppingCondition(StoppingCondition.BuilderImpl stoppingCondition) {
            this.stoppingCondition = stoppingCondition != null ? stoppingCondition.build() : null;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final Instant getTrainingStartTime() {
            return this.trainingStartTime;
        }

        @Override
        public final Builder trainingStartTime(Instant trainingStartTime) {
            this.trainingStartTime = trainingStartTime;
            return this;
        }

        public final void setTrainingStartTime(Instant trainingStartTime) {
            this.trainingStartTime = trainingStartTime;
        }

        public final Instant getTrainingEndTime() {
            return this.trainingEndTime;
        }

        @Override
        public final Builder trainingEndTime(Instant trainingEndTime) {
            this.trainingEndTime = trainingEndTime;
            return this;
        }

        public final void setTrainingEndTime(Instant trainingEndTime) {
            this.trainingEndTime = trainingEndTime;
        }

        public final Instant getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        public final Collection<SecondaryStatusTransition.Builder> getSecondaryStatusTransitions() {
            return this.secondaryStatusTransitions != null ? (Collection)this.secondaryStatusTransitions.stream().map(SecondaryStatusTransition::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder secondaryStatusTransitions(Collection<SecondaryStatusTransition> secondaryStatusTransitions) {
            this.secondaryStatusTransitions = SecondaryStatusTransitionsCopier.copy(secondaryStatusTransitions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder secondaryStatusTransitions(SecondaryStatusTransition ... secondaryStatusTransitions) {
            this.secondaryStatusTransitions(Arrays.asList(secondaryStatusTransitions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder secondaryStatusTransitions(Consumer<SecondaryStatusTransition.Builder> ... secondaryStatusTransitions) {
            this.secondaryStatusTransitions(Stream.of(secondaryStatusTransitions).map(c -> (SecondaryStatusTransition)((SecondaryStatusTransition.Builder)SecondaryStatusTransition.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSecondaryStatusTransitions(Collection<SecondaryStatusTransition.BuilderImpl> secondaryStatusTransitions) {
            this.secondaryStatusTransitions = SecondaryStatusTransitionsCopier.copyFromBuilder(secondaryStatusTransitions);
        }

        public final Collection<MetricData.Builder> getFinalMetricDataList() {
            return this.finalMetricDataList != null ? (Collection)this.finalMetricDataList.stream().map(MetricData::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder finalMetricDataList(Collection<MetricData> finalMetricDataList) {
            this.finalMetricDataList = FinalMetricDataListCopier.copy(finalMetricDataList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder finalMetricDataList(MetricData ... finalMetricDataList) {
            this.finalMetricDataList(Arrays.asList(finalMetricDataList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder finalMetricDataList(Consumer<MetricData.Builder> ... finalMetricDataList) {
            this.finalMetricDataList(Stream.of(finalMetricDataList).map(c -> (MetricData)((MetricData.Builder)MetricData.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFinalMetricDataList(Collection<MetricData.BuilderImpl> finalMetricDataList) {
            this.finalMetricDataList = FinalMetricDataListCopier.copyFromBuilder(finalMetricDataList);
        }

        public final Boolean getEnableNetworkIsolation() {
            return this.enableNetworkIsolation;
        }

        @Override
        public final Builder enableNetworkIsolation(Boolean enableNetworkIsolation) {
            this.enableNetworkIsolation = enableNetworkIsolation;
            return this;
        }

        public final void setEnableNetworkIsolation(Boolean enableNetworkIsolation) {
            this.enableNetworkIsolation = enableNetworkIsolation;
        }

        public final Boolean getEnableInterContainerTrafficEncryption() {
            return this.enableInterContainerTrafficEncryption;
        }

        @Override
        public final Builder enableInterContainerTrafficEncryption(Boolean enableInterContainerTrafficEncryption) {
            this.enableInterContainerTrafficEncryption = enableInterContainerTrafficEncryption;
            return this;
        }

        public final void setEnableInterContainerTrafficEncryption(Boolean enableInterContainerTrafficEncryption) {
            this.enableInterContainerTrafficEncryption = enableInterContainerTrafficEncryption;
        }

        public final Boolean getEnableManagedSpotTraining() {
            return this.enableManagedSpotTraining;
        }

        @Override
        public final Builder enableManagedSpotTraining(Boolean enableManagedSpotTraining) {
            this.enableManagedSpotTraining = enableManagedSpotTraining;
            return this;
        }

        public final void setEnableManagedSpotTraining(Boolean enableManagedSpotTraining) {
            this.enableManagedSpotTraining = enableManagedSpotTraining;
        }

        public final CheckpointConfig.Builder getCheckpointConfig() {
            return this.checkpointConfig != null ? this.checkpointConfig.toBuilder() : null;
        }

        @Override
        public final Builder checkpointConfig(CheckpointConfig checkpointConfig) {
            this.checkpointConfig = checkpointConfig;
            return this;
        }

        public final void setCheckpointConfig(CheckpointConfig.BuilderImpl checkpointConfig) {
            this.checkpointConfig = checkpointConfig != null ? checkpointConfig.build() : null;
        }

        public final Integer getTrainingTimeInSeconds() {
            return this.trainingTimeInSeconds;
        }

        @Override
        public final Builder trainingTimeInSeconds(Integer trainingTimeInSeconds) {
            this.trainingTimeInSeconds = trainingTimeInSeconds;
            return this;
        }

        public final void setTrainingTimeInSeconds(Integer trainingTimeInSeconds) {
            this.trainingTimeInSeconds = trainingTimeInSeconds;
        }

        public final Integer getBillableTimeInSeconds() {
            return this.billableTimeInSeconds;
        }

        @Override
        public final Builder billableTimeInSeconds(Integer billableTimeInSeconds) {
            this.billableTimeInSeconds = billableTimeInSeconds;
            return this;
        }

        public final void setBillableTimeInSeconds(Integer billableTimeInSeconds) {
            this.billableTimeInSeconds = billableTimeInSeconds;
        }

        public final DebugHookConfig.Builder getDebugHookConfig() {
            return this.debugHookConfig != null ? this.debugHookConfig.toBuilder() : null;
        }

        @Override
        public final Builder debugHookConfig(DebugHookConfig debugHookConfig) {
            this.debugHookConfig = debugHookConfig;
            return this;
        }

        public final void setDebugHookConfig(DebugHookConfig.BuilderImpl debugHookConfig) {
            this.debugHookConfig = debugHookConfig != null ? debugHookConfig.build() : null;
        }

        public final ExperimentConfig.Builder getExperimentConfig() {
            return this.experimentConfig != null ? this.experimentConfig.toBuilder() : null;
        }

        @Override
        public final Builder experimentConfig(ExperimentConfig experimentConfig) {
            this.experimentConfig = experimentConfig;
            return this;
        }

        public final void setExperimentConfig(ExperimentConfig.BuilderImpl experimentConfig) {
            this.experimentConfig = experimentConfig != null ? experimentConfig.build() : null;
        }

        public final Collection<DebugRuleConfiguration.Builder> getDebugRuleConfigurations() {
            return this.debugRuleConfigurations != null ? (Collection)this.debugRuleConfigurations.stream().map(DebugRuleConfiguration::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder debugRuleConfigurations(Collection<DebugRuleConfiguration> debugRuleConfigurations) {
            this.debugRuleConfigurations = DebugRuleConfigurationsCopier.copy(debugRuleConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder debugRuleConfigurations(DebugRuleConfiguration ... debugRuleConfigurations) {
            this.debugRuleConfigurations(Arrays.asList(debugRuleConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder debugRuleConfigurations(Consumer<DebugRuleConfiguration.Builder> ... debugRuleConfigurations) {
            this.debugRuleConfigurations(Stream.of(debugRuleConfigurations).map(c -> (DebugRuleConfiguration)((DebugRuleConfiguration.Builder)DebugRuleConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDebugRuleConfigurations(Collection<DebugRuleConfiguration.BuilderImpl> debugRuleConfigurations) {
            this.debugRuleConfigurations = DebugRuleConfigurationsCopier.copyFromBuilder(debugRuleConfigurations);
        }

        public final TensorBoardOutputConfig.Builder getTensorBoardOutputConfig() {
            return this.tensorBoardOutputConfig != null ? this.tensorBoardOutputConfig.toBuilder() : null;
        }

        @Override
        public final Builder tensorBoardOutputConfig(TensorBoardOutputConfig tensorBoardOutputConfig) {
            this.tensorBoardOutputConfig = tensorBoardOutputConfig;
            return this;
        }

        public final void setTensorBoardOutputConfig(TensorBoardOutputConfig.BuilderImpl tensorBoardOutputConfig) {
            this.tensorBoardOutputConfig = tensorBoardOutputConfig != null ? tensorBoardOutputConfig.build() : null;
        }

        public final Collection<DebugRuleEvaluationStatus.Builder> getDebugRuleEvaluationStatuses() {
            return this.debugRuleEvaluationStatuses != null ? (Collection)this.debugRuleEvaluationStatuses.stream().map(DebugRuleEvaluationStatus::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder debugRuleEvaluationStatuses(Collection<DebugRuleEvaluationStatus> debugRuleEvaluationStatuses) {
            this.debugRuleEvaluationStatuses = DebugRuleEvaluationStatusesCopier.copy(debugRuleEvaluationStatuses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder debugRuleEvaluationStatuses(DebugRuleEvaluationStatus ... debugRuleEvaluationStatuses) {
            this.debugRuleEvaluationStatuses(Arrays.asList(debugRuleEvaluationStatuses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder debugRuleEvaluationStatuses(Consumer<DebugRuleEvaluationStatus.Builder> ... debugRuleEvaluationStatuses) {
            this.debugRuleEvaluationStatuses(Stream.of(debugRuleEvaluationStatuses).map(c -> (DebugRuleEvaluationStatus)((DebugRuleEvaluationStatus.Builder)DebugRuleEvaluationStatus.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDebugRuleEvaluationStatuses(Collection<DebugRuleEvaluationStatus.BuilderImpl> debugRuleEvaluationStatuses) {
            this.debugRuleEvaluationStatuses = DebugRuleEvaluationStatusesCopier.copyFromBuilder(debugRuleEvaluationStatuses);
        }

        public final Collection<Tag.Builder> getTags() {
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public TrainingJob build() {
            return new TrainingJob(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TrainingJob> {
        public Builder trainingJobName(String var1);

        public Builder trainingJobArn(String var1);

        public Builder tuningJobArn(String var1);

        public Builder labelingJobArn(String var1);

        public Builder autoMLJobArn(String var1);

        public Builder modelArtifacts(ModelArtifacts var1);

        default public Builder modelArtifacts(Consumer<ModelArtifacts.Builder> modelArtifacts) {
            return this.modelArtifacts((ModelArtifacts)((ModelArtifacts.Builder)ModelArtifacts.builder().applyMutation(modelArtifacts)).build());
        }

        public Builder trainingJobStatus(String var1);

        public Builder trainingJobStatus(TrainingJobStatus var1);

        public Builder secondaryStatus(String var1);

        public Builder secondaryStatus(SecondaryStatus var1);

        public Builder failureReason(String var1);

        public Builder hyperParameters(Map<String, String> var1);

        public Builder algorithmSpecification(AlgorithmSpecification var1);

        default public Builder algorithmSpecification(Consumer<AlgorithmSpecification.Builder> algorithmSpecification) {
            return this.algorithmSpecification((AlgorithmSpecification)((AlgorithmSpecification.Builder)AlgorithmSpecification.builder().applyMutation(algorithmSpecification)).build());
        }

        public Builder roleArn(String var1);

        public Builder inputDataConfig(Collection<Channel> var1);

        public Builder inputDataConfig(Channel ... var1);

        public Builder inputDataConfig(Consumer<Channel.Builder> ... var1);

        public Builder outputDataConfig(OutputDataConfig var1);

        default public Builder outputDataConfig(Consumer<OutputDataConfig.Builder> outputDataConfig) {
            return this.outputDataConfig((OutputDataConfig)((OutputDataConfig.Builder)OutputDataConfig.builder().applyMutation(outputDataConfig)).build());
        }

        public Builder resourceConfig(ResourceConfig var1);

        default public Builder resourceConfig(Consumer<ResourceConfig.Builder> resourceConfig) {
            return this.resourceConfig((ResourceConfig)((ResourceConfig.Builder)ResourceConfig.builder().applyMutation(resourceConfig)).build());
        }

        public Builder vpcConfig(VpcConfig var1);

        default public Builder vpcConfig(Consumer<VpcConfig.Builder> vpcConfig) {
            return this.vpcConfig((VpcConfig)((VpcConfig.Builder)VpcConfig.builder().applyMutation(vpcConfig)).build());
        }

        public Builder stoppingCondition(StoppingCondition var1);

        default public Builder stoppingCondition(Consumer<StoppingCondition.Builder> stoppingCondition) {
            return this.stoppingCondition((StoppingCondition)((StoppingCondition.Builder)StoppingCondition.builder().applyMutation(stoppingCondition)).build());
        }

        public Builder creationTime(Instant var1);

        public Builder trainingStartTime(Instant var1);

        public Builder trainingEndTime(Instant var1);

        public Builder lastModifiedTime(Instant var1);

        public Builder secondaryStatusTransitions(Collection<SecondaryStatusTransition> var1);

        public Builder secondaryStatusTransitions(SecondaryStatusTransition ... var1);

        public Builder secondaryStatusTransitions(Consumer<SecondaryStatusTransition.Builder> ... var1);

        public Builder finalMetricDataList(Collection<MetricData> var1);

        public Builder finalMetricDataList(MetricData ... var1);

        public Builder finalMetricDataList(Consumer<MetricData.Builder> ... var1);

        public Builder enableNetworkIsolation(Boolean var1);

        public Builder enableInterContainerTrafficEncryption(Boolean var1);

        public Builder enableManagedSpotTraining(Boolean var1);

        public Builder checkpointConfig(CheckpointConfig var1);

        default public Builder checkpointConfig(Consumer<CheckpointConfig.Builder> checkpointConfig) {
            return this.checkpointConfig((CheckpointConfig)((CheckpointConfig.Builder)CheckpointConfig.builder().applyMutation(checkpointConfig)).build());
        }

        public Builder trainingTimeInSeconds(Integer var1);

        public Builder billableTimeInSeconds(Integer var1);

        public Builder debugHookConfig(DebugHookConfig var1);

        default public Builder debugHookConfig(Consumer<DebugHookConfig.Builder> debugHookConfig) {
            return this.debugHookConfig((DebugHookConfig)((DebugHookConfig.Builder)DebugHookConfig.builder().applyMutation(debugHookConfig)).build());
        }

        public Builder experimentConfig(ExperimentConfig var1);

        default public Builder experimentConfig(Consumer<ExperimentConfig.Builder> experimentConfig) {
            return this.experimentConfig((ExperimentConfig)((ExperimentConfig.Builder)ExperimentConfig.builder().applyMutation(experimentConfig)).build());
        }

        public Builder debugRuleConfigurations(Collection<DebugRuleConfiguration> var1);

        public Builder debugRuleConfigurations(DebugRuleConfiguration ... var1);

        public Builder debugRuleConfigurations(Consumer<DebugRuleConfiguration.Builder> ... var1);

        public Builder tensorBoardOutputConfig(TensorBoardOutputConfig var1);

        default public Builder tensorBoardOutputConfig(Consumer<TensorBoardOutputConfig.Builder> tensorBoardOutputConfig) {
            return this.tensorBoardOutputConfig((TensorBoardOutputConfig)((TensorBoardOutputConfig.Builder)TensorBoardOutputConfig.builder().applyMutation(tensorBoardOutputConfig)).build());
        }

        public Builder debugRuleEvaluationStatuses(Collection<DebugRuleEvaluationStatus> var1);

        public Builder debugRuleEvaluationStatuses(DebugRuleEvaluationStatus ... var1);

        public Builder debugRuleEvaluationStatuses(Consumer<DebugRuleEvaluationStatus.Builder> ... var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);
    }
}

