/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.InstanceType;
import software.amazon.awssdk.services.sagemaker.model.NotebookInstanceStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NotebookInstanceSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, NotebookInstanceSummary> {
    private static final SdkField<String> NOTEBOOK_INSTANCE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(NotebookInstanceSummary.getter(NotebookInstanceSummary::notebookInstanceName)).setter(NotebookInstanceSummary.setter(Builder::notebookInstanceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotebookInstanceName").build()}).build();
    private static final SdkField<String> NOTEBOOK_INSTANCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(NotebookInstanceSummary.getter(NotebookInstanceSummary::notebookInstanceArn)).setter(NotebookInstanceSummary.setter(Builder::notebookInstanceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotebookInstanceArn").build()}).build();
    private static final SdkField<String> NOTEBOOK_INSTANCE_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(NotebookInstanceSummary.getter(NotebookInstanceSummary::notebookInstanceStatusAsString)).setter(NotebookInstanceSummary.setter(Builder::notebookInstanceStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotebookInstanceStatus").build()}).build();
    private static final SdkField<String> URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(NotebookInstanceSummary.getter(NotebookInstanceSummary::url)).setter(NotebookInstanceSummary.setter(Builder::url)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Url").build()}).build();
    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(NotebookInstanceSummary.getter(NotebookInstanceSummary::instanceTypeAsString)).setter(NotebookInstanceSummary.setter(Builder::instanceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(NotebookInstanceSummary.getter(NotebookInstanceSummary::creationTime)).setter(NotebookInstanceSummary.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(NotebookInstanceSummary.getter(NotebookInstanceSummary::lastModifiedTime)).setter(NotebookInstanceSummary.setter(Builder::lastModifiedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()}).build();
    private static final SdkField<String> NOTEBOOK_INSTANCE_LIFECYCLE_CONFIG_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(NotebookInstanceSummary.getter(NotebookInstanceSummary::notebookInstanceLifecycleConfigName)).setter(NotebookInstanceSummary.setter(Builder::notebookInstanceLifecycleConfigName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotebookInstanceLifecycleConfigName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NOTEBOOK_INSTANCE_NAME_FIELD, NOTEBOOK_INSTANCE_ARN_FIELD, NOTEBOOK_INSTANCE_STATUS_FIELD, URL_FIELD, INSTANCE_TYPE_FIELD, CREATION_TIME_FIELD, LAST_MODIFIED_TIME_FIELD, NOTEBOOK_INSTANCE_LIFECYCLE_CONFIG_NAME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String notebookInstanceName;
    private final String notebookInstanceArn;
    private final String notebookInstanceStatus;
    private final String url;
    private final String instanceType;
    private final Instant creationTime;
    private final Instant lastModifiedTime;
    private final String notebookInstanceLifecycleConfigName;

    private NotebookInstanceSummary(BuilderImpl builder) {
        this.notebookInstanceName = builder.notebookInstanceName;
        this.notebookInstanceArn = builder.notebookInstanceArn;
        this.notebookInstanceStatus = builder.notebookInstanceStatus;
        this.url = builder.url;
        this.instanceType = builder.instanceType;
        this.creationTime = builder.creationTime;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.notebookInstanceLifecycleConfigName = builder.notebookInstanceLifecycleConfigName;
    }

    public String notebookInstanceName() {
        return this.notebookInstanceName;
    }

    public String notebookInstanceArn() {
        return this.notebookInstanceArn;
    }

    public NotebookInstanceStatus notebookInstanceStatus() {
        return NotebookInstanceStatus.fromValue(this.notebookInstanceStatus);
    }

    public String notebookInstanceStatusAsString() {
        return this.notebookInstanceStatus;
    }

    public String url() {
        return this.url;
    }

    public InstanceType instanceType() {
        return InstanceType.fromValue(this.instanceType);
    }

    public String instanceTypeAsString() {
        return this.instanceType;
    }

    public Instant creationTime() {
        return this.creationTime;
    }

    public Instant lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public String notebookInstanceLifecycleConfigName() {
        return this.notebookInstanceLifecycleConfigName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.notebookInstanceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.notebookInstanceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.notebookInstanceStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.url());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.notebookInstanceLifecycleConfigName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NotebookInstanceSummary)) {
            return false;
        }
        NotebookInstanceSummary other = (NotebookInstanceSummary)obj;
        return Objects.equals(this.notebookInstanceName(), other.notebookInstanceName()) && Objects.equals(this.notebookInstanceArn(), other.notebookInstanceArn()) && Objects.equals(this.notebookInstanceStatusAsString(), other.notebookInstanceStatusAsString()) && Objects.equals(this.url(), other.url()) && Objects.equals(this.instanceTypeAsString(), other.instanceTypeAsString()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.lastModifiedTime(), other.lastModifiedTime()) && Objects.equals(this.notebookInstanceLifecycleConfigName(), other.notebookInstanceLifecycleConfigName());
    }

    public String toString() {
        return ToString.builder((String)"NotebookInstanceSummary").add("NotebookInstanceName", (Object)this.notebookInstanceName()).add("NotebookInstanceArn", (Object)this.notebookInstanceArn()).add("NotebookInstanceStatus", (Object)this.notebookInstanceStatusAsString()).add("Url", (Object)this.url()).add("InstanceType", (Object)this.instanceTypeAsString()).add("CreationTime", (Object)this.creationTime()).add("LastModifiedTime", (Object)this.lastModifiedTime()).add("NotebookInstanceLifecycleConfigName", (Object)this.notebookInstanceLifecycleConfigName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NotebookInstanceName": {
                return Optional.ofNullable(clazz.cast(this.notebookInstanceName()));
            }
            case "NotebookInstanceArn": {
                return Optional.ofNullable(clazz.cast(this.notebookInstanceArn()));
            }
            case "NotebookInstanceStatus": {
                return Optional.ofNullable(clazz.cast(this.notebookInstanceStatusAsString()));
            }
            case "Url": {
                return Optional.ofNullable(clazz.cast(this.url()));
            }
            case "InstanceType": {
                return Optional.ofNullable(clazz.cast(this.instanceTypeAsString()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "LastModifiedTime": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTime()));
            }
            case "NotebookInstanceLifecycleConfigName": {
                return Optional.ofNullable(clazz.cast(this.notebookInstanceLifecycleConfigName()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NotebookInstanceSummary, T> g) {
        return obj -> g.apply((NotebookInstanceSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String notebookInstanceName;
        private String notebookInstanceArn;
        private String notebookInstanceStatus;
        private String url;
        private String instanceType;
        private Instant creationTime;
        private Instant lastModifiedTime;
        private String notebookInstanceLifecycleConfigName;

        private BuilderImpl() {
        }

        private BuilderImpl(NotebookInstanceSummary model) {
            this.notebookInstanceName(model.notebookInstanceName);
            this.notebookInstanceArn(model.notebookInstanceArn);
            this.notebookInstanceStatus(model.notebookInstanceStatus);
            this.url(model.url);
            this.instanceType(model.instanceType);
            this.creationTime(model.creationTime);
            this.lastModifiedTime(model.lastModifiedTime);
            this.notebookInstanceLifecycleConfigName(model.notebookInstanceLifecycleConfigName);
        }

        public final String getNotebookInstanceName() {
            return this.notebookInstanceName;
        }

        @Override
        public final Builder notebookInstanceName(String notebookInstanceName) {
            this.notebookInstanceName = notebookInstanceName;
            return this;
        }

        public final void setNotebookInstanceName(String notebookInstanceName) {
            this.notebookInstanceName = notebookInstanceName;
        }

        public final String getNotebookInstanceArn() {
            return this.notebookInstanceArn;
        }

        @Override
        public final Builder notebookInstanceArn(String notebookInstanceArn) {
            this.notebookInstanceArn = notebookInstanceArn;
            return this;
        }

        public final void setNotebookInstanceArn(String notebookInstanceArn) {
            this.notebookInstanceArn = notebookInstanceArn;
        }

        public final String getNotebookInstanceStatus() {
            return this.notebookInstanceStatus;
        }

        @Override
        public final Builder notebookInstanceStatus(String notebookInstanceStatus) {
            this.notebookInstanceStatus = notebookInstanceStatus;
            return this;
        }

        @Override
        public final Builder notebookInstanceStatus(NotebookInstanceStatus notebookInstanceStatus) {
            this.notebookInstanceStatus(notebookInstanceStatus.toString());
            return this;
        }

        public final void setNotebookInstanceStatus(String notebookInstanceStatus) {
            this.notebookInstanceStatus = notebookInstanceStatus;
        }

        public final String getUrl() {
            return this.url;
        }

        @Override
        public final Builder url(String url) {
            this.url = url;
            return this;
        }

        public final void setUrl(String url) {
            this.url = url;
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        @Override
        public final Builder instanceType(InstanceType instanceType) {
            this.instanceType(instanceType.toString());
            return this;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final Instant getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        public final String getNotebookInstanceLifecycleConfigName() {
            return this.notebookInstanceLifecycleConfigName;
        }

        @Override
        public final Builder notebookInstanceLifecycleConfigName(String notebookInstanceLifecycleConfigName) {
            this.notebookInstanceLifecycleConfigName = notebookInstanceLifecycleConfigName;
            return this;
        }

        public final void setNotebookInstanceLifecycleConfigName(String notebookInstanceLifecycleConfigName) {
            this.notebookInstanceLifecycleConfigName = notebookInstanceLifecycleConfigName;
        }

        public NotebookInstanceSummary build() {
            return new NotebookInstanceSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, NotebookInstanceSummary> {
        public Builder notebookInstanceName(String var1);

        public Builder notebookInstanceArn(String var1);

        public Builder notebookInstanceStatus(String var1);

        public Builder notebookInstanceStatus(NotebookInstanceStatus var1);

        public Builder url(String var1);

        public Builder instanceType(String var1);

        public Builder instanceType(InstanceType var1);

        public Builder creationTime(Instant var1);

        public Builder lastModifiedTime(Instant var1);

        public Builder notebookInstanceLifecycleConfigName(String var1);
    }
}

