/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.ContainerDefinition;
import software.amazon.awssdk.services.sagemaker.model.SageMakerResponse;
import software.amazon.awssdk.services.sagemaker.model.VpcConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeModelResponse
extends SageMakerResponse
implements ToCopyableBuilder<Builder, DescribeModelResponse> {
    private static final SdkField<String> MODEL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeModelResponse.getter(DescribeModelResponse::modelName)).setter(DescribeModelResponse.setter(Builder::modelName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelName").build()}).build();
    private static final SdkField<ContainerDefinition> PRIMARY_CONTAINER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(DescribeModelResponse.getter(DescribeModelResponse::primaryContainer)).setter(DescribeModelResponse.setter(Builder::primaryContainer)).constructor(ContainerDefinition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrimaryContainer").build()}).build();
    private static final SdkField<String> EXECUTION_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeModelResponse.getter(DescribeModelResponse::executionRoleArn)).setter(DescribeModelResponse.setter(Builder::executionRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionRoleArn").build()}).build();
    private static final SdkField<VpcConfig> VPC_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(DescribeModelResponse.getter(DescribeModelResponse::vpcConfig)).setter(DescribeModelResponse.setter(Builder::vpcConfig)).constructor(VpcConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcConfig").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(DescribeModelResponse.getter(DescribeModelResponse::creationTime)).setter(DescribeModelResponse.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<String> MODEL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeModelResponse.getter(DescribeModelResponse::modelArn)).setter(DescribeModelResponse.setter(Builder::modelArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_NAME_FIELD, PRIMARY_CONTAINER_FIELD, EXECUTION_ROLE_ARN_FIELD, VPC_CONFIG_FIELD, CREATION_TIME_FIELD, MODEL_ARN_FIELD));
    private final String modelName;
    private final ContainerDefinition primaryContainer;
    private final String executionRoleArn;
    private final VpcConfig vpcConfig;
    private final Instant creationTime;
    private final String modelArn;

    private DescribeModelResponse(BuilderImpl builder) {
        super(builder);
        this.modelName = builder.modelName;
        this.primaryContainer = builder.primaryContainer;
        this.executionRoleArn = builder.executionRoleArn;
        this.vpcConfig = builder.vpcConfig;
        this.creationTime = builder.creationTime;
        this.modelArn = builder.modelArn;
    }

    public String modelName() {
        return this.modelName;
    }

    public ContainerDefinition primaryContainer() {
        return this.primaryContainer;
    }

    public String executionRoleArn() {
        return this.executionRoleArn;
    }

    public VpcConfig vpcConfig() {
        return this.vpcConfig;
    }

    public Instant creationTime() {
        return this.creationTime;
    }

    public String modelArn() {
        return this.modelArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.modelName());
        hashCode = 31 * hashCode + Objects.hashCode(this.primaryContainer());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelArn());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeModelResponse)) {
            return false;
        }
        DescribeModelResponse other = (DescribeModelResponse)((Object)obj);
        return Objects.equals(this.modelName(), other.modelName()) && Objects.equals(this.primaryContainer(), other.primaryContainer()) && Objects.equals(this.executionRoleArn(), other.executionRoleArn()) && Objects.equals(this.vpcConfig(), other.vpcConfig()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.modelArn(), other.modelArn());
    }

    public String toString() {
        return ToString.builder((String)"DescribeModelResponse").add("ModelName", (Object)this.modelName()).add("PrimaryContainer", (Object)this.primaryContainer()).add("ExecutionRoleArn", (Object)this.executionRoleArn()).add("VpcConfig", (Object)this.vpcConfig()).add("CreationTime", (Object)this.creationTime()).add("ModelArn", (Object)this.modelArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ModelName": {
                return Optional.ofNullable(clazz.cast(this.modelName()));
            }
            case "PrimaryContainer": {
                return Optional.ofNullable(clazz.cast(this.primaryContainer()));
            }
            case "ExecutionRoleArn": {
                return Optional.ofNullable(clazz.cast(this.executionRoleArn()));
            }
            case "VpcConfig": {
                return Optional.ofNullable(clazz.cast(this.vpcConfig()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "ModelArn": {
                return Optional.ofNullable(clazz.cast(this.modelArn()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeModelResponse, T> g) {
        return obj -> g.apply((DescribeModelResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerResponse.BuilderImpl
    implements Builder {
        private String modelName;
        private ContainerDefinition primaryContainer;
        private String executionRoleArn;
        private VpcConfig vpcConfig;
        private Instant creationTime;
        private String modelArn;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeModelResponse model) {
            super(model);
            this.modelName(model.modelName);
            this.primaryContainer(model.primaryContainer);
            this.executionRoleArn(model.executionRoleArn);
            this.vpcConfig(model.vpcConfig);
            this.creationTime(model.creationTime);
            this.modelArn(model.modelArn);
        }

        public final String getModelName() {
            return this.modelName;
        }

        @Override
        public final Builder modelName(String modelName) {
            this.modelName = modelName;
            return this;
        }

        public final void setModelName(String modelName) {
            this.modelName = modelName;
        }

        public final ContainerDefinition.Builder getPrimaryContainer() {
            return this.primaryContainer != null ? this.primaryContainer.toBuilder() : null;
        }

        @Override
        public final Builder primaryContainer(ContainerDefinition primaryContainer) {
            this.primaryContainer = primaryContainer;
            return this;
        }

        public final void setPrimaryContainer(ContainerDefinition.BuilderImpl primaryContainer) {
            this.primaryContainer = primaryContainer != null ? primaryContainer.build() : null;
        }

        public final String getExecutionRoleArn() {
            return this.executionRoleArn;
        }

        @Override
        public final Builder executionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
            return this;
        }

        public final void setExecutionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
        }

        public final VpcConfig.Builder getVpcConfig() {
            return this.vpcConfig != null ? this.vpcConfig.toBuilder() : null;
        }

        @Override
        public final Builder vpcConfig(VpcConfig vpcConfig) {
            this.vpcConfig = vpcConfig;
            return this;
        }

        public final void setVpcConfig(VpcConfig.BuilderImpl vpcConfig) {
            this.vpcConfig = vpcConfig != null ? vpcConfig.build() : null;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final String getModelArn() {
            return this.modelArn;
        }

        @Override
        public final Builder modelArn(String modelArn) {
            this.modelArn = modelArn;
            return this;
        }

        public final void setModelArn(String modelArn) {
            this.modelArn = modelArn;
        }

        @Override
        public DescribeModelResponse build() {
            return new DescribeModelResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SageMakerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeModelResponse> {
        public Builder modelName(String var1);

        public Builder primaryContainer(ContainerDefinition var1);

        default public Builder primaryContainer(Consumer<ContainerDefinition.Builder> primaryContainer) {
            return this.primaryContainer((ContainerDefinition)((ContainerDefinition.Builder)ContainerDefinition.builder().applyMutation(primaryContainer)).build());
        }

        public Builder executionRoleArn(String var1);

        public Builder vpcConfig(VpcConfig var1);

        default public Builder vpcConfig(Consumer<VpcConfig.Builder> vpcConfig) {
            return this.vpcConfig((VpcConfig)((VpcConfig.Builder)VpcConfig.builder().applyMutation(vpcConfig)).build());
        }

        public Builder creationTime(Instant var1);

        public Builder modelArn(String var1);
    }
}

