/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sagemaker.SageMakerAsyncClient;
import software.amazon.awssdk.services.sagemaker.model.ListEndpointsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListEndpointsResponse;

public class ListEndpointsPublisher
implements SdkPublisher<ListEndpointsResponse> {
    private final SageMakerAsyncClient client;
    private final ListEndpointsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListEndpointsPublisher(SageMakerAsyncClient client, ListEndpointsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListEndpointsPublisher(SageMakerAsyncClient client, ListEndpointsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListEndpointsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListEndpointsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private final ListEndpointsPublisher resume(ListEndpointsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListEndpointsPublisher(this.client, (ListEndpointsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListEndpointsPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super ListEndpointsResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class ListEndpointsResponseFetcher
    implements AsyncPageFetcher<ListEndpointsResponse> {
        private ListEndpointsResponseFetcher() {
        }

        public boolean hasNextPage(ListEndpointsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListEndpointsResponse> nextPage(ListEndpointsResponse previousPage) {
            if (previousPage == null) {
                return ListEndpointsPublisher.this.client.listEndpoints(ListEndpointsPublisher.this.firstRequest);
            }
            return ListEndpointsPublisher.this.client.listEndpoints((ListEndpointsRequest)((Object)ListEndpointsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

