/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.sagemaker.model.ProductionVariantSummary;

@SdkInternalApi
public class ProductionVariantSummaryMarshaller {
    private static final MarshallingInfo<String> VARIANTNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("VariantName").build();
    private static final MarshallingInfo<Float> CURRENTWEIGHT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.FLOAT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CurrentWeight").build();
    private static final MarshallingInfo<Float> DESIREDWEIGHT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.FLOAT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DesiredWeight").build();
    private static final MarshallingInfo<Integer> CURRENTINSTANCECOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CurrentInstanceCount").build();
    private static final MarshallingInfo<Integer> DESIREDINSTANCECOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DesiredInstanceCount").build();
    private static final ProductionVariantSummaryMarshaller INSTANCE = new ProductionVariantSummaryMarshaller();

    public static ProductionVariantSummaryMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ProductionVariantSummary productionVariantSummary, ProtocolMarshaller protocolMarshaller) {
        if (productionVariantSummary == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)productionVariantSummary.variantName(), VARIANTNAME_BINDING);
            protocolMarshaller.marshall((Object)productionVariantSummary.currentWeight(), CURRENTWEIGHT_BINDING);
            protocolMarshaller.marshall((Object)productionVariantSummary.desiredWeight(), DESIREDWEIGHT_BINDING);
            protocolMarshaller.marshall((Object)productionVariantSummary.currentInstanceCount(), CURRENTINSTANCECOUNT_BINDING);
            protocolMarshaller.marshall((Object)productionVariantSummary.desiredInstanceCount(), DESIREDINSTANCECOUNT_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

