/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.sagemaker.model.NotebookInstanceSummary;

@SdkInternalApi
public class NotebookInstanceSummaryMarshaller {
    private static final MarshallingInfo<String> NOTEBOOKINSTANCENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NotebookInstanceName").build();
    private static final MarshallingInfo<String> NOTEBOOKINSTANCEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NotebookInstanceArn").build();
    private static final MarshallingInfo<String> NOTEBOOKINSTANCESTATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NotebookInstanceStatus").build();
    private static final MarshallingInfo<String> URL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Url").build();
    private static final MarshallingInfo<String> INSTANCETYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InstanceType").build();
    private static final MarshallingInfo<Instant> CREATIONTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreationTime").build();
    private static final MarshallingInfo<Instant> LASTMODIFIEDTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastModifiedTime").build();
    private static final NotebookInstanceSummaryMarshaller INSTANCE = new NotebookInstanceSummaryMarshaller();

    public static NotebookInstanceSummaryMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(NotebookInstanceSummary notebookInstanceSummary, ProtocolMarshaller protocolMarshaller) {
        if (notebookInstanceSummary == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)notebookInstanceSummary.notebookInstanceName(), NOTEBOOKINSTANCENAME_BINDING);
            protocolMarshaller.marshall((Object)notebookInstanceSummary.notebookInstanceArn(), NOTEBOOKINSTANCEARN_BINDING);
            protocolMarshaller.marshall((Object)notebookInstanceSummary.notebookInstanceStatusString(), NOTEBOOKINSTANCESTATUS_BINDING);
            protocolMarshaller.marshall((Object)notebookInstanceSummary.url(), URL_BINDING);
            protocolMarshaller.marshall((Object)notebookInstanceSummary.instanceTypeString(), INSTANCETYPE_BINDING);
            protocolMarshaller.marshall((Object)notebookInstanceSummary.creationTime(), CREATIONTIME_BINDING);
            protocolMarshaller.marshall((Object)notebookInstanceSummary.lastModifiedTime(), LASTMODIFIEDTIME_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

