/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.sagemaker.model.DesiredWeightAndCapacity;

@SdkInternalApi
public class DesiredWeightAndCapacityMarshaller {
    private static final MarshallingInfo<String> VARIANTNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("VariantName").build();
    private static final MarshallingInfo<Float> DESIREDWEIGHT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.FLOAT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DesiredWeight").build();
    private static final MarshallingInfo<Integer> DESIREDINSTANCECOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DesiredInstanceCount").build();
    private static final DesiredWeightAndCapacityMarshaller INSTANCE = new DesiredWeightAndCapacityMarshaller();

    public static DesiredWeightAndCapacityMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(DesiredWeightAndCapacity desiredWeightAndCapacity, ProtocolMarshaller protocolMarshaller) {
        if (desiredWeightAndCapacity == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)desiredWeightAndCapacity.variantName(), VARIANTNAME_BINDING);
            protocolMarshaller.marshall((Object)desiredWeightAndCapacity.desiredWeight(), DESIREDWEIGHT_BINDING);
            protocolMarshaller.marshall((Object)desiredWeightAndCapacity.desiredInstanceCount(), DESIREDINSTANCECOUNT_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

