/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.sagemaker.SageMakerClient;
import software.amazon.awssdk.services.sagemaker.model.ListTrainingJobsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListTrainingJobsResponse;

public final class ListTrainingJobsPaginator
implements SdkIterable<ListTrainingJobsResponse> {
    private final SageMakerClient client;
    private final ListTrainingJobsRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public ListTrainingJobsPaginator(SageMakerClient client, ListTrainingJobsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListTrainingJobsResponseFetcher();
    }

    public Iterator<ListTrainingJobsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    private class ListTrainingJobsResponseFetcher
    implements NextPageFetcher<ListTrainingJobsResponse> {
        private ListTrainingJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListTrainingJobsResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public ListTrainingJobsResponse nextPage(ListTrainingJobsResponse previousPage) {
            if (previousPage == null) {
                return ListTrainingJobsPaginator.this.client.listTrainingJobs(ListTrainingJobsPaginator.this.firstRequest);
            }
            return ListTrainingJobsPaginator.this.client.listTrainingJobs((ListTrainingJobsRequest)((Object)ListTrainingJobsPaginator.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

