/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.sagemaker.SageMakerClient;
import software.amazon.awssdk.services.sagemaker.model.ListModelsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListModelsResponse;

public final class ListModelsPaginator
implements SdkIterable<ListModelsResponse> {
    private final SageMakerClient client;
    private final ListModelsRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public ListModelsPaginator(SageMakerClient client, ListModelsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListModelsResponseFetcher();
    }

    public Iterator<ListModelsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    private class ListModelsResponseFetcher
    implements NextPageFetcher<ListModelsResponse> {
        private ListModelsResponseFetcher() {
        }

        public boolean hasNextPage(ListModelsResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public ListModelsResponse nextPage(ListModelsResponse previousPage) {
            if (previousPage == null) {
                return ListModelsPaginator.this.client.listModels(ListModelsPaginator.this.firstRequest);
            }
            return ListModelsPaginator.this.client.listModels((ListModelsRequest)((Object)ListModelsPaginator.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

