/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.sagemaker.SageMakerClient;
import software.amazon.awssdk.services.sagemaker.model.ListEndpointConfigsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListEndpointConfigsResponse;

public final class ListEndpointConfigsPaginator
implements SdkIterable<ListEndpointConfigsResponse> {
    private final SageMakerClient client;
    private final ListEndpointConfigsRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public ListEndpointConfigsPaginator(SageMakerClient client, ListEndpointConfigsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListEndpointConfigsResponseFetcher();
    }

    public Iterator<ListEndpointConfigsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    private class ListEndpointConfigsResponseFetcher
    implements NextPageFetcher<ListEndpointConfigsResponse> {
        private ListEndpointConfigsResponseFetcher() {
        }

        public boolean hasNextPage(ListEndpointConfigsResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public ListEndpointConfigsResponse nextPage(ListEndpointConfigsResponse previousPage) {
            if (previousPage == null) {
                return ListEndpointConfigsPaginator.this.client.listEndpointConfigs(ListEndpointConfigsPaginator.this.firstRequest);
            }
            return ListEndpointConfigsPaginator.this.client.listEndpointConfigs((ListEndpointConfigsRequest)((Object)ListEndpointConfigsPaginator.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

