/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.sagemaker.model.InstanceType;
import software.amazon.awssdk.services.sagemaker.model.NotebookInstanceStatus;
import software.amazon.awssdk.services.sagemaker.model.SageMakerResponse;
import software.amazon.awssdk.services.sagemaker.model.SecurityGroupIdsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeNotebookInstanceResponse
extends SageMakerResponse
implements ToCopyableBuilder<Builder, DescribeNotebookInstanceResponse> {
    private final String notebookInstanceArn;
    private final String notebookInstanceName;
    private final String notebookInstanceStatus;
    private final String failureReason;
    private final String url;
    private final String instanceType;
    private final String subnetId;
    private final List<String> securityGroups;
    private final String roleArn;
    private final String kmsKeyId;
    private final String networkInterfaceId;
    private final Instant lastModifiedTime;
    private final Instant creationTime;

    private DescribeNotebookInstanceResponse(BuilderImpl builder) {
        super(builder);
        this.notebookInstanceArn = builder.notebookInstanceArn;
        this.notebookInstanceName = builder.notebookInstanceName;
        this.notebookInstanceStatus = builder.notebookInstanceStatus;
        this.failureReason = builder.failureReason;
        this.url = builder.url;
        this.instanceType = builder.instanceType;
        this.subnetId = builder.subnetId;
        this.securityGroups = builder.securityGroups;
        this.roleArn = builder.roleArn;
        this.kmsKeyId = builder.kmsKeyId;
        this.networkInterfaceId = builder.networkInterfaceId;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.creationTime = builder.creationTime;
    }

    public String notebookInstanceArn() {
        return this.notebookInstanceArn;
    }

    public String notebookInstanceName() {
        return this.notebookInstanceName;
    }

    public NotebookInstanceStatus notebookInstanceStatus() {
        return NotebookInstanceStatus.fromValue(this.notebookInstanceStatus);
    }

    public String notebookInstanceStatusString() {
        return this.notebookInstanceStatus;
    }

    public String failureReason() {
        return this.failureReason;
    }

    public String url() {
        return this.url;
    }

    public InstanceType instanceType() {
        return InstanceType.fromValue(this.instanceType);
    }

    public String instanceTypeString() {
        return this.instanceType;
    }

    public String subnetId() {
        return this.subnetId;
    }

    public List<String> securityGroups() {
        return this.securityGroups;
    }

    public String roleArn() {
        return this.roleArn;
    }

    public String kmsKeyId() {
        return this.kmsKeyId;
    }

    public String networkInterfaceId() {
        return this.networkInterfaceId;
    }

    public Instant lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public Instant creationTime() {
        return this.creationTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.notebookInstanceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.notebookInstanceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.notebookInstanceStatusString());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.url());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceTypeString());
        hashCode = 31 * hashCode + Objects.hashCode(this.subnetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.securityGroups());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkInterfaceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeNotebookInstanceResponse)) {
            return false;
        }
        DescribeNotebookInstanceResponse other = (DescribeNotebookInstanceResponse)((Object)obj);
        return Objects.equals(this.notebookInstanceArn(), other.notebookInstanceArn()) && Objects.equals(this.notebookInstanceName(), other.notebookInstanceName()) && Objects.equals(this.notebookInstanceStatusString(), other.notebookInstanceStatusString()) && Objects.equals(this.failureReason(), other.failureReason()) && Objects.equals(this.url(), other.url()) && Objects.equals(this.instanceTypeString(), other.instanceTypeString()) && Objects.equals(this.subnetId(), other.subnetId()) && Objects.equals(this.securityGroups(), other.securityGroups()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.kmsKeyId(), other.kmsKeyId()) && Objects.equals(this.networkInterfaceId(), other.networkInterfaceId()) && Objects.equals(this.lastModifiedTime(), other.lastModifiedTime()) && Objects.equals(this.creationTime(), other.creationTime());
    }

    public String toString() {
        return ToString.builder((String)"DescribeNotebookInstanceResponse").add("NotebookInstanceArn", (Object)this.notebookInstanceArn()).add("NotebookInstanceName", (Object)this.notebookInstanceName()).add("NotebookInstanceStatus", (Object)this.notebookInstanceStatusString()).add("FailureReason", (Object)this.failureReason()).add("Url", (Object)this.url()).add("InstanceType", (Object)this.instanceTypeString()).add("SubnetId", (Object)this.subnetId()).add("SecurityGroups", this.securityGroups()).add("RoleArn", (Object)this.roleArn()).add("KmsKeyId", (Object)this.kmsKeyId()).add("NetworkInterfaceId", (Object)this.networkInterfaceId()).add("LastModifiedTime", (Object)this.lastModifiedTime()).add("CreationTime", (Object)this.creationTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NotebookInstanceArn": {
                return Optional.of(clazz.cast(this.notebookInstanceArn()));
            }
            case "NotebookInstanceName": {
                return Optional.of(clazz.cast(this.notebookInstanceName()));
            }
            case "NotebookInstanceStatus": {
                return Optional.of(clazz.cast(this.notebookInstanceStatusString()));
            }
            case "FailureReason": {
                return Optional.of(clazz.cast(this.failureReason()));
            }
            case "Url": {
                return Optional.of(clazz.cast(this.url()));
            }
            case "InstanceType": {
                return Optional.of(clazz.cast(this.instanceTypeString()));
            }
            case "SubnetId": {
                return Optional.of(clazz.cast(this.subnetId()));
            }
            case "SecurityGroups": {
                return Optional.of(clazz.cast(this.securityGroups()));
            }
            case "RoleArn": {
                return Optional.of(clazz.cast(this.roleArn()));
            }
            case "KmsKeyId": {
                return Optional.of(clazz.cast(this.kmsKeyId()));
            }
            case "NetworkInterfaceId": {
                return Optional.of(clazz.cast(this.networkInterfaceId()));
            }
            case "LastModifiedTime": {
                return Optional.of(clazz.cast(this.lastModifiedTime()));
            }
            case "CreationTime": {
                return Optional.of(clazz.cast(this.creationTime()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends SageMakerResponse.BuilderImpl
    implements Builder {
        private String notebookInstanceArn;
        private String notebookInstanceName;
        private String notebookInstanceStatus;
        private String failureReason;
        private String url;
        private String instanceType;
        private String subnetId;
        private List<String> securityGroups;
        private String roleArn;
        private String kmsKeyId;
        private String networkInterfaceId;
        private Instant lastModifiedTime;
        private Instant creationTime;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeNotebookInstanceResponse model) {
            this.notebookInstanceArn(model.notebookInstanceArn);
            this.notebookInstanceName(model.notebookInstanceName);
            this.notebookInstanceStatus(model.notebookInstanceStatus);
            this.failureReason(model.failureReason);
            this.url(model.url);
            this.instanceType(model.instanceType);
            this.subnetId(model.subnetId);
            this.securityGroups(model.securityGroups);
            this.roleArn(model.roleArn);
            this.kmsKeyId(model.kmsKeyId);
            this.networkInterfaceId(model.networkInterfaceId);
            this.lastModifiedTime(model.lastModifiedTime);
            this.creationTime(model.creationTime);
        }

        public final String getNotebookInstanceArn() {
            return this.notebookInstanceArn;
        }

        @Override
        public final Builder notebookInstanceArn(String notebookInstanceArn) {
            this.notebookInstanceArn = notebookInstanceArn;
            return this;
        }

        public final void setNotebookInstanceArn(String notebookInstanceArn) {
            this.notebookInstanceArn = notebookInstanceArn;
        }

        public final String getNotebookInstanceName() {
            return this.notebookInstanceName;
        }

        @Override
        public final Builder notebookInstanceName(String notebookInstanceName) {
            this.notebookInstanceName = notebookInstanceName;
            return this;
        }

        public final void setNotebookInstanceName(String notebookInstanceName) {
            this.notebookInstanceName = notebookInstanceName;
        }

        public final String getNotebookInstanceStatus() {
            return this.notebookInstanceStatus;
        }

        @Override
        public final Builder notebookInstanceStatus(String notebookInstanceStatus) {
            this.notebookInstanceStatus = notebookInstanceStatus;
            return this;
        }

        @Override
        public final Builder notebookInstanceStatus(NotebookInstanceStatus notebookInstanceStatus) {
            this.notebookInstanceStatus(notebookInstanceStatus.toString());
            return this;
        }

        public final void setNotebookInstanceStatus(String notebookInstanceStatus) {
            this.notebookInstanceStatus = notebookInstanceStatus;
        }

        public final String getFailureReason() {
            return this.failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        public final String getUrl() {
            return this.url;
        }

        @Override
        public final Builder url(String url) {
            this.url = url;
            return this;
        }

        public final void setUrl(String url) {
            this.url = url;
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        @Override
        public final Builder instanceType(InstanceType instanceType) {
            this.instanceType(instanceType.toString());
            return this;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        public final String getSubnetId() {
            return this.subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        public final Collection<String> getSecurityGroups() {
            return this.securityGroups;
        }

        @Override
        public final Builder securityGroups(Collection<String> securityGroups) {
            this.securityGroups = SecurityGroupIdsCopier.copy(securityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroups(String ... securityGroups) {
            this.securityGroups(Arrays.asList(securityGroups));
            return this;
        }

        public final void setSecurityGroups(Collection<String> securityGroups) {
            this.securityGroups = SecurityGroupIdsCopier.copy(securityGroups);
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        public final String getNetworkInterfaceId() {
            return this.networkInterfaceId;
        }

        @Override
        public final Builder networkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
            return this;
        }

        public final void setNetworkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
        }

        public final Instant getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public DescribeNotebookInstanceResponse build() {
            return new DescribeNotebookInstanceResponse(this);
        }
    }

    public static interface Builder
    extends SageMakerResponse.Builder,
    CopyableBuilder<Builder, DescribeNotebookInstanceResponse> {
        public Builder notebookInstanceArn(String var1);

        public Builder notebookInstanceName(String var1);

        public Builder notebookInstanceStatus(String var1);

        public Builder notebookInstanceStatus(NotebookInstanceStatus var1);

        public Builder failureReason(String var1);

        public Builder url(String var1);

        public Builder instanceType(String var1);

        public Builder instanceType(InstanceType var1);

        public Builder subnetId(String var1);

        public Builder securityGroups(Collection<String> var1);

        public Builder securityGroups(String ... var1);

        public Builder roleArn(String var1);

        public Builder kmsKeyId(String var1);

        public Builder networkInterfaceId(String var1);

        public Builder lastModifiedTime(Instant var1);

        public Builder creationTime(Instant var1);
    }
}

