/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.services.sagemaker.model.ContainerDefinition;
import software.amazon.awssdk.services.sagemaker.model.SageMakerResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeModelResponse
extends SageMakerResponse
implements ToCopyableBuilder<Builder, DescribeModelResponse> {
    private final String modelName;
    private final ContainerDefinition primaryContainer;
    private final String executionRoleArn;
    private final Instant creationTime;
    private final String modelArn;

    private DescribeModelResponse(BuilderImpl builder) {
        super(builder);
        this.modelName = builder.modelName;
        this.primaryContainer = builder.primaryContainer;
        this.executionRoleArn = builder.executionRoleArn;
        this.creationTime = builder.creationTime;
        this.modelArn = builder.modelArn;
    }

    public String modelName() {
        return this.modelName;
    }

    public ContainerDefinition primaryContainer() {
        return this.primaryContainer;
    }

    public String executionRoleArn() {
        return this.executionRoleArn;
    }

    public Instant creationTime() {
        return this.creationTime;
    }

    public String modelArn() {
        return this.modelArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.modelName());
        hashCode = 31 * hashCode + Objects.hashCode(this.primaryContainer());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelArn());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeModelResponse)) {
            return false;
        }
        DescribeModelResponse other = (DescribeModelResponse)((Object)obj);
        return Objects.equals(this.modelName(), other.modelName()) && Objects.equals(this.primaryContainer(), other.primaryContainer()) && Objects.equals(this.executionRoleArn(), other.executionRoleArn()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.modelArn(), other.modelArn());
    }

    public String toString() {
        return ToString.builder((String)"DescribeModelResponse").add("ModelName", (Object)this.modelName()).add("PrimaryContainer", (Object)this.primaryContainer()).add("ExecutionRoleArn", (Object)this.executionRoleArn()).add("CreationTime", (Object)this.creationTime()).add("ModelArn", (Object)this.modelArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ModelName": {
                return Optional.of(clazz.cast(this.modelName()));
            }
            case "PrimaryContainer": {
                return Optional.of(clazz.cast(this.primaryContainer()));
            }
            case "ExecutionRoleArn": {
                return Optional.of(clazz.cast(this.executionRoleArn()));
            }
            case "CreationTime": {
                return Optional.of(clazz.cast(this.creationTime()));
            }
            case "ModelArn": {
                return Optional.of(clazz.cast(this.modelArn()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends SageMakerResponse.BuilderImpl
    implements Builder {
        private String modelName;
        private ContainerDefinition primaryContainer;
        private String executionRoleArn;
        private Instant creationTime;
        private String modelArn;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeModelResponse model) {
            this.modelName(model.modelName);
            this.primaryContainer(model.primaryContainer);
            this.executionRoleArn(model.executionRoleArn);
            this.creationTime(model.creationTime);
            this.modelArn(model.modelArn);
        }

        public final String getModelName() {
            return this.modelName;
        }

        @Override
        public final Builder modelName(String modelName) {
            this.modelName = modelName;
            return this;
        }

        public final void setModelName(String modelName) {
            this.modelName = modelName;
        }

        public final ContainerDefinition.Builder getPrimaryContainer() {
            return this.primaryContainer != null ? this.primaryContainer.toBuilder() : null;
        }

        @Override
        public final Builder primaryContainer(ContainerDefinition primaryContainer) {
            this.primaryContainer = primaryContainer;
            return this;
        }

        public final void setPrimaryContainer(ContainerDefinition.BuilderImpl primaryContainer) {
            this.primaryContainer = primaryContainer != null ? primaryContainer.build() : null;
        }

        public final String getExecutionRoleArn() {
            return this.executionRoleArn;
        }

        @Override
        public final Builder executionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
            return this;
        }

        public final void setExecutionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final String getModelArn() {
            return this.modelArn;
        }

        @Override
        public final Builder modelArn(String modelArn) {
            this.modelArn = modelArn;
            return this;
        }

        public final void setModelArn(String modelArn) {
            this.modelArn = modelArn;
        }

        @Override
        public DescribeModelResponse build() {
            return new DescribeModelResponse(this);
        }
    }

    public static interface Builder
    extends SageMakerResponse.Builder,
    CopyableBuilder<Builder, DescribeModelResponse> {
        public Builder modelName(String var1);

        public Builder primaryContainer(ContainerDefinition var1);

        default public Builder primaryContainer(Consumer<ContainerDefinition.Builder> primaryContainer) {
            return this.primaryContainer((ContainerDefinition)((ContainerDefinition.Builder)ContainerDefinition.builder().apply(primaryContainer)).build());
        }

        public Builder executionRoleArn(String var1);

        public Builder creationTime(Instant var1);

        public Builder modelArn(String var1);
    }
}

