/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.sagemaker.model.ProductionVariant;
import software.amazon.awssdk.services.sagemaker.model.ProductionVariantListCopier;
import software.amazon.awssdk.services.sagemaker.model.SageMakerRequest;
import software.amazon.awssdk.services.sagemaker.model.Tag;
import software.amazon.awssdk.services.sagemaker.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateEndpointConfigRequest
extends SageMakerRequest
implements ToCopyableBuilder<Builder, CreateEndpointConfigRequest> {
    private final String endpointConfigName;
    private final List<ProductionVariant> productionVariants;
    private final List<Tag> tags;

    private CreateEndpointConfigRequest(BuilderImpl builder) {
        super(builder);
        this.endpointConfigName = builder.endpointConfigName;
        this.productionVariants = builder.productionVariants;
        this.tags = builder.tags;
    }

    public String endpointConfigName() {
        return this.endpointConfigName;
    }

    public List<ProductionVariant> productionVariants() {
        return this.productionVariants;
    }

    public List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointConfigName());
        hashCode = 31 * hashCode + Objects.hashCode(this.productionVariants());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateEndpointConfigRequest)) {
            return false;
        }
        CreateEndpointConfigRequest other = (CreateEndpointConfigRequest)((Object)obj);
        return Objects.equals(this.endpointConfigName(), other.endpointConfigName()) && Objects.equals(this.productionVariants(), other.productionVariants()) && Objects.equals(this.tags(), other.tags());
    }

    public String toString() {
        return ToString.builder((String)"CreateEndpointConfigRequest").add("EndpointConfigName", (Object)this.endpointConfigName()).add("ProductionVariants", this.productionVariants()).add("Tags", this.tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EndpointConfigName": {
                return Optional.of(clazz.cast(this.endpointConfigName()));
            }
            case "ProductionVariants": {
                return Optional.of(clazz.cast(this.productionVariants()));
            }
            case "Tags": {
                return Optional.of(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends SageMakerRequest.BuilderImpl
    implements Builder {
        private String endpointConfigName;
        private List<ProductionVariant> productionVariants;
        private List<Tag> tags;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateEndpointConfigRequest model) {
            this.endpointConfigName(model.endpointConfigName);
            this.productionVariants(model.productionVariants);
            this.tags(model.tags);
        }

        public final String getEndpointConfigName() {
            return this.endpointConfigName;
        }

        @Override
        public final Builder endpointConfigName(String endpointConfigName) {
            this.endpointConfigName = endpointConfigName;
            return this;
        }

        public final void setEndpointConfigName(String endpointConfigName) {
            this.endpointConfigName = endpointConfigName;
        }

        public final Collection<ProductionVariant.Builder> getProductionVariants() {
            return this.productionVariants != null ? (Collection)this.productionVariants.stream().map(ProductionVariant::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder productionVariants(Collection<ProductionVariant> productionVariants) {
            this.productionVariants = ProductionVariantListCopier.copy(productionVariants);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder productionVariants(ProductionVariant ... productionVariants) {
            this.productionVariants(Arrays.asList(productionVariants));
            return this;
        }

        public final void setProductionVariants(Collection<ProductionVariant.BuilderImpl> productionVariants) {
            this.productionVariants = ProductionVariantListCopier.copyFromBuilder(productionVariants);
        }

        public final Collection<Tag.Builder> getTags() {
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public CreateEndpointConfigRequest build() {
            return new CreateEndpointConfigRequest(this);
        }
    }

    public static interface Builder
    extends SageMakerRequest.Builder,
    CopyableBuilder<Builder, CreateEndpointConfigRequest> {
        public Builder endpointConfigName(String var1);

        public Builder productionVariants(Collection<ProductionVariant> var1);

        public Builder productionVariants(ProductionVariant ... var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

