/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.sagemaker.model.VpcConfig;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class VpcConfigMarshaller {
    private static final MarshallingInfo<List> SECURITYGROUPIDS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SecurityGroupIds").isBinary(false).build();
    private static final MarshallingInfo<List> SUBNETS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Subnets").isBinary(false).build();
    private static final VpcConfigMarshaller INSTANCE = new VpcConfigMarshaller();

    private VpcConfigMarshaller() {
    }

    public static VpcConfigMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(VpcConfig vpcConfig, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)vpcConfig, (String)"vpcConfig");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall(vpcConfig.securityGroupIds(), SECURITYGROUPIDS_BINDING);
            protocolMarshaller.marshall(vpcConfig.subnets(), SUBNETS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

