/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.sagemaker.model.TransformOutput;

public class TransformOutputUnmarshaller
implements Unmarshaller<TransformOutput, JsonUnmarshallerContext> {
    private static final TransformOutputUnmarshaller INSTANCE = new TransformOutputUnmarshaller();

    public TransformOutput unmarshall(JsonUnmarshallerContext context) throws Exception {
        TransformOutput.Builder transformOutputBuilder = TransformOutput.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("S3OutputPath", targetDepth)) {
                    context.nextToken();
                    transformOutputBuilder.s3OutputPath((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Accept", targetDepth)) {
                    context.nextToken();
                    transformOutputBuilder.accept((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("AssembleWith", targetDepth)) {
                    context.nextToken();
                    transformOutputBuilder.assembleWith((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("KmsKeyId", targetDepth)) {
                    context.nextToken();
                    transformOutputBuilder.kmsKeyId((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (TransformOutput)transformOutputBuilder.build();
    }

    public static TransformOutputUnmarshaller getInstance() {
        return INSTANCE;
    }
}

