/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.sagemaker.model.TransformOutput;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class TransformOutputMarshaller {
    private static final MarshallingInfo<String> S3OUTPUTPATH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("S3OutputPath").isBinary(false).build();
    private static final MarshallingInfo<String> ACCEPT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Accept").isBinary(false).build();
    private static final MarshallingInfo<String> ASSEMBLEWITH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AssembleWith").isBinary(false).build();
    private static final MarshallingInfo<String> KMSKEYID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("KmsKeyId").isBinary(false).build();
    private static final TransformOutputMarshaller INSTANCE = new TransformOutputMarshaller();

    private TransformOutputMarshaller() {
    }

    public static TransformOutputMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(TransformOutput transformOutput, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)transformOutput, (String)"transformOutput");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)transformOutput.s3OutputPath(), S3OUTPUTPATH_BINDING);
            protocolMarshaller.marshall((Object)transformOutput.accept(), ACCEPT_BINDING);
            protocolMarshaller.marshall((Object)transformOutput.assembleWithAsString(), ASSEMBLEWITH_BINDING);
            protocolMarshaller.marshall((Object)transformOutput.kmsKeyId(), KMSKEYID_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

