/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.sagemaker.model.TransformInput;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class TransformInputMarshaller {
    private static final MarshallingInfo<StructuredPojo> DATASOURCE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DataSource").isBinary(false).build();
    private static final MarshallingInfo<String> CONTENTTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ContentType").isBinary(false).build();
    private static final MarshallingInfo<String> COMPRESSIONTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CompressionType").isBinary(false).build();
    private static final MarshallingInfo<String> SPLITTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SplitType").isBinary(false).build();
    private static final TransformInputMarshaller INSTANCE = new TransformInputMarshaller();

    private TransformInputMarshaller() {
    }

    public static TransformInputMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(TransformInput transformInput, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)transformInput, (String)"transformInput");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)transformInput.dataSource(), DATASOURCE_BINDING);
            protocolMarshaller.marshall((Object)transformInput.contentType(), CONTENTTYPE_BINDING);
            protocolMarshaller.marshall((Object)transformInput.compressionTypeAsString(), COMPRESSIONTYPE_BINDING);
            protocolMarshaller.marshall((Object)transformInput.splitTypeAsString(), SPLITTYPE_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

