/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.sagemaker.model.TransformDataSource;
import software.amazon.awssdk.services.sagemaker.transform.TransformS3DataSourceUnmarshaller;

public class TransformDataSourceUnmarshaller
implements Unmarshaller<TransformDataSource, JsonUnmarshallerContext> {
    private static final TransformDataSourceUnmarshaller INSTANCE = new TransformDataSourceUnmarshaller();

    public TransformDataSource unmarshall(JsonUnmarshallerContext context) throws Exception {
        TransformDataSource.Builder transformDataSourceBuilder = TransformDataSource.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("S3DataSource", targetDepth)) {
                    context.nextToken();
                    transformDataSourceBuilder.s3DataSource(TransformS3DataSourceUnmarshaller.getInstance().unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (TransformDataSource)transformDataSourceBuilder.build();
    }

    public static TransformDataSourceUnmarshaller getInstance() {
        return INSTANCE;
    }
}

