/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.sagemaker.model.TrainingJobStatusCounters;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class TrainingJobStatusCountersMarshaller {
    private static final MarshallingInfo<Integer> COMPLETED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Completed").isBinary(false).build();
    private static final MarshallingInfo<Integer> INPROGRESS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InProgress").isBinary(false).build();
    private static final MarshallingInfo<Integer> RETRYABLEERROR_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RetryableError").isBinary(false).build();
    private static final MarshallingInfo<Integer> NONRETRYABLEERROR_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NonRetryableError").isBinary(false).build();
    private static final MarshallingInfo<Integer> STOPPED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Stopped").isBinary(false).build();
    private static final TrainingJobStatusCountersMarshaller INSTANCE = new TrainingJobStatusCountersMarshaller();

    private TrainingJobStatusCountersMarshaller() {
    }

    public static TrainingJobStatusCountersMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(TrainingJobStatusCounters trainingJobStatusCounters, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)trainingJobStatusCounters, (String)"trainingJobStatusCounters");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)trainingJobStatusCounters.completed(), COMPLETED_BINDING);
            protocolMarshaller.marshall((Object)trainingJobStatusCounters.inProgress(), INPROGRESS_BINDING);
            protocolMarshaller.marshall((Object)trainingJobStatusCounters.retryableError(), RETRYABLEERROR_BINDING);
            protocolMarshaller.marshall((Object)trainingJobStatusCounters.nonRetryableError(), NONRETRYABLEERROR_BINDING);
            protocolMarshaller.marshall((Object)trainingJobStatusCounters.stopped(), STOPPED_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

