/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.sagemaker.model.ResourceLimits;

public class ResourceLimitsUnmarshaller
implements Unmarshaller<ResourceLimits, JsonUnmarshallerContext> {
    private static final ResourceLimitsUnmarshaller INSTANCE = new ResourceLimitsUnmarshaller();

    public ResourceLimits unmarshall(JsonUnmarshallerContext context) throws Exception {
        ResourceLimits.Builder resourceLimitsBuilder = ResourceLimits.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("MaxNumberOfTrainingJobs", targetDepth)) {
                    context.nextToken();
                    resourceLimitsBuilder.maxNumberOfTrainingJobs((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("MaxParallelTrainingJobs", targetDepth)) {
                    context.nextToken();
                    resourceLimitsBuilder.maxParallelTrainingJobs((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (ResourceLimits)resourceLimitsBuilder.build();
    }

    public static ResourceLimitsUnmarshaller getInstance() {
        return INSTANCE;
    }
}

