/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.sagemaker.model.ResourceLimits;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ResourceLimitsMarshaller {
    private static final MarshallingInfo<Integer> MAXNUMBEROFTRAININGJOBS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MaxNumberOfTrainingJobs").isBinary(false).build();
    private static final MarshallingInfo<Integer> MAXPARALLELTRAININGJOBS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MaxParallelTrainingJobs").isBinary(false).build();
    private static final ResourceLimitsMarshaller INSTANCE = new ResourceLimitsMarshaller();

    private ResourceLimitsMarshaller() {
    }

    public static ResourceLimitsMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ResourceLimits resourceLimits, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)resourceLimits, (String)"resourceLimits");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)resourceLimits.maxNumberOfTrainingJobs(), MAXNUMBEROFTRAININGJOBS_BINDING);
            protocolMarshaller.marshall((Object)resourceLimits.maxParallelTrainingJobs(), MAXPARALLELTRAININGJOBS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

