/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.sagemaker.model.ProductionVariant;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ProductionVariantMarshaller {
    private static final MarshallingInfo<String> VARIANTNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("VariantName").isBinary(false).build();
    private static final MarshallingInfo<String> MODELNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ModelName").isBinary(false).build();
    private static final MarshallingInfo<Integer> INITIALINSTANCECOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InitialInstanceCount").isBinary(false).build();
    private static final MarshallingInfo<String> INSTANCETYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InstanceType").isBinary(false).build();
    private static final MarshallingInfo<Float> INITIALVARIANTWEIGHT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.FLOAT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InitialVariantWeight").isBinary(false).build();
    private static final ProductionVariantMarshaller INSTANCE = new ProductionVariantMarshaller();

    private ProductionVariantMarshaller() {
    }

    public static ProductionVariantMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ProductionVariant productionVariant, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)productionVariant, (String)"productionVariant");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)productionVariant.variantName(), VARIANTNAME_BINDING);
            protocolMarshaller.marshall((Object)productionVariant.modelName(), MODELNAME_BINDING);
            protocolMarshaller.marshall((Object)productionVariant.initialInstanceCount(), INITIALINSTANCECOUNT_BINDING);
            protocolMarshaller.marshall((Object)productionVariant.instanceTypeAsString(), INSTANCETYPE_BINDING);
            protocolMarshaller.marshall((Object)productionVariant.initialVariantWeight(), INITIALVARIANTWEIGHT_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

