/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.sagemaker.model.HyperParameterTuningJobConfig;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class HyperParameterTuningJobConfigMarshaller {
    private static final MarshallingInfo<String> STRATEGY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Strategy").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> HYPERPARAMETERTUNINGJOBOBJECTIVE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("HyperParameterTuningJobObjective").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> RESOURCELIMITS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ResourceLimits").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> PARAMETERRANGES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ParameterRanges").isBinary(false).build();
    private static final HyperParameterTuningJobConfigMarshaller INSTANCE = new HyperParameterTuningJobConfigMarshaller();

    private HyperParameterTuningJobConfigMarshaller() {
    }

    public static HyperParameterTuningJobConfigMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(HyperParameterTuningJobConfig hyperParameterTuningJobConfig, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)hyperParameterTuningJobConfig, (String)"hyperParameterTuningJobConfig");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)hyperParameterTuningJobConfig.strategyAsString(), STRATEGY_BINDING);
            protocolMarshaller.marshall((Object)hyperParameterTuningJobConfig.hyperParameterTuningJobObjective(), HYPERPARAMETERTUNINGJOBOBJECTIVE_BINDING);
            protocolMarshaller.marshall((Object)hyperParameterTuningJobConfig.resourceLimits(), RESOURCELIMITS_BINDING);
            protocolMarshaller.marshall((Object)hyperParameterTuningJobConfig.parameterRanges(), PARAMETERRANGES_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

