/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.transform;

import java.time.Instant;
import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.sagemaker.model.HyperParameterTrainingJobSummary;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class HyperParameterTrainingJobSummaryMarshaller {
    private static final MarshallingInfo<String> TRAININGJOBNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TrainingJobName").isBinary(false).build();
    private static final MarshallingInfo<String> TRAININGJOBARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TrainingJobArn").isBinary(false).build();
    private static final MarshallingInfo<Instant> CREATIONTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreationTime").isBinary(false).build();
    private static final MarshallingInfo<Instant> TRAININGSTARTTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TrainingStartTime").isBinary(false).build();
    private static final MarshallingInfo<Instant> TRAININGENDTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TrainingEndTime").isBinary(false).build();
    private static final MarshallingInfo<String> TRAININGJOBSTATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TrainingJobStatus").isBinary(false).build();
    private static final MarshallingInfo<Map> TUNEDHYPERPARAMETERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TunedHyperParameters").isBinary(false).build();
    private static final MarshallingInfo<String> FAILUREREASON_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FailureReason").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> FINALHYPERPARAMETERTUNINGJOBOBJECTIVEMETRIC_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FinalHyperParameterTuningJobObjectiveMetric").isBinary(false).build();
    private static final MarshallingInfo<String> OBJECTIVESTATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ObjectiveStatus").isBinary(false).build();
    private static final HyperParameterTrainingJobSummaryMarshaller INSTANCE = new HyperParameterTrainingJobSummaryMarshaller();

    private HyperParameterTrainingJobSummaryMarshaller() {
    }

    public static HyperParameterTrainingJobSummaryMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(HyperParameterTrainingJobSummary hyperParameterTrainingJobSummary, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)hyperParameterTrainingJobSummary, (String)"hyperParameterTrainingJobSummary");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)hyperParameterTrainingJobSummary.trainingJobName(), TRAININGJOBNAME_BINDING);
            protocolMarshaller.marshall((Object)hyperParameterTrainingJobSummary.trainingJobArn(), TRAININGJOBARN_BINDING);
            protocolMarshaller.marshall((Object)hyperParameterTrainingJobSummary.creationTime(), CREATIONTIME_BINDING);
            protocolMarshaller.marshall((Object)hyperParameterTrainingJobSummary.trainingStartTime(), TRAININGSTARTTIME_BINDING);
            protocolMarshaller.marshall((Object)hyperParameterTrainingJobSummary.trainingEndTime(), TRAININGENDTIME_BINDING);
            protocolMarshaller.marshall((Object)hyperParameterTrainingJobSummary.trainingJobStatusAsString(), TRAININGJOBSTATUS_BINDING);
            protocolMarshaller.marshall(hyperParameterTrainingJobSummary.tunedHyperParameters(), TUNEDHYPERPARAMETERS_BINDING);
            protocolMarshaller.marshall((Object)hyperParameterTrainingJobSummary.failureReason(), FAILUREREASON_BINDING);
            protocolMarshaller.marshall((Object)hyperParameterTrainingJobSummary.finalHyperParameterTuningJobObjectiveMetric(), FINALHYPERPARAMETERTUNINGJOBOBJECTIVEMETRIC_BINDING);
            protocolMarshaller.marshall((Object)hyperParameterTrainingJobSummary.objectiveStatusAsString(), OBJECTIVESTATUS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

