/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.transform;

import java.util.List;
import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.sagemaker.model.CreateTransformJobRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class CreateTransformJobRequestModelMarshaller {
    private static final MarshallingInfo<String> TRANSFORMJOBNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TransformJobName").isBinary(false).build();
    private static final MarshallingInfo<String> MODELNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ModelName").isBinary(false).build();
    private static final MarshallingInfo<Integer> MAXCONCURRENTTRANSFORMS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MaxConcurrentTransforms").isBinary(false).build();
    private static final MarshallingInfo<Integer> MAXPAYLOADINMB_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MaxPayloadInMB").isBinary(false).build();
    private static final MarshallingInfo<String> BATCHSTRATEGY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BatchStrategy").isBinary(false).build();
    private static final MarshallingInfo<Map> ENVIRONMENT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Environment").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> TRANSFORMINPUT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TransformInput").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> TRANSFORMOUTPUT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TransformOutput").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> TRANSFORMRESOURCES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TransformResources").isBinary(false).build();
    private static final MarshallingInfo<List> TAGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Tags").isBinary(false).build();
    private static final CreateTransformJobRequestModelMarshaller INSTANCE = new CreateTransformJobRequestModelMarshaller();

    private CreateTransformJobRequestModelMarshaller() {
    }

    public static CreateTransformJobRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CreateTransformJobRequest createTransformJobRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)createTransformJobRequest), (String)"createTransformJobRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)createTransformJobRequest.transformJobName(), TRANSFORMJOBNAME_BINDING);
            protocolMarshaller.marshall((Object)createTransformJobRequest.modelName(), MODELNAME_BINDING);
            protocolMarshaller.marshall((Object)createTransformJobRequest.maxConcurrentTransforms(), MAXCONCURRENTTRANSFORMS_BINDING);
            protocolMarshaller.marshall((Object)createTransformJobRequest.maxPayloadInMB(), MAXPAYLOADINMB_BINDING);
            protocolMarshaller.marshall((Object)createTransformJobRequest.batchStrategyAsString(), BATCHSTRATEGY_BINDING);
            protocolMarshaller.marshall(createTransformJobRequest.environment(), ENVIRONMENT_BINDING);
            protocolMarshaller.marshall((Object)createTransformJobRequest.transformInput(), TRANSFORMINPUT_BINDING);
            protocolMarshaller.marshall((Object)createTransformJobRequest.transformOutput(), TRANSFORMOUTPUT_BINDING);
            protocolMarshaller.marshall((Object)createTransformJobRequest.transformResources(), TRANSFORMRESOURCES_BINDING);
            protocolMarshaller.marshall(createTransformJobRequest.tags(), TAGS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

