/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.sagemaker.model.ContinuousParameterRange;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ContinuousParameterRangeMarshaller {
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").isBinary(false).build();
    private static final MarshallingInfo<String> MINVALUE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MinValue").isBinary(false).build();
    private static final MarshallingInfo<String> MAXVALUE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MaxValue").isBinary(false).build();
    private static final ContinuousParameterRangeMarshaller INSTANCE = new ContinuousParameterRangeMarshaller();

    private ContinuousParameterRangeMarshaller() {
    }

    public static ContinuousParameterRangeMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ContinuousParameterRange continuousParameterRange, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)continuousParameterRange, (String)"continuousParameterRange");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)continuousParameterRange.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)continuousParameterRange.minValue(), MINVALUE_BINDING);
            protocolMarshaller.marshall((Object)continuousParameterRange.maxValue(), MAXVALUE_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

