/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.paginators;

import java.util.Collections;
import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sagemaker.SageMakerClient;
import software.amazon.awssdk.services.sagemaker.model.ListTransformJobsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListTransformJobsResponse;

public class ListTransformJobsIterable
implements SdkIterable<ListTransformJobsResponse> {
    private final SageMakerClient client;
    private final ListTransformJobsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListTransformJobsIterable(SageMakerClient client, ListTransformJobsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListTransformJobsResponseFetcher();
    }

    public Iterator<ListTransformJobsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private final ListTransformJobsIterable resume(ListTransformJobsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListTransformJobsIterable(this.client, (ListTransformJobsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListTransformJobsIterable(this.client, this.firstRequest){

            @Override
            public Iterator<ListTransformJobsResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class ListTransformJobsResponseFetcher
    implements SyncPageFetcher<ListTransformJobsResponse> {
        private ListTransformJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListTransformJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListTransformJobsResponse nextPage(ListTransformJobsResponse previousPage) {
            if (previousPage == null) {
                return ListTransformJobsIterable.this.client.listTransformJobs(ListTransformJobsIterable.this.firstRequest);
            }
            return ListTransformJobsIterable.this.client.listTransformJobs((ListTransformJobsRequest)((Object)ListTransformJobsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

