/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.NotebookInstanceLifecycleConfigListCopier;
import software.amazon.awssdk.services.sagemaker.model.NotebookInstanceLifecycleHook;
import software.amazon.awssdk.services.sagemaker.model.SageMakerRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateNotebookInstanceLifecycleConfigRequest
extends SageMakerRequest
implements ToCopyableBuilder<Builder, UpdateNotebookInstanceLifecycleConfigRequest> {
    private final String notebookInstanceLifecycleConfigName;
    private final List<NotebookInstanceLifecycleHook> onCreate;
    private final List<NotebookInstanceLifecycleHook> onStart;

    private UpdateNotebookInstanceLifecycleConfigRequest(BuilderImpl builder) {
        super(builder);
        this.notebookInstanceLifecycleConfigName = builder.notebookInstanceLifecycleConfigName;
        this.onCreate = builder.onCreate;
        this.onStart = builder.onStart;
    }

    public String notebookInstanceLifecycleConfigName() {
        return this.notebookInstanceLifecycleConfigName;
    }

    public List<NotebookInstanceLifecycleHook> onCreate() {
        return this.onCreate;
    }

    public List<NotebookInstanceLifecycleHook> onStart() {
        return this.onStart;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.notebookInstanceLifecycleConfigName());
        hashCode = 31 * hashCode + Objects.hashCode(this.onCreate());
        hashCode = 31 * hashCode + Objects.hashCode(this.onStart());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateNotebookInstanceLifecycleConfigRequest)) {
            return false;
        }
        UpdateNotebookInstanceLifecycleConfigRequest other = (UpdateNotebookInstanceLifecycleConfigRequest)((Object)obj);
        return Objects.equals(this.notebookInstanceLifecycleConfigName(), other.notebookInstanceLifecycleConfigName()) && Objects.equals(this.onCreate(), other.onCreate()) && Objects.equals(this.onStart(), other.onStart());
    }

    public String toString() {
        return ToString.builder((String)"UpdateNotebookInstanceLifecycleConfigRequest").add("NotebookInstanceLifecycleConfigName", (Object)this.notebookInstanceLifecycleConfigName()).add("OnCreate", this.onCreate()).add("OnStart", this.onStart()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NotebookInstanceLifecycleConfigName": {
                return Optional.ofNullable(clazz.cast(this.notebookInstanceLifecycleConfigName()));
            }
            case "OnCreate": {
                return Optional.ofNullable(clazz.cast(this.onCreate()));
            }
            case "OnStart": {
                return Optional.ofNullable(clazz.cast(this.onStart()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends SageMakerRequest.BuilderImpl
    implements Builder {
        private String notebookInstanceLifecycleConfigName;
        private List<NotebookInstanceLifecycleHook> onCreate = DefaultSdkAutoConstructList.getInstance();
        private List<NotebookInstanceLifecycleHook> onStart = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateNotebookInstanceLifecycleConfigRequest model) {
            super(model);
            this.notebookInstanceLifecycleConfigName(model.notebookInstanceLifecycleConfigName);
            this.onCreate(model.onCreate);
            this.onStart(model.onStart);
        }

        public final String getNotebookInstanceLifecycleConfigName() {
            return this.notebookInstanceLifecycleConfigName;
        }

        @Override
        public final Builder notebookInstanceLifecycleConfigName(String notebookInstanceLifecycleConfigName) {
            this.notebookInstanceLifecycleConfigName = notebookInstanceLifecycleConfigName;
            return this;
        }

        public final void setNotebookInstanceLifecycleConfigName(String notebookInstanceLifecycleConfigName) {
            this.notebookInstanceLifecycleConfigName = notebookInstanceLifecycleConfigName;
        }

        public final Collection<NotebookInstanceLifecycleHook.Builder> getOnCreate() {
            return this.onCreate != null ? (Collection)this.onCreate.stream().map(NotebookInstanceLifecycleHook::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder onCreate(Collection<NotebookInstanceLifecycleHook> onCreate) {
            this.onCreate = NotebookInstanceLifecycleConfigListCopier.copy(onCreate);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder onCreate(NotebookInstanceLifecycleHook ... onCreate) {
            this.onCreate(Arrays.asList(onCreate));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder onCreate(Consumer<NotebookInstanceLifecycleHook.Builder> ... onCreate) {
            this.onCreate(Stream.of(onCreate).map(c -> (NotebookInstanceLifecycleHook)((NotebookInstanceLifecycleHook.Builder)NotebookInstanceLifecycleHook.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setOnCreate(Collection<NotebookInstanceLifecycleHook.BuilderImpl> onCreate) {
            this.onCreate = NotebookInstanceLifecycleConfigListCopier.copyFromBuilder(onCreate);
        }

        public final Collection<NotebookInstanceLifecycleHook.Builder> getOnStart() {
            return this.onStart != null ? (Collection)this.onStart.stream().map(NotebookInstanceLifecycleHook::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder onStart(Collection<NotebookInstanceLifecycleHook> onStart) {
            this.onStart = NotebookInstanceLifecycleConfigListCopier.copy(onStart);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder onStart(NotebookInstanceLifecycleHook ... onStart) {
            this.onStart(Arrays.asList(onStart));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder onStart(Consumer<NotebookInstanceLifecycleHook.Builder> ... onStart) {
            this.onStart(Stream.of(onStart).map(c -> (NotebookInstanceLifecycleHook)((NotebookInstanceLifecycleHook.Builder)NotebookInstanceLifecycleHook.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setOnStart(Collection<NotebookInstanceLifecycleHook.BuilderImpl> onStart) {
            this.onStart = NotebookInstanceLifecycleConfigListCopier.copyFromBuilder(onStart);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateNotebookInstanceLifecycleConfigRequest build() {
            return new UpdateNotebookInstanceLifecycleConfigRequest(this);
        }
    }

    public static interface Builder
    extends SageMakerRequest.Builder,
    CopyableBuilder<Builder, UpdateNotebookInstanceLifecycleConfigRequest> {
        public Builder notebookInstanceLifecycleConfigName(String var1);

        public Builder onCreate(Collection<NotebookInstanceLifecycleHook> var1);

        public Builder onCreate(NotebookInstanceLifecycleHook ... var1);

        public Builder onCreate(Consumer<NotebookInstanceLifecycleHook.Builder> ... var1);

        public Builder onStart(Collection<NotebookInstanceLifecycleHook> var1);

        public Builder onStart(NotebookInstanceLifecycleHook ... var1);

        public Builder onStart(Consumer<NotebookInstanceLifecycleHook.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

