/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.sagemaker.model.AssemblyType;
import software.amazon.awssdk.services.sagemaker.transform.TransformOutputMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TransformOutput
implements StructuredPojo,
ToCopyableBuilder<Builder, TransformOutput> {
    private final String s3OutputPath;
    private final String accept;
    private final String assembleWith;
    private final String kmsKeyId;

    private TransformOutput(BuilderImpl builder) {
        this.s3OutputPath = builder.s3OutputPath;
        this.accept = builder.accept;
        this.assembleWith = builder.assembleWith;
        this.kmsKeyId = builder.kmsKeyId;
    }

    public String s3OutputPath() {
        return this.s3OutputPath;
    }

    public String accept() {
        return this.accept;
    }

    public AssemblyType assembleWith() {
        return AssemblyType.fromValue(this.assembleWith);
    }

    public String assembleWithAsString() {
        return this.assembleWith;
    }

    public String kmsKeyId() {
        return this.kmsKeyId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.s3OutputPath());
        hashCode = 31 * hashCode + Objects.hashCode(this.accept());
        hashCode = 31 * hashCode + Objects.hashCode(this.assembleWithAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TransformOutput)) {
            return false;
        }
        TransformOutput other = (TransformOutput)obj;
        return Objects.equals(this.s3OutputPath(), other.s3OutputPath()) && Objects.equals(this.accept(), other.accept()) && Objects.equals(this.assembleWithAsString(), other.assembleWithAsString()) && Objects.equals(this.kmsKeyId(), other.kmsKeyId());
    }

    public String toString() {
        return ToString.builder((String)"TransformOutput").add("S3OutputPath", (Object)this.s3OutputPath()).add("Accept", (Object)this.accept()).add("AssembleWith", (Object)this.assembleWithAsString()).add("KmsKeyId", (Object)this.kmsKeyId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "S3OutputPath": {
                return Optional.ofNullable(clazz.cast(this.s3OutputPath()));
            }
            case "Accept": {
                return Optional.ofNullable(clazz.cast(this.accept()));
            }
            case "AssembleWith": {
                return Optional.ofNullable(clazz.cast(this.assembleWithAsString()));
            }
            case "KmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyId()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TransformOutputMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String s3OutputPath;
        private String accept;
        private String assembleWith;
        private String kmsKeyId;

        private BuilderImpl() {
        }

        private BuilderImpl(TransformOutput model) {
            this.s3OutputPath(model.s3OutputPath);
            this.accept(model.accept);
            this.assembleWith(model.assembleWith);
            this.kmsKeyId(model.kmsKeyId);
        }

        public final String getS3OutputPath() {
            return this.s3OutputPath;
        }

        @Override
        public final Builder s3OutputPath(String s3OutputPath) {
            this.s3OutputPath = s3OutputPath;
            return this;
        }

        public final void setS3OutputPath(String s3OutputPath) {
            this.s3OutputPath = s3OutputPath;
        }

        public final String getAccept() {
            return this.accept;
        }

        @Override
        public final Builder accept(String accept) {
            this.accept = accept;
            return this;
        }

        public final void setAccept(String accept) {
            this.accept = accept;
        }

        public final String getAssembleWith() {
            return this.assembleWith;
        }

        @Override
        public final Builder assembleWith(String assembleWith) {
            this.assembleWith = assembleWith;
            return this;
        }

        @Override
        public final Builder assembleWith(AssemblyType assembleWith) {
            this.assembleWith(assembleWith.toString());
            return this;
        }

        public final void setAssembleWith(String assembleWith) {
            this.assembleWith = assembleWith;
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        public TransformOutput build() {
            return new TransformOutput(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, TransformOutput> {
        public Builder s3OutputPath(String var1);

        public Builder accept(String var1);

        public Builder assembleWith(String var1);

        public Builder assembleWith(AssemblyType var1);

        public Builder kmsKeyId(String var1);
    }
}

