/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.sagemaker.model.CompressionType;
import software.amazon.awssdk.services.sagemaker.model.SplitType;
import software.amazon.awssdk.services.sagemaker.model.TransformDataSource;
import software.amazon.awssdk.services.sagemaker.transform.TransformInputMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TransformInput
implements StructuredPojo,
ToCopyableBuilder<Builder, TransformInput> {
    private final TransformDataSource dataSource;
    private final String contentType;
    private final String compressionType;
    private final String splitType;

    private TransformInput(BuilderImpl builder) {
        this.dataSource = builder.dataSource;
        this.contentType = builder.contentType;
        this.compressionType = builder.compressionType;
        this.splitType = builder.splitType;
    }

    public TransformDataSource dataSource() {
        return this.dataSource;
    }

    public String contentType() {
        return this.contentType;
    }

    public CompressionType compressionType() {
        return CompressionType.fromValue(this.compressionType);
    }

    public String compressionTypeAsString() {
        return this.compressionType;
    }

    public SplitType splitType() {
        return SplitType.fromValue(this.splitType);
    }

    public String splitTypeAsString() {
        return this.splitType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSource());
        hashCode = 31 * hashCode + Objects.hashCode(this.contentType());
        hashCode = 31 * hashCode + Objects.hashCode(this.compressionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.splitTypeAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TransformInput)) {
            return false;
        }
        TransformInput other = (TransformInput)obj;
        return Objects.equals(this.dataSource(), other.dataSource()) && Objects.equals(this.contentType(), other.contentType()) && Objects.equals(this.compressionTypeAsString(), other.compressionTypeAsString()) && Objects.equals(this.splitTypeAsString(), other.splitTypeAsString());
    }

    public String toString() {
        return ToString.builder((String)"TransformInput").add("DataSource", (Object)this.dataSource()).add("ContentType", (Object)this.contentType()).add("CompressionType", (Object)this.compressionTypeAsString()).add("SplitType", (Object)this.splitTypeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DataSource": {
                return Optional.ofNullable(clazz.cast(this.dataSource()));
            }
            case "ContentType": {
                return Optional.ofNullable(clazz.cast(this.contentType()));
            }
            case "CompressionType": {
                return Optional.ofNullable(clazz.cast(this.compressionTypeAsString()));
            }
            case "SplitType": {
                return Optional.ofNullable(clazz.cast(this.splitTypeAsString()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TransformInputMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private TransformDataSource dataSource;
        private String contentType;
        private String compressionType;
        private String splitType;

        private BuilderImpl() {
        }

        private BuilderImpl(TransformInput model) {
            this.dataSource(model.dataSource);
            this.contentType(model.contentType);
            this.compressionType(model.compressionType);
            this.splitType(model.splitType);
        }

        public final TransformDataSource.Builder getDataSource() {
            return this.dataSource != null ? this.dataSource.toBuilder() : null;
        }

        @Override
        public final Builder dataSource(TransformDataSource dataSource) {
            this.dataSource = dataSource;
            return this;
        }

        public final void setDataSource(TransformDataSource.BuilderImpl dataSource) {
            this.dataSource = dataSource != null ? dataSource.build() : null;
        }

        public final String getContentType() {
            return this.contentType;
        }

        @Override
        public final Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public final void setContentType(String contentType) {
            this.contentType = contentType;
        }

        public final String getCompressionType() {
            return this.compressionType;
        }

        @Override
        public final Builder compressionType(String compressionType) {
            this.compressionType = compressionType;
            return this;
        }

        @Override
        public final Builder compressionType(CompressionType compressionType) {
            this.compressionType(compressionType.toString());
            return this;
        }

        public final void setCompressionType(String compressionType) {
            this.compressionType = compressionType;
        }

        public final String getSplitType() {
            return this.splitType;
        }

        @Override
        public final Builder splitType(String splitType) {
            this.splitType = splitType;
            return this;
        }

        @Override
        public final Builder splitType(SplitType splitType) {
            this.splitType(splitType.toString());
            return this;
        }

        public final void setSplitType(String splitType) {
            this.splitType = splitType;
        }

        public TransformInput build() {
            return new TransformInput(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, TransformInput> {
        public Builder dataSource(TransformDataSource var1);

        default public Builder dataSource(Consumer<TransformDataSource.Builder> dataSource) {
            return this.dataSource((TransformDataSource)((TransformDataSource.Builder)TransformDataSource.builder().applyMutation(dataSource)).build());
        }

        public Builder contentType(String var1);

        public Builder compressionType(String var1);

        public Builder compressionType(CompressionType var1);

        public Builder splitType(String var1);

        public Builder splitType(SplitType var1);
    }
}

