/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.sagemaker.model.TransformS3DataSource;
import software.amazon.awssdk.services.sagemaker.transform.TransformDataSourceMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TransformDataSource
implements StructuredPojo,
ToCopyableBuilder<Builder, TransformDataSource> {
    private final TransformS3DataSource s3DataSource;

    private TransformDataSource(BuilderImpl builder) {
        this.s3DataSource = builder.s3DataSource;
    }

    public TransformS3DataSource s3DataSource() {
        return this.s3DataSource;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.s3DataSource());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TransformDataSource)) {
            return false;
        }
        TransformDataSource other = (TransformDataSource)obj;
        return Objects.equals(this.s3DataSource(), other.s3DataSource());
    }

    public String toString() {
        return ToString.builder((String)"TransformDataSource").add("S3DataSource", (Object)this.s3DataSource()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "S3DataSource": {
                return Optional.ofNullable(clazz.cast(this.s3DataSource()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TransformDataSourceMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private TransformS3DataSource s3DataSource;

        private BuilderImpl() {
        }

        private BuilderImpl(TransformDataSource model) {
            this.s3DataSource(model.s3DataSource);
        }

        public final TransformS3DataSource.Builder getS3DataSource() {
            return this.s3DataSource != null ? this.s3DataSource.toBuilder() : null;
        }

        @Override
        public final Builder s3DataSource(TransformS3DataSource s3DataSource) {
            this.s3DataSource = s3DataSource;
            return this;
        }

        public final void setS3DataSource(TransformS3DataSource.BuilderImpl s3DataSource) {
            this.s3DataSource = s3DataSource != null ? s3DataSource.build() : null;
        }

        public TransformDataSource build() {
            return new TransformDataSource(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, TransformDataSource> {
        public Builder s3DataSource(TransformS3DataSource var1);

        default public Builder s3DataSource(Consumer<TransformS3DataSource.Builder> s3DataSource) {
            return this.s3DataSource((TransformS3DataSource)((TransformS3DataSource.Builder)TransformS3DataSource.builder().applyMutation(s3DataSource)).build());
        }
    }
}

