/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.sagemaker.transform.TrainingJobStatusCountersMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TrainingJobStatusCounters
implements StructuredPojo,
ToCopyableBuilder<Builder, TrainingJobStatusCounters> {
    private final Integer completed;
    private final Integer inProgress;
    private final Integer retryableError;
    private final Integer nonRetryableError;
    private final Integer stopped;

    private TrainingJobStatusCounters(BuilderImpl builder) {
        this.completed = builder.completed;
        this.inProgress = builder.inProgress;
        this.retryableError = builder.retryableError;
        this.nonRetryableError = builder.nonRetryableError;
        this.stopped = builder.stopped;
    }

    public Integer completed() {
        return this.completed;
    }

    public Integer inProgress() {
        return this.inProgress;
    }

    public Integer retryableError() {
        return this.retryableError;
    }

    public Integer nonRetryableError() {
        return this.nonRetryableError;
    }

    public Integer stopped() {
        return this.stopped;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.completed());
        hashCode = 31 * hashCode + Objects.hashCode(this.inProgress());
        hashCode = 31 * hashCode + Objects.hashCode(this.retryableError());
        hashCode = 31 * hashCode + Objects.hashCode(this.nonRetryableError());
        hashCode = 31 * hashCode + Objects.hashCode(this.stopped());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TrainingJobStatusCounters)) {
            return false;
        }
        TrainingJobStatusCounters other = (TrainingJobStatusCounters)obj;
        return Objects.equals(this.completed(), other.completed()) && Objects.equals(this.inProgress(), other.inProgress()) && Objects.equals(this.retryableError(), other.retryableError()) && Objects.equals(this.nonRetryableError(), other.nonRetryableError()) && Objects.equals(this.stopped(), other.stopped());
    }

    public String toString() {
        return ToString.builder((String)"TrainingJobStatusCounters").add("Completed", (Object)this.completed()).add("InProgress", (Object)this.inProgress()).add("RetryableError", (Object)this.retryableError()).add("NonRetryableError", (Object)this.nonRetryableError()).add("Stopped", (Object)this.stopped()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Completed": {
                return Optional.ofNullable(clazz.cast(this.completed()));
            }
            case "InProgress": {
                return Optional.ofNullable(clazz.cast(this.inProgress()));
            }
            case "RetryableError": {
                return Optional.ofNullable(clazz.cast(this.retryableError()));
            }
            case "NonRetryableError": {
                return Optional.ofNullable(clazz.cast(this.nonRetryableError()));
            }
            case "Stopped": {
                return Optional.ofNullable(clazz.cast(this.stopped()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TrainingJobStatusCountersMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer completed;
        private Integer inProgress;
        private Integer retryableError;
        private Integer nonRetryableError;
        private Integer stopped;

        private BuilderImpl() {
        }

        private BuilderImpl(TrainingJobStatusCounters model) {
            this.completed(model.completed);
            this.inProgress(model.inProgress);
            this.retryableError(model.retryableError);
            this.nonRetryableError(model.nonRetryableError);
            this.stopped(model.stopped);
        }

        public final Integer getCompleted() {
            return this.completed;
        }

        @Override
        public final Builder completed(Integer completed) {
            this.completed = completed;
            return this;
        }

        public final void setCompleted(Integer completed) {
            this.completed = completed;
        }

        public final Integer getInProgress() {
            return this.inProgress;
        }

        @Override
        public final Builder inProgress(Integer inProgress) {
            this.inProgress = inProgress;
            return this;
        }

        public final void setInProgress(Integer inProgress) {
            this.inProgress = inProgress;
        }

        public final Integer getRetryableError() {
            return this.retryableError;
        }

        @Override
        public final Builder retryableError(Integer retryableError) {
            this.retryableError = retryableError;
            return this;
        }

        public final void setRetryableError(Integer retryableError) {
            this.retryableError = retryableError;
        }

        public final Integer getNonRetryableError() {
            return this.nonRetryableError;
        }

        @Override
        public final Builder nonRetryableError(Integer nonRetryableError) {
            this.nonRetryableError = nonRetryableError;
            return this;
        }

        public final void setNonRetryableError(Integer nonRetryableError) {
            this.nonRetryableError = nonRetryableError;
        }

        public final Integer getStopped() {
            return this.stopped;
        }

        @Override
        public final Builder stopped(Integer stopped) {
            this.stopped = stopped;
            return this;
        }

        public final void setStopped(Integer stopped) {
            this.stopped = stopped;
        }

        public TrainingJobStatusCounters build() {
            return new TrainingJobStatusCounters(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, TrainingJobStatusCounters> {
        public Builder completed(Integer var1);

        public Builder inProgress(Integer var1);

        public Builder retryableError(Integer var1);

        public Builder nonRetryableError(Integer var1);

        public Builder stopped(Integer var1);
    }
}

