/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.sagemaker.transform.ResourceLimitsMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ResourceLimits
implements StructuredPojo,
ToCopyableBuilder<Builder, ResourceLimits> {
    private final Integer maxNumberOfTrainingJobs;
    private final Integer maxParallelTrainingJobs;

    private ResourceLimits(BuilderImpl builder) {
        this.maxNumberOfTrainingJobs = builder.maxNumberOfTrainingJobs;
        this.maxParallelTrainingJobs = builder.maxParallelTrainingJobs;
    }

    public Integer maxNumberOfTrainingJobs() {
        return this.maxNumberOfTrainingJobs;
    }

    public Integer maxParallelTrainingJobs() {
        return this.maxParallelTrainingJobs;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.maxNumberOfTrainingJobs());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxParallelTrainingJobs());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceLimits)) {
            return false;
        }
        ResourceLimits other = (ResourceLimits)obj;
        return Objects.equals(this.maxNumberOfTrainingJobs(), other.maxNumberOfTrainingJobs()) && Objects.equals(this.maxParallelTrainingJobs(), other.maxParallelTrainingJobs());
    }

    public String toString() {
        return ToString.builder((String)"ResourceLimits").add("MaxNumberOfTrainingJobs", (Object)this.maxNumberOfTrainingJobs()).add("MaxParallelTrainingJobs", (Object)this.maxParallelTrainingJobs()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MaxNumberOfTrainingJobs": {
                return Optional.ofNullable(clazz.cast(this.maxNumberOfTrainingJobs()));
            }
            case "MaxParallelTrainingJobs": {
                return Optional.ofNullable(clazz.cast(this.maxParallelTrainingJobs()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ResourceLimitsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer maxNumberOfTrainingJobs;
        private Integer maxParallelTrainingJobs;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceLimits model) {
            this.maxNumberOfTrainingJobs(model.maxNumberOfTrainingJobs);
            this.maxParallelTrainingJobs(model.maxParallelTrainingJobs);
        }

        public final Integer getMaxNumberOfTrainingJobs() {
            return this.maxNumberOfTrainingJobs;
        }

        @Override
        public final Builder maxNumberOfTrainingJobs(Integer maxNumberOfTrainingJobs) {
            this.maxNumberOfTrainingJobs = maxNumberOfTrainingJobs;
            return this;
        }

        public final void setMaxNumberOfTrainingJobs(Integer maxNumberOfTrainingJobs) {
            this.maxNumberOfTrainingJobs = maxNumberOfTrainingJobs;
        }

        public final Integer getMaxParallelTrainingJobs() {
            return this.maxParallelTrainingJobs;
        }

        @Override
        public final Builder maxParallelTrainingJobs(Integer maxParallelTrainingJobs) {
            this.maxParallelTrainingJobs = maxParallelTrainingJobs;
            return this;
        }

        public final void setMaxParallelTrainingJobs(Integer maxParallelTrainingJobs) {
            this.maxParallelTrainingJobs = maxParallelTrainingJobs;
        }

        public ResourceLimits build() {
            return new ResourceLimits(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ResourceLimits> {
        public Builder maxNumberOfTrainingJobs(Integer var1);

        public Builder maxParallelTrainingJobs(Integer var1);
    }
}

